/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.log.SALogger;
import com.blixx.server.EventOperations;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.db.DeleteTask;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.Condition;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.TextAttribute;
import com.blixx.shared.jobs.UnsupportedTypeException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AutoArchiveDuplicatesJob
extends ServerJob {
    private static int m_keepIndicationsCount = 2;
    public static final String JOB_NAME = "Auto Archive Duplicates";
    public static final String KEEPINDICATIONS_COUNT = "keepIndicationsCount";
    public static final String UNPARSABLE_KEEP_INDI_COUNT_ATTRIBUTE_MUST_BE_INTEGER = "Unparsable. Attribute Keep Indications count must be integer";
    public static final String KEEP_INDI_COUNT_VALUE_LESS_THAN_0_TASK_DEACTIVATED = "\"Keep last Indications count\" value less than 0! Task deactivated";
    public static String FILTER_GROUP = "Filter";
    public static final String POLICY_CONDITION_LIST = "policyConditionList";
    private SALogger m_logger = new SALogger();
    protected String m_lastResult = "-";
    private Map<String, Map<String, String>> m_policyCondition_map = new HashMap<String, Map<String, String>>();
    private Map<String, TreeMap<Long, SEvent>> m_eventsBySource = new HashMap<String, TreeMap<Long, SEvent>>();
    private List<String> m_eventIDsToKeep = new LinkedList<String>();
    private List<String> m_eventIDsToArchive = new LinkedList<String>();

    public AutoArchiveDuplicatesJob(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        this.m_lastResult = "-";
        return true;
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    @Override
    public JobConfig getJobConfig() {
        return super.getJobConfig();
    }

    @Override
    public boolean onGetData() {
        if (m_keepIndicationsCount >= 0) {
            RTLogger.print(2, "Auto Archive all Closed Duplicates");
            try {
                this.initJobConfig();
                this.filterEventsBySource();
                this.findDuplicates();
                this.archiveDuplicates();
                RTLogger.print(2, "Archived " + this.m_eventIDsToArchive.size() + " duplicate indications");
            }
            catch (Throwable e) {
                RTLogger.print(2, "Error running AutoArchiveDuplicatesJob", e);
            }
            this.m_lastResult = "Archived " + this.m_eventIDsToArchive.size() + " duplicate indications";
        } else {
            this.m_lastResult = "Run rejected, \"Keep last Indications count\" is less than 0!";
            RTLogger.print(2, "AutoArchiveDuplicatesJob: Run rejected, \"Keep last Indications count\" is less than 0!");
        }
        try {
            DeleteTask dt = new DeleteTask(ServerEngine.getInstance().getDB());
            Thread tr = new Thread((Runnable)dt, "ArchiveTask");
            tr.start();
        }
        catch (Throwable e) {
            RTLogger.print(2, "Error running AutoArchiveDuplicatesJob - error in DeleteTask()", e);
        }
        return true;
    }

    @Override
    public void setJobConfig(JobConfig jc) throws InvalidConfig {
        super.setJobConfig(jc);
        try {
            List<String> messages = this.initJobConfig();
            if (messages != null && messages.size() > 0) {
                for (String str : messages) {
                    this.m_logger.print(1, str);
                }
            }
        }
        catch (Throwable e) {
            RTLogger.print(2, "AutoArchiveDuplicatesJob initialization failed", e);
            throw new InvalidConfig(e.getMessage());
        }
    }

    private void filterEventsBySource() {
        this.m_eventsBySource.clear();
        EventOperations EO = ServerEngine.getInstance().getEventsRouter().getEventOperations();
        for (SEventFwd se : EO.getAcknowledgedIndications(false)) {
            TreeMap<Object, Object> eventList;
            String source = se.getSource();
            boolean matched = false;
            if (source.equals("BOOM_SERVER")) {
                Map<String, String> nodes;
                String node = se.getNode();
                if (this.m_policyCondition_map.containsKey(source) && ((nodes = this.m_policyCondition_map.get(source)).containsKey("*") || nodes.containsKey(node))) {
                    matched = true;
                }
            } else if (source.startsWith("Message") || source.startsWith("Monitor")) {
                Map<String, String> conditionIDs;
                String[] arr = source.split("\\Q:\\E");
                String polName = arr[1];
                String condID = arr[2];
                if (this.m_policyCondition_map.containsKey(polName) && ((conditionIDs = this.m_policyCondition_map.get(polName)).containsKey("*") || conditionIDs.containsKey(condID))) {
                    matched = true;
                }
            }
            if (!matched) continue;
            if (this.m_eventsBySource.containsKey(source)) {
                eventList = this.m_eventsBySource.get(source);
                eventList.put(se.getSTime(), se);
                this.m_eventsBySource.put(source, eventList);
                continue;
            }
            eventList = new TreeMap(Collections.reverseOrder());
            eventList.put(se.getSTime(), se);
            this.m_eventsBySource.put(source, eventList);
        }
    }

    public void findDuplicates() {
        for (String source : this.m_eventsBySource.keySet()) {
            TreeMap eventsBySource = new TreeMap(Collections.reverseOrder());
            eventsBySource.putAll((Map)this.m_eventsBySource.get(source));
            while (eventsBySource.size() > 0) {
                HashSet<Long> processedEvents = new HashSet<Long>();
                int dupCounter = 0;
                Long firstEventServerTime = (Long)eventsBySource.firstKey();
                SEvent newestEvent = (SEvent)eventsBySource.get(firstEventServerTime);
                Iterator it2 = eventsBySource.entrySet().iterator();
                while (it2.hasNext()) {
                    SEvent event = null;
                    try {
                        Map.Entry me = it2.next();
                        Long sTime = (Long)me.getKey();
                        event = (SEvent)me.getValue();
                        if (newestEvent.getID().equals(event.getID())) {
                            processedEvents.add(sTime);
                            this.m_eventIDsToKeep.add(event.getID());
                            continue;
                        }
                        if (!this.isDuplicateEvent(newestEvent, event, source)) continue;
                        processedEvents.add(sTime);
                        if (++dupCounter >= m_keepIndicationsCount) {
                            this.m_eventIDsToArchive.add(event.getID());
                            continue;
                        }
                        this.m_eventIDsToKeep.add(event.getID());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                eventsBySource.keySet().removeAll(processedEvents);
            }
        }
    }

    private void archiveDuplicates() {
        if (this.m_eventIDsToArchive.size() > 0) {
            ServerEngine.getInstance().getEventsRouter().archive2(this.m_eventIDsToArchive, false);
            RTLogger.print(4, "Auto Archived " + this.m_eventIDsToArchive.size());
            List<SlaveServerCard> slaves = ServerEngine.getInstance().getSlaves();
            for (SlaveServerCard ssc : slaves) {
                if (ssc.getScenario() == 0) {
                    ssc.getServerClient().start("DELETE_MSG", null, this.m_eventIDsToArchive.toArray(new String[0]));
                    continue;
                }
                if (ssc.getScenario() > 2) continue;
                ssc.getServerClient().start("ARCH_MSG", null, this.m_eventIDsToArchive.toArray(new String[0]));
            }
        }
    }

    private List<String> initJobConfig() throws Exception {
        TextAttribute textAttribute2;
        TextAttribute textAttribute1;
        LinkedList<String> messages = new LinkedList<String>();
        messages.add(String.valueOf(this.getClass()));
        JobConfig jc = this.getJobConfig();
        TextAttribute textAttribute = (TextAttribute)jc.getJobGroup().getAttribute(KEEPINDICATIONS_COUNT);
        if (textAttribute != null) {
            try {
                m_keepIndicationsCount = Integer.parseInt(textAttribute.getValue());
            }
            catch (Throwable e) {
                messages.add(ERROR + "invalid value for attribute: keepIndicationsCount");
                throw new InvalidConfig(UNPARSABLE_KEEP_INDI_COUNT_ATTRIBUTE_MUST_BE_INTEGER);
            }
        } else {
            throw new InvalidConfig(UNPARSABLE_KEEP_INDI_COUNT_ATTRIBUTE_MUST_BE_INTEGER);
        }
        this.m_policyCondition_map.clear();
        Group archiveGroup = jc.getConfig().getGroup(FILTER_GROUP);
        if (archiveGroup == null) {
            archiveGroup = new Group(FILTER_GROUP);
            jc.getConfig().addGroup(archiveGroup);
        }
        if ((textAttribute1 = (TextAttribute)archiveGroup.getAttribute("description")) == null) {
            textAttribute1 = new TextAttribute("description", "", "Description");
            textAttribute1.setEditable(false);
            textAttribute1.setEnabled(true);
            try {
                textAttribute1.setValue("One PolicyName:ConditionID pair per line!");
            }
            catch (UnsupportedTypeException unsupportedTypeException) {
                // empty catch block
            }
            archiveGroup.addAttribute(textAttribute1);
        }
        if ((textAttribute2 = (TextAttribute)archiveGroup.getAttribute(POLICY_CONDITION_LIST)) != null) {
            String[] filterList;
            String text = textAttribute2.getValue();
            if (text != null && text.trim().length() > 0 && (filterList = text.split("[\r\n]+")) != null && filterList.length > 0) {
                for (String filter : filterList) {
                    try {
                        String[] arr = filter.split("\\Q:\\E");
                        if (arr != null && arr.length == 2) {
                            Map<Object, Object> conditionList;
                            List<String> errorMsg;
                            String polName = arr[0].trim();
                            String condID = arr[1].trim();
                            if (!polName.equals("BOOM_SERVER") && !(errorMsg = this.doesPolicyAndConditionExist(polName, condID)).isEmpty()) {
                                messages.addAll(errorMsg);
                                continue;
                            }
                            if (this.m_policyCondition_map.containsKey(polName)) {
                                conditionList = this.m_policyCondition_map.get(polName);
                                if (condID.equals("*")) {
                                    this.addAllConditionIDs(polName, conditionList);
                                    continue;
                                }
                                if (conditionList.containsKey("*")) continue;
                                conditionList.put(condID, null);
                                this.m_policyCondition_map.put(polName, conditionList);
                                continue;
                            }
                            conditionList = new HashMap<String, Object>();
                            conditionList.put(condID, null);
                            this.m_policyCondition_map.put(polName, conditionList);
                            continue;
                        }
                        throw new Exception("Invalid Policy:Condition Filter: " + String.valueOf(arr));
                    }
                    catch (Throwable e) {
                        throw new Exception("Invalid Policy:Condition Filter: " + filter);
                    }
                }
            }
        } else {
            textAttribute2 = new TextAttribute(POLICY_CONDITION_LIST, "", "Policy:Condition Filter");
            textAttribute2.setEditable(true);
            textAttribute2.setEnabled(true);
            textAttribute2.setHeight(200);
            archiveGroup.addAttribute(textAttribute2);
        }
        return messages;
    }

    private List<String> doesPolicyAndConditionExist(String polName, String condID) {
        Condition condition;
        LinkedList<String> messages = new LinkedList<String>();
        MsgPolicy msgPolicy = null;
        Policy policy = ServerEngine.getInstance().getPolicyRepository().getMonitorPolicy(polName);
        if (policy == null) {
            MsgCondition condition2;
            msgPolicy = ServerEngine.getInstance().getPolicyRepository().getMessagePolicy(polName);
            if (msgPolicy == null) {
                messages.add(ERROR + "Policy not found. Ignored name: " + polName);
            } else if (!condID.equals("*") && (condition2 = (MsgCondition)msgPolicy.getConditions().getCondition(condID)) == null) {
                messages.add(ERROR + "Condition for Indication Policy " + polName + " not found. Ignored conditionID: " + condID);
            }
        } else if (!condID.equals("*") && (condition = (Condition)policy.getConditions().getCondition(condID)) == null) {
            messages.add(ERROR + "Condition for Monitor Policy " + polName + " not found. Ignored conditionID: " + condID);
        }
        return messages;
    }

    private Map<String, String> addAllConditionIDs(String polName, Map<String, String> conditionList) {
        block3: {
            block2: {
                conditionList.clear();
                Policy policy = ServerEngine.getInstance().getPolicyRepository().getMonitorPolicy(polName);
                if (policy == null) break block2;
                List condList = policy.getConditions().getConditionList();
                for (int i = 0; i < condList.size(); ++i) {
                    String condID = ((Condition)condList.get(i)).getConditionId();
                    conditionList.put(condID, null);
                }
                break block3;
            }
            MsgPolicy msgPolicy = ServerEngine.getInstance().getPolicyRepository().getMessagePolicy(polName);
            if (msgPolicy == null) break block3;
            List condList = msgPolicy.getConditions().getConditionList();
            for (int i = 0; i < condList.size(); ++i) {
                String condID = ((MsgCondition)condList.get(i)).getConditionId();
                conditionList.put(condID, null);
            }
        }
        return conditionList;
    }

    private boolean isDuplicateEvent(SEvent se1, SEvent se2, String source) {
        boolean isEqual = false;
        if (source.equals("BOOM_SERVER")) {
            if (se1.getGroup().equals(se2.getGroup())) {
                isEqual = true;
            }
        } else {
            isEqual = this.getStringBuilder(se1).toString().equals(this.getStringBuilder(se2).toString());
        }
        return isEqual;
    }

    private StringBuilder getStringBuilder(SEvent se) {
        StringBuilder sb = new StringBuilder();
        sb.append(se.getApplication()).append(se.getGroup()).append(se.getObject()).append(se.getNode()).append(se.getAgentNode()).append(se.getSeverity());
        return sb;
    }

    @Override
    public boolean setActive(boolean isActive) {
        if (m_keepIndicationsCount < 0) {
            this.m_lastResult = KEEP_INDI_COUNT_VALUE_LESS_THAN_0_TASK_DEACTIVATED;
            this.getJobConfig().setActive(false);
        } else {
            this.getJobConfig().setActive(isActive);
        }
        return this.getJobConfig().getActive();
    }

    public void setEvents(Map<String, TreeMap<Long, SEvent>> events) {
        this.m_eventsBySource = events;
    }

    public List<String> getDuplicateEvents() {
        return this.m_eventIDsToArchive;
    }

    public List<String> getEventsToKeep() {
        return this.m_eventIDsToKeep;
    }
}

