/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.server.EventOperations;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerProperties;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.db.DeleteTask;
import com.blixx.server.jobs.ServerJob;
import com.blixx.server.jobs.ServerJobManager;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.TextAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class AutoArchiveJob
extends ServerJob {
    public static final String JOB_NAME = "Auto Archive indications";
    public static final String UNPARSABLE_MAX_HOURS_ATTRIBUTE_MUST_BE_INTEGER = "Unparsable. Max hours attribute must be integer";
    public static final String MAX_HOURS_VALUE_LESS_THAN_1_HOUR_TASK_DEACTIVATED = "\"Max hours\" value less than 1 hour! Task deactivated";
    public static final String MAXDAYS = "MAXDAYS";
    public static final String MAXHOURS = "MAXHOURS";
    protected static final int m_maxHoursDefault = 1440;
    protected int m_maxHours = 1440;
    protected String m_lastResult = "-";
    protected static ServerJob m_this = null;

    public static synchronized ServerJob getAutoArchiveJob() {
        if (m_this == null) {
            JobConfig jc = new JobConfig();
            jc.setJobName(JOB_NAME);
            jc.setJobDescription("Automatically Archives closed indications older than specified amount of \"Max hours\"\nValue of \"Max hours\" must be bigger 0.\nTo deactivate this task set \"Max hours\" value to 0 or -1");
            jc.setSchedulingInterval("d0:23:55:00");
            jc.setClassName(AutoArchiveJob.class.getCanonicalName());
            int maxHours = 1440;
            int days = ServerProperties.getArchiveDays();
            if (days > -1) {
                maxHours = days * 24;
            }
            jc.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + maxHours, "Max hours"));
            jc.setActive(maxHours > 0);
            jc.getJobGroup().getAttribute("jobname").setEditable(false);
            jc.getJobGroup().getAttribute("jobDescription").setEditable(false);
            jc.getJobGroup().getAttribute("class").setEditable(false);
            jc.getJobGroup().getAttribute("active").setEditable(false);
            CheckAttribute ac = new CheckAttribute("STOREXML", true, "Store XML file");
            ac.setEditable(false);
            ac.setEnabled(false);
            jc.getJobGroup().addAttribute(ac);
            try {
                m_this = new AutoArchiveJob(jc);
            }
            catch (Throwable e) {
                RTLogger.print(2, "AutoArchiveJob initialization failed", e);
            }
            AutoArchiveJob.updateBoomProps();
        }
        return m_this;
    }

    public AutoArchiveJob(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        this.m_lastResult = "-";
        this.convertToMaxHoursIfNeccessary();
        return true;
    }

    private void convertToMaxHoursIfNeccessary() {
        boolean xmlChanged = false;
        JobConfig jc = super.getJobConfig();
        TextAttribute attr = (TextAttribute)jc.getJobGroup().getAttribute(MAXDAYS);
        if (attr != null) {
            try {
                this.m_maxHours = Integer.parseInt(attr.getValue()) * 24;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            jc.getJobGroup().removeAttribute(MAXDAYS);
            jc.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + this.m_maxHours, "Max hours"));
            xmlChanged = true;
        } else {
            TextAttribute attr2 = (TextAttribute)jc.getJobGroup().getAttribute(MAXHOURS);
            if (attr2 != null) {
                try {
                    this.m_maxHours = Integer.parseInt(String.valueOf(jc.getJobGroup().getAttribute(MAXHOURS).getValue()));
                }
                catch (NumberFormatException e) {
                    if (jc.getJobGroup().getAttribute(MAXHOURS) == null) {
                        this.m_maxHours = 1440;
                        jc.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + this.m_maxHours, "Max hours"));
                        xmlChanged = true;
                    }
                }
            } else {
                jc.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + this.m_maxHours, "Max hours"));
                xmlChanged = true;
            }
        }
        this.setActive(jc.getActive());
        if (xmlChanged) {
            ServerJobManager.getInstance().storeConfig(jc);
        }
        AutoArchiveJob.updateBoomProps();
    }

    private static void updateBoomProps() {
        ServerProperties.setArchiveDays(-1);
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    @Override
    public JobConfig getJobConfig() {
        return super.getJobConfig();
    }

    @Override
    public boolean onGetData() {
        if (this.m_maxHours >= 1) {
            long ArchiveDeltaMilliseconds = 3600000L * (long)this.m_maxHours;
            long time = System.currentTimeMillis();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String deleteTime = sdf.format(new Date(time - ArchiveDeltaMilliseconds));
            RTLogger.print(2, "Auto Archive all up to " + deleteTime);
            LinkedList<String> idToArchive = new LinkedList<String>();
            EventOperations EO = ServerEngine.getInstance().getEventsRouter().getEventOperations();
            for (SEventFwd se : EO.getAllClosed()) {
                if (time - se.getSTime() < ArchiveDeltaMilliseconds) continue;
                idToArchive.add(se.getID());
            }
            int size = idToArchive.size();
            if (size > 0) {
                ServerEngine.getInstance().getEventsRouter().archive2(idToArchive, false);
                RTLogger.print(4, "Auto Archived " + size);
                List<SlaveServerCard> slaves = ServerEngine.getInstance().getSlaves();
                for (SlaveServerCard ssc : slaves) {
                    if (ssc.getScenario() == 0) {
                        ssc.getServerClient().start("DELETE_MSG", null, idToArchive.toArray(new String[0]));
                        continue;
                    }
                    if (ssc.getScenario() > 2) continue;
                    ssc.getServerClient().start("ARCH_MSG", null, idToArchive.toArray(new String[0]));
                }
            }
            this.m_lastResult = "Archived " + size + " indications";
        } else {
            this.m_lastResult = "Run rejected, \"Max hours\" value less than 1 hour!";
        }
        try {
            DeleteTask dt = new DeleteTask(ServerEngine.getInstance().getDB());
            Thread tr = new Thread((Runnable)dt, "ArchiveTask");
            tr.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        super.setJobConfig(config);
        TextAttribute attribute = (TextAttribute)config.getJobGroup().getAttribute(MAXDAYS);
        if (attribute != null) {
            try {
                this.m_maxHours = Integer.parseInt(attribute.getValue()) * 24;
            }
            catch (NumberFormatException e) {
                throw new InvalidConfig(UNPARSABLE_MAX_HOURS_ATTRIBUTE_MUST_BE_INTEGER);
            }
            config.getJobGroup().removeAttribute(MAXDAYS);
            config.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + this.m_maxHours, "Max hours"));
        } else {
            try {
                this.m_maxHours = Integer.parseInt(String.valueOf(config.getJobGroup().getAttribute(MAXHOURS).getValue()));
            }
            catch (NumberFormatException e) {
                if (config.getJobGroup().getAttribute(MAXHOURS) == null) {
                    this.m_maxHours = 1440;
                    config.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + this.m_maxHours, "Max hours"));
                }
                throw new InvalidConfig(UNPARSABLE_MAX_HOURS_ATTRIBUTE_MUST_BE_INTEGER);
            }
        }
        this.setActive(config.getActive());
        AutoArchiveJob.updateBoomProps();
    }

    @Override
    public boolean setActive(boolean isActive) {
        if (this.m_maxHours < 1) {
            this.m_lastResult = MAX_HOURS_VALUE_LESS_THAN_1_HOUR_TASK_DEACTIVATED;
            this.getJobConfig().setActive(false);
        } else {
            this.getJobConfig().setActive(true);
        }
        return this.getJobConfig().getActive();
    }
}

