/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.server.ServerEngine;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.TextAttribute;
import com.blixx.shared.utils.VersionComparator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;

public class InventoryCleanUpJob
extends ServerJob {
    public static final String NUMBER_OF_FILES = "NUMBER-OF-FILES";
    public static final String NUMBER = "Number";
    public static int deletedFileCount = 0;
    public StringBuffer lastResult = new StringBuffer();
    private String numOfFiles = "";
    protected ArrayList<String> m_agentIDs = new ArrayList();

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        super.setJobConfig(config);
        try {
            this.initVariables();
        }
        catch (Exception e) {
            throw new InvalidConfig(e.getMessage());
        }
    }

    public InventoryCleanUpJob(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onStartRun() {
        this.lastResult = new StringBuffer();
        return super.onStartRun();
    }

    @Override
    public boolean onStopRun() {
        this.m_agentIDs.clear();
        deletedFileCount = 0;
        RTLogger.print(1, "Job finished: Inventory Clean Up \n");
        return super.onStopRun();
    }

    @Override
    public boolean onGetData() {
        this.m_agentIDs.addAll(ServerEngine.getInstance().getAgentRepository().getAgentCards().keySet());
        String inventoryPath = "srv/inventory";
        File inventoryFolder = new File(inventoryPath);
        File[] listOfinventoryFiles = inventoryFolder.listFiles();
        ArrayList<Object> inventoryFileNames = new ArrayList();
        if (listOfinventoryFiles.length == 0) {
            this.lastResult.append("No file is present for deletion");
            return false;
        }
        for (String agentId : this.m_agentIDs) {
            inventoryFileNames = this.extractAgentRelatedFileName(listOfinventoryFiles, agentId);
            if (inventoryFileNames.isEmpty()) continue;
            ArrayList<String> versions = new ArrayList<String>();
            for (File file : inventoryFileNames) {
                if (file.getName().length() <= 36) continue;
                versions.add(file.getName().substring(37));
            }
            Collections.sort(versions, new VersionComparator());
            for (int i = Integer.parseInt(this.numOfFiles); i < versions.size(); ++i) {
                this.deleteFile(inventoryFileNames, agentId, (String)versions.get(i), this.lastResult);
            }
        }
        inventoryFileNames.clear();
        for (File file : listOfinventoryFiles) {
            try {
                String string = file.getName().substring(0, 36);
                UUID uuid = UUID.fromString(string);
                if (this.m_agentIDs.contains(string)) continue;
                inventoryFileNames.add(file);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.deleteFile(inventoryFileNames, null, null, this.lastResult);
        this.lastResult.append("The number of file deleted : " + deletedFileCount);
        return super.onGetData();
    }

    public void deleteFile(ArrayList<File> listOfinventoryFiles, String id, String version, StringBuffer lastResult) {
        if (null != listOfinventoryFiles) {
            for (File file : listOfinventoryFiles) {
                if (null == version) {
                    if (!file.delete()) {
                        lastResult.append(" Delete operation is failed for file :" + file.getName());
                    }
                    ++deletedFileCount;
                    continue;
                }
                if (!file.getName().endsWith(version)) continue;
                if (!file.delete()) {
                    lastResult.append(" Delete operation is failed for file :" + file.getName());
                }
                ++deletedFileCount;
                break;
            }
        }
    }

    private ArrayList<File> extractAgentRelatedFileName(File[] listOfinventoryFiles, String agentId) {
        ArrayList<File> inventoryFileNames = new ArrayList<File>();
        for (int i = 0; i < listOfinventoryFiles.length; ++i) {
            if (!listOfinventoryFiles[i].isFile() || !listOfinventoryFiles[i].getName().contains(agentId)) continue;
            inventoryFileNames.add(listOfinventoryFiles[i]);
        }
        return inventoryFileNames;
    }

    @Override
    public String getLastRunResult() {
        return this.lastResult.toString();
    }

    @Override
    public boolean onInit() throws Exception {
        this.initVariables();
        return false;
    }

    private void initVariables() throws Exception {
        JobConfig jc = super.getJobConfig();
        this.lastResult = new StringBuffer();
        Group specificJobConfig = jc.getConfig().getGroup(NUMBER_OF_FILES);
        TextAttribute num = (TextAttribute)specificJobConfig.getAttribute(NUMBER);
        if (num == null) {
            throw new InvalidConfig("Number is null");
        }
        this.numOfFiles = num.getValue();
    }
}

