/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.server.ServerEngine;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.jobs.JobConfig;
import java.util.LinkedList;

public class LostAndFoundJob
extends ServerJob {
    protected String m_lastResult = "-";
    protected static ServerJob m_this = null;

    public static synchronized ServerJob getLostAndFoundJob() {
        if (m_this == null) {
            JobConfig jc = new JobConfig();
            jc.setJobName("Find Lost Policies");
            jc.setJobDescription("Automatically detects Lost policies and add to the Policy Tree");
            jc.setSchedulingInterval("10m");
            jc.getJobGroup().getAttribute("scheduling").setEditable(true);
            jc.setClassName(LostAndFoundJob.class.getCanonicalName());
            jc.setActive(true);
            jc.getJobGroup().getAttribute("jobname").setEditable(true);
            jc.getJobGroup().getAttribute("jobDescription").setEditable(true);
            jc.getJobGroup().getAttribute("class").setEditable(false);
            jc.getJobGroup().getAttribute("active").setEditable(true);
            try {
                m_this = new LostAndFoundJob(jc);
            }
            catch (Throwable e) {
                RTLogger.print(2, "LostAndFoundJob initialization failed", e);
            }
        }
        return m_this;
    }

    public LostAndFoundJob(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    @Override
    public JobConfig getJobConfig() {
        return super.getJobConfig();
    }

    @Override
    public boolean onGetData() {
        LinkedList<String> dummyList = new LinkedList<String>();
        String res = ServerEngine.getInstance().getPolicyRepository().checkLostAndFound(dummyList);
        if (res.length() > 5) {
            this.m_lastResult = res;
            ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETPOLICIES");
        } else {
            this.m_lastResult = "OK";
        }
        return true;
    }
}

