/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.SALogger;
import com.blixx.sa.perf.DDFField;
import com.blixx.server.ServerEngine;
import com.blixx.server.db.Connector;
import com.blixx.server.db.DB;
import com.blixx.server.db.DBException;
import com.blixx.server.db.OraConnector;
import com.blixx.server.jobs.FileNameFilter;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.jobs.AbstractAttribute;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.MapAttribute;
import com.blixx.shared.jobs.PasswordAttribute;
import com.blixx.shared.jobs.TextAttribute;
import com.blixx.shared.utils.HashMapArray;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PMSExport
extends ServerJob {
    public static final String WARNING = "WARNING";
    public static final String VERSION = "2.66";
    public static final String YY_M_MDD_H_HMM = "yyMMddHHmm";
    private static final String _TIME = "_TIME";
    public static String MAX_PMS_STATUS = "MAX_PMS_STATUS";
    public static String INTERVL = "PMS_INTERVL";
    public static String PMS_STATUS = "PMS_STATUS";
    public static String SUMMARY = "PMS_SUMMARY";
    public static String STIME_AS_TIME_FORMATTED = "PMS_TIME_FORMATTED";
    public static final String OBJ_PREFIX = "OBJ";
    public static final String NE_ID = "NE_ID";
    public static final String NULL = "_NULL_";
    public static String COL_TIME = "_TIME";
    public static String STIME = "STIME";
    public static final String ATTR_FILE_MASK_DATE_FORMAT = "fileMaskDateFormat";
    public static final String ATTR_FILE_MASK = "fileMask";
    public static final String ATTR_IGNORE_LAST_MIN = "ignoreLastMin";
    public static final String ATTR_INTERVAL_MIN = "intervalMin";
    public static final String ATTR_MAX_HISTORY_MIN = "maxHistoryMin";
    public static final String ATTR_WORKING_DIR = "workingDir";
    public static final String ATTR_SFTP_HOST = "sftpHost";
    public static final String ATTR_SFTP_PORT = "sftpPort";
    public static final String ATTR_SFTP_USER = "sftpUser";
    public static final String ATTR_SFTP_PASS = "sftpPass";
    public static final String ATTR_SFTP_PRIV_KEY = "sftpPrivKey";
    public static final String ATTR_SFTP_PUB_KEY = "sftpPubKey";
    public static final String ATTR_SFTP_PRIV_KEY_PASS = "sftpPrivKeyPass";
    public static final String ATTR_SFTP_DIR = "sftpDir";
    public static final String GROUP_PMSEXPORT = "PMSExport";
    public static final String $DATE = "<$DATE>";
    private static final String $EXTCLASS = "<$EXTCLASS>";
    private static final String MAP_ATTRIBUTE = "map";
    private static final String TABLE_NAME_ATTRIBUTE = "tableName";
    private static final String TABLE_PREPROCESSING_SQL = "preprocessingSQL";
    private static final String MAPPING_GROUP = "PMSTablesMapping";
    private List<String> m_dbTables = new LinkedList<String>();
    private Map<String, Mapping> m_export = new LinkedHashMap<String, Mapping>();
    private String m_workingdir = null;
    private int m_maxHistoryMin = 60;
    private int m_ignoreLastMin = 5;
    private int m_intervalMin = 5;
    private String m_fileMask = "<$DATE>.<$BOOM_SERVER>.Z5_<$EXTCLASS>_BO10";
    private String m_fileMaskDateFormat = "yyMMddHHmm";
    private File m_dir;
    private static Connector m_connection;
    private static boolean m_isOracle;
    private SALogger m_logger = new SALogger();
    public String m_lastResult = "-";
    public String m_sftpHost = null;
    public int m_sftpPort = 22;
    public String m_sftpUser = null;
    public String m_sftpPass = null;
    public String m_sftpDir = ".";
    public String m_sftpPrivateKey = null;
    public String m_sftpPublicKey = null;
    public String m_sftpPrivateKeyPass = null;

    public PMSExport(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        this.initVariables();
        this.initLogfile();
        this.refreshPerfDBMapping();
        this.printValues();
        this.m_logger.print(2, String.valueOf(this.getClass()));
        this.m_logger.print(1, "init done");
        return true;
    }

    public void initLogfile() {
        this.m_logger.setMaxCount(super.getJobConfig().getLogcount());
        this.m_logger.setMaxSize(0x100000L * (long)super.getJobConfig().getLogsize());
        this.m_logger.setDir(this.m_workingdir, "PMSExport_");
        this.m_logger.setLevel(super.getJobConfig().getLoglevel());
    }

    private void printValues() {
        this.m_logger.print(1, "version: 2.66");
        this.m_logger.print(1, "working dir: " + this.m_workingdir);
        this.m_logger.print(1, "max history (minutes): " + this.m_maxHistoryMin);
        this.m_logger.print(1, "ignore latest (minutes): " + this.m_ignoreLastMin);
        this.m_logger.print(1, "summarization interval (minutes): " + this.m_intervalMin);
        this.m_logger.print(1, "scheduling interval (minutes): " + this.getInterval() / 60000L);
        this.m_logger.print(1, "filemask: " + this.m_fileMask);
        this.m_logger.print(1, "filemask Date format: " + this.m_fileMaskDateFormat);
        this.m_logger.print(1, "known perf classes: " + this.getPerfTables().size());
        this.m_logger.print(1, "known mappings: " + this.m_export.size());
    }

    public void initVariables() throws Exception {
        JobConfig jc = super.getJobConfig();
        Group specificJobConfig = jc.getConfig().getGroup(GROUP_PMSEXPORT);
        TextAttribute aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_WORKING_DIR);
        if (aa == null) {
            throw new InvalidConfig("workingDir is null");
        }
        this.m_workingdir = aa.getValue();
        this.m_dir = new File(this.m_workingdir);
        if (!this.m_dir.exists()) {
            if (this.m_dir.mkdirs()) {
                this.m_logger.print(1, "working directory created " + this.m_dir.getPath());
            } else {
                this.m_lastResult = ERROR + "creating working directory " + this.m_dir.getPath();
                this.m_logger.print(1, this.m_lastResult);
            }
        }
        if ((aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_MAX_HISTORY_MIN)) == null) {
            throw new InvalidConfig("maxHistoryMin is null");
        }
        this.m_maxHistoryMin = Integer.parseInt(aa.getValue());
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_IGNORE_LAST_MIN);
        if (aa == null) {
            throw new InvalidConfig("ignoreLastMin is null");
        }
        this.m_ignoreLastMin = Integer.parseInt(aa.getValue());
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_INTERVAL_MIN);
        if (aa == null) {
            throw new InvalidConfig("intervalMin is null");
        }
        this.m_intervalMin = Integer.parseInt(aa.getValue());
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_FILE_MASK);
        if (aa == null) {
            throw new InvalidConfig("fileMask is null");
        }
        this.m_fileMask = aa.getValue();
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_FILE_MASK_DATE_FORMAT);
        if (aa == null) {
            throw new InvalidConfig("fileMaskDateFormat is null");
        }
        try {
            new SimpleDateFormat(aa.getValue());
            this.m_fileMaskDateFormat = aa.getValue();
        }
        catch (Throwable e) {
            this.m_logger.print(1, "unsupported fileMaskDateFormat" + aa.getValue());
        }
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_SFTP_HOST);
        if (aa != null) {
            this.m_sftpHost = aa.getValue();
        }
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_SFTP_PORT);
        try {
            this.m_sftpPort = Integer.parseInt(aa.getValue());
        }
        catch (Exception e) {
            this.m_logger.print(1, "invalid sftpPort" + aa.getValue());
        }
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_SFTP_USER);
        if (aa != null) {
            this.m_sftpUser = aa.getValue();
        }
        PasswordAttribute passaa = (PasswordAttribute)specificJobConfig.getAttribute(ATTR_SFTP_PASS);
        if (passaa != null) {
            this.m_sftpPass = passaa.getValue();
        }
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_SFTP_PRIV_KEY);
        this.m_sftpPrivateKey = aa != null ? aa.getValue() : null;
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_SFTP_PUB_KEY);
        this.m_sftpPublicKey = aa != null ? aa.getValue() : null;
        passaa = (PasswordAttribute)specificJobConfig.getAttribute(ATTR_SFTP_PRIV_KEY_PASS);
        this.m_sftpPrivateKeyPass = passaa != null ? passaa.getValue() : null;
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_SFTP_DIR);
        if (aa != null) {
            this.m_sftpDir = aa.getValue();
        }
    }

    public String getFileMaskDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(YY_M_MDD_H_HMM);
        try {
            sdf = new SimpleDateFormat(this.m_fileMaskDateFormat);
        }
        catch (Exception e) {
            this.m_logger.print(1, ERROR + "date format is wrong: " + this.m_fileMaskDateFormat, e);
        }
        return sdf.format(date);
    }

    public String getFilename(String className, Date time) {
        String res = this.m_fileMask.replace($DATE, this.getFileMaskDate(time));
        res = res.replace("<$BOOM_SERVER>", ServerEngine.getInstance().getServerProps().getHostname());
        res = res.replace($EXTCLASS, className);
        return res;
    }

    public File getFile(String className, Date time) {
        String filename = this.getFilename(className, time);
        return new File(this.m_dir, filename);
    }

    @Override
    public JobConfig getJobConfig() {
        TextAttribute ta;
        JobConfig jobConfig = super.getJobConfig();
        Group specificJobConfig = jobConfig.getConfig().getGroup(GROUP_PMSEXPORT);
        AbstractAttribute aa = specificJobConfig.getAttribute(ATTR_SFTP_PRIV_KEY);
        if (aa == null) {
            ta = new TextAttribute(ATTR_SFTP_PRIV_KEY, "", "Private key file");
            specificJobConfig.addAttribute(ta);
        }
        if ((aa = specificJobConfig.getAttribute(ATTR_SFTP_PUB_KEY)) == null) {
            ta = new TextAttribute(ATTR_SFTP_PUB_KEY, "", "Public key file");
            specificJobConfig.addAttribute(ta);
        }
        if ((aa = specificJobConfig.getAttribute(ATTR_SFTP_PRIV_KEY_PASS)) == null) {
            PasswordAttribute pa = new PasswordAttribute(ATTR_SFTP_PRIV_KEY_PASS, "", "Private key passphrase");
            specificJobConfig.addAttribute(pa);
        }
        Group mapping = this.m_config.getConfig().getGroup(MAPPING_GROUP);
        return jobConfig;
    }

    public void refreshPerfDBMapping() {
        boolean storeConfig = false;
        Group mapping = this.m_config.getConfig().getGroup(MAPPING_GROUP);
        if (mapping == null) {
            mapping = new Group(MAPPING_GROUP);
            this.m_config.getConfig().addGroup(mapping);
        }
        for (Map.Entry<String, Group> entry : mapping.getGroups().entrySet()) {
            Group table = entry.getValue();
            this.checkAndGetPPSQL(table);
        }
        HashMapArray<String, DDFField> hma = ServerEngine.getInstance().getDB().getPerfTables();
        this.m_dbTables.clear();
        this.m_export.clear();
        this.m_dbTables.addAll(hma.keySet());
        if (hma.size() == 0) {
            TextAttribute warning = new TextAttribute(WARNING, "NO Performance Classes found in the DB!", WARNING);
            this.m_config.getConfig().addAttribute(warning);
        } else {
            this.m_config.getConfig().removeAttribute(WARNING);
        }
        for (String tableName : hma.keySet()) {
            tableName = tableName.toUpperCase();
            Group table = mapping.getGroup(tableName);
            String preProcessingSQL = "";
            if (table == null) {
                table = new Group(tableName);
                mapping.addGroup(table);
                TextAttribute tbl = new TextAttribute(TABLE_NAME_ATTRIBUTE, tableName, "Performance class");
                table.addAttribute(tbl);
            }
            preProcessingSQL = this.checkAndGetPPSQL(table);
            MapAttribute tableMapping = (MapAttribute)table.getAttribute(MAP_ATTRIBUTE);
            if (tableMapping == null) {
                tableMapping = new MapAttribute(MAP_ATTRIBUTE, new TreeMap<String, String>(), "Map of metrics for export");
                table.addAttribute(tableMapping);
            }
            tableMapping.setKeyEditable(false);
            tableMapping.setEditable(false);
            Iterator<DDFField> it2 = hma.iterator(tableName);
            while (it2.hasNext()) {
                String[] ar;
                DDFField field = it2.next();
                Object mapObj = tableMapping.getValue();
                String fname = field.getName();
                String extClassField = (String)mapObj.get(fname);
                if (!(mapObj.containsKey(fname) || mapObj.containsKey(fname.toUpperCase()) || mapObj.containsKey(fname.toLowerCase()))) {
                    mapObj.put(fname, null);
                    storeConfig = true;
                    continue;
                }
                if (extClassField == null || extClassField.length() <= 3 || (ar = extClassField.split("\\.")).length != 2) continue;
                Mapping m = this.m_export.get(ar[0]);
                if (m == null) {
                    m = new Mapping(this, ar[0]);
                    this.m_export.put(ar[0], m);
                }
                m.setPreProcessingSQL(preProcessingSQL);
                Map<String, String> map = m.m_dbTables.get(tableName);
                if (map == null) {
                    map = new LinkedHashMap<String, String>();
                    m.m_dbTables.put(tableName, map);
                }
                if (ar[1] == null || ar[1].length() <= 0) continue;
                map.put(fname, ar[1]);
            }
        }
        if (storeConfig) {
            // empty if block
        }
    }

    private String checkAndGetPPSQL(Group table) {
        String preProcessingSQL = "";
        TextAttribute ppsqlATTR = (TextAttribute)table.getAttribute(TABLE_PREPROCESSING_SQL);
        if (ppsqlATTR == null) {
            ppsqlATTR = new TextAttribute(TABLE_PREPROCESSING_SQL, "", "Pre-processing SQL");
            ppsqlATTR.setHeight(100);
            table.addAttribute(ppsqlATTR);
        } else {
            preProcessingSQL = ppsqlATTR.getValue();
            if (ppsqlATTR.getHeight() <= 0) {
                ppsqlATTR.setHeight(100);
            }
        }
        return preProcessingSQL;
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        JobConfig bkp = this.m_config;
        try {
            super.setJobConfig(config);
            this.onInit();
        }
        catch (Exception e) {
            this.m_logger.print(1, ERROR + "processing new configuration. Rollback.");
            try {
                super.setJobConfig(bkp);
                this.onInit();
            }
            catch (Throwable e1) {
                this.m_logger.print(1, ERROR + "Rollback failed");
            }
            throw new InvalidConfig(e);
        }
    }

    public List<String> getPerfTables() {
        return this.m_dbTables;
    }

    public Mapping getMapping(String externalClass) {
        return this.m_export.get(externalClass);
    }

    public List<String> getExternalClasses() {
        return new ArrayList<String>(this.m_export.keySet());
    }

    @Override
    public boolean onStartRun() {
        this.m_logger.print(1, "job started PMSExport");
        try {
            if (!this.m_dir.exists()) {
                if (this.m_dir.mkdirs()) {
                    this.initLogfile();
                    this.printValues();
                    this.m_logger.print(1, "working directory created " + this.m_dir.getPath());
                } else {
                    this.m_lastResult = ERROR + "creating working directory " + this.m_dir.getPath();
                    this.m_logger.print(1, this.m_lastResult);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.onStartRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onGetData() {
        StringBuffer sftpResult = new StringBuffer();
        try {
            Date now = new Date();
            int errors = 0;
            for (String extClass : this.getExternalClasses()) {
                Mapping mapping = this.getMapping(extClass);
                String ppSQL = mapping.getPreProcessingSQL();
                if (ppSQL != null && ppSQL.trim().length() > 1) {
                    Statement sqlStmt = null;
                    ResultSet rs = null;
                    try {
                        Connection con = PMSExport.getConn();
                        this.ensureAllTablesHasPMS_EXPORT(mapping, con);
                        sqlStmt = con.createStatement();
                        if (sqlStmt.execute(ppSQL)) {
                            updatedRecords = 0;
                            rs = sqlStmt.getResultSet();
                            while (rs.next()) {
                                ++updatedRecords;
                            }
                            this.m_logger.print(2, "Records: " + updatedRecords);
                        } else {
                            updatedRecords = sqlStmt.getUpdateCount();
                            this.m_logger.print(2, "Updated records: " + updatedRecords);
                        }
                        this.m_logger.print(2, SUCCESS + " Pre-processing SQL: " + ppSQL);
                    }
                    catch (Throwable e) {
                        this.m_logger.print(1, ERROR + "Failed Pre-processing SQL: " + ppSQL);
                        this.m_logger.print(1, ERROR, e);
                        sftpResult.append(ERROR + "Failed Pre-processing SQL: " + ppSQL + " table: " + extClass);
                        sftpResult.append('\n');
                    }
                    finally {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable con) {}
                        }
                        if (sqlStmt != null) {
                            try {
                                sqlStmt.close();
                            }
                            catch (Throwable con) {}
                        }
                    }
                }
                for (String perfTable : mapping.m_dbTables.keySet()) {
                    LinkedHashMap<String, String> mapCloned = new LinkedHashMap<String, String>(mapping.m_dbTables.get(perfTable));
                    LinkedHashMap<String, String> mapOrdered = new LinkedHashMap<String, String>();
                    this.appendField(mapCloned, mapOrdered, STIME);
                    this.appendField(mapCloned, mapOrdered, NE_ID);
                    this.appendFieldStartedWith(mapCloned, mapOrdered, OBJ_PREFIX);
                    mapOrdered.putAll(mapCloned);
                    this.m_logger.print(2, "start exporting of performance table: " + perfTable + " to scope: " + extClass);
                    try {
                        this.outputPMS(perfTable, this.getFile(extClass, now), mapOrdered, -60000L * (long)this.m_maxHistoryMin, this.m_intervalMin * 60, this.m_ignoreLastMin * 60);
                    }
                    catch (Throwable e) {
                        ++errors;
                        this.m_logger.print(1, ERROR + "Error occurred during export of performance table: " + perfTable + " scope: " + extClass);
                        this.m_logger.print(1, ERROR, e);
                        sftpResult.append(ERROR + "Error occurred during export of performance table: " + perfTable);
                    }
                }
            }
            String res = "";
            if (this.m_sftpHost == null || this.m_sftpUser == null || this.m_sftpDir == null) {
                res = "Missing SFTP Parameters in XML File. PMS Files created, SFTP-Transfer skipped.";
                this.m_logger.print(1, ERROR + res);
                sftpResult.append(res);
                ++errors;
            } else if (this.m_sftpHost.length() == 0 || this.m_sftpUser.length() == 0 || this.m_sftpDir.length() == 0) {
                res = "Incomplete SFTP Parameters. PMS Files created, SFTP-Transfer skipped.";
                this.m_logger.print(1, ERROR + res);
                sftpResult.append(res);
                ++errors;
            } else if (this.m_sftpPrivateKey != null && this.m_sftpPrivateKey.length() > 0) {
                boolean keyAuthSuccess = false;
                boolean pubKeyExist = false;
                boolean keyExist = this.doesFileExist(this.m_sftpPrivateKey);
                if (keyExist) {
                    if (this.m_sftpPublicKey == null || this.m_sftpPublicKey.length() == 0) {
                        this.m_sftpPublicKey = this.m_sftpPrivateKey + ".pub";
                    }
                    if (pubKeyExist = this.doesFileExist(this.m_sftpPublicKey)) {
                        this.m_logger.print(2, "Start SFTP Key Authentication");
                        res = this.sftpAll_PKI();
                        if (res.indexOf(ERROR) != -1) {
                            this.m_logger.print(2, ERROR + "SFTP Key Authentication");
                            sftpResult.append("SFTP Key Authentication failed.");
                            ++errors;
                        } else {
                            this.m_logger.print(2, SUCCESS + "SFTP Key Authentication");
                            sftpResult.append(res).append(" (SFTP privKey)");
                            keyAuthSuccess = true;
                        }
                    } else {
                        sftpResult.append("SFTP Public key file not found.");
                        this.m_logger.print(2, "SFTP Public key " + this.m_sftpPublicKey + " does not exist!");
                    }
                } else {
                    sftpResult.append("SFTP Key file not found.");
                    this.m_logger.print(2, "SFTP key " + this.m_sftpPrivateKey + " does not exist!");
                }
                if (!(keyExist && pubKeyExist && keyAuthSuccess)) {
                    this.m_logger.print(2, "Start SFTP user/password Authentication");
                    res = this.sftpAll();
                    if (res.indexOf(ERROR) != -1) {
                        this.m_logger.print(2, ERROR + "SFTP user/password Authentication");
                        sftpResult.append(" SFTP user/pass Auth failed.").append(" Files created, SFTP-Transfer skipped.");
                        ++errors;
                    } else {
                        this.m_logger.print(2, SUCCESS + "SFTP user/password Authentication");
                        sftpResult.append(res).append(" (SFTP user/pass)");
                    }
                }
            } else {
                if (this.m_sftpPrivateKey == null || this.m_sftpPublicKey == null) {
                    res = "Missing SFTP Private/Public Keys in XML File. ";
                    this.m_logger.print(1, ERROR + "Old XML File! " + res);
                    sftpResult.append(res);
                    ++errors;
                } else {
                    res = "No SFTP Key available.";
                    this.m_logger.print(1, res);
                    sftpResult.append(res);
                }
                this.m_logger.print(2, "Start SFTP user/password Authentication");
                res = this.sftpAll();
                if (res.indexOf(ERROR) != -1) {
                    this.m_logger.print(2, ERROR + "SFTP user/password Authentication");
                    sftpResult.append(" SFTP user/pass auth failed.").append(" Files created, SFTP-Transfer skipped.");
                    ++errors;
                } else {
                    this.m_logger.print(2, SUCCESS + "SFTP user/password Authentication");
                    sftpResult.append(res).append(" (SFTP user/pass)");
                }
            }
            this.m_lastResult = sftpResult.toString();
            this.m_logger.print(1, errors + " errors occured during last run");
            this.m_logger.print(1, SUCCESS + "job finished PMSExport");
        }
        catch (Throwable e) {
            this.m_lastResult = e.getMessage();
            this.m_logger.print(1, ERROR + e.getMessage(), e);
            this.m_logger.print(1, FAILED + "job finished PMSExport");
        }
        return true;
    }

    private void ensureAllTablesHasPMS_EXPORT(Mapping mapping, Connection con) {
        try {
            Iterator<String> it2 = mapping.m_dbTables.keySet().iterator();
            while (it2.hasNext()) {
                try {
                    String perfTable = it2.next();
                    boolean statusColumnExists = this.getKeyAndValues(perfTable, new LinkedList<String>(), new LinkedList<String>());
                    if (statusColumnExists) continue;
                    Statement sqlStmt = con.createStatement();
                    this.alterTable(perfTable, sqlStmt);
                    sqlStmt.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean doesFileExist(String name) {
        boolean exist = false;
        File file = new File(name);
        if (file != null && file.exists()) {
            exist = true;
        }
        return exist;
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    private void appendField(Map<String, String> map, Map<String, String> mapOrdered, String field) {
        Iterator<Map.Entry<String, String>> it3 = map.entrySet().iterator();
        while (it3.hasNext()) {
            Map.Entry<String, String> en = it3.next();
            if (!field.equalsIgnoreCase(en.getValue())) continue;
            mapOrdered.put(en.getKey(), en.getValue());
            it3.remove();
            break;
        }
    }

    private void appendFieldStartedWith(Map<String, String> map, Map<String, String> mapOrdered, String fieldPrefix) {
        Iterator<Map.Entry<String, String>> it3 = map.entrySet().iterator();
        while (it3.hasNext()) {
            Map.Entry<String, String> en = it3.next();
            if (en.getValue() == null || !en.getValue().startsWith(fieldPrefix)) continue;
            mapOrdered.put(en.getKey(), en.getValue());
            it3.remove();
        }
    }

    public Date cleanDate(int backInMinutes) {
        Calendar c = Calendar.getInstance();
        c.set(13, 0);
        c.set(14, 0);
        c.add(12, -backInMinutes);
        return c.getTime();
    }

    public void outputPMS(String table, File outFile, Map<String, String> pmsMap, long beginDateMillis, int intervalSec, int ignoreSec) {
        this.outputPMS(table, outFile, pmsMap, beginDateMillis, intervalSec, ignoreSec, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void outputPMS(String table, File outFile, Map<String, String> pmsMap, long beginDateMillis, int intervalSec, int ignoreSec, ArrayList<Map<String, String>> result) {
        if (!pmsMap.containsValue(NE_ID)) {
            this.m_logger.print(1, ERROR + "NE_ID field not found in the mapping. Stop this run!");
            return;
        }
        Connection con = null;
        Date now = new Date();
        FileOutputStream fos = null;
        PrintWriter pw = null;
        Statement sqlStmt = null;
        ResultSet sqlRslt = null;
        try {
            boolean emptyFile;
            now.setTime(now.getTime() - 1000L * (long)ignoreSec);
            if (beginDateMillis < 0L) {
                beginDateMillis = (now.getTime() + beginDateMillis) / 1000L / (long)intervalSec * 1000L * (long)intervalSec;
            }
            long endDateMillis = now.getTime() / 1000L / (long)intervalSec * 1000L * (long)intervalSec;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.m_logger.print(3, " Begin time: " + sdf.format(new Date(beginDateMillis)));
            this.m_logger.print(3, " End time: " + sdf.format(new Date(endDateMillis)));
            this.m_logger.print(3, " Now time: " + sdf.format(new Date()));
            if (outFile == null) {
                this.m_logger.print(2, ERROR + " unknown output file!");
                return;
            }
            this.m_logger.print(2, "Output file: " + outFile.getName());
            Object header = "\n";
            Iterator<Map.Entry<String, String>> it = pmsMap.entrySet().iterator();
            ArrayList<String> outValues = new ArrayList<String>();
            ArrayList<String> outHeader = new ArrayList<String>();
            while (it.hasNext()) {
                Map.Entry<String, String> en = it.next();
                if (!((String)header).equals("\n")) {
                    header = (String)header + "\t";
                }
                header = (String)header + en.getValue();
                outHeader.add(en.getValue().toUpperCase());
                outValues.add(en.getKey().toUpperCase());
                this.m_logger.print(3, "pmsMap: " + en.getKey() + ", " + en.getValue());
            }
            boolean bl = emptyFile = outFile.length() == 0L;
            if (outFile != null) {
                fos = new FileOutputStream(outFile, true);
                pw = new PrintWriter(fos, true);
            }
            if (emptyFile) {
                pw.println((String)header);
            }
            this.m_logger.print(2, (con = PMSExport.getConn()) == null ? "conn==NULL" : "connection established");
            if (con == null) {
                return;
            }
            sqlStmt = con.createStatement();
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            boolean statusColumnExists = this.getKeyAndValues(table, keys, values);
            if (!statusColumnExists) {
                this.alterTable(table, sqlStmt);
            }
            this.markAsReadyToSend(table, beginDateMillis, endDateMillis, sqlStmt);
            String q = null;
            q = m_isOracle ? this.buildSelectWithGroupingORA(table, beginDateMillis, intervalSec, endDateMillis, keys, values) : this.buildSelectWithGrouping(table, beginDateMillis, intervalSec, endDateMillis, keys, values);
            this.m_logger.print(2, "group statement: " + q);
            sqlRslt = sqlStmt.executeQuery(q);
            int rowCounter = 0;
            while (true) {
                Iterator<Map.Entry<String, String>> it2;
                StringBuffer oneLine;
                String stime;
                LinkedHashMap<String, String> record;
                if (sqlRslt.next()) {
                    record = new LinkedHashMap<String, String>();
                    stime = sqlRslt.getString(STIME_AS_TIME_FORMATTED);
                    record.put(STIME, stime);
                    String summary = sqlRslt.getString(SUMMARY);
                    this.m_logger.print(2, "\n" + STIME + ": " + stime + "   (" + summary + " records in " + intervalSec / 60 + " minutes)");
                    oneLine = new StringBuffer();
                    it2 = pmsMap.entrySet().iterator();
                } else {
                    this.markAsSent(table, beginDateMillis, endDateMillis, sqlStmt);
                    this.m_logger.print(2, "Written lines: " + rowCounter);
                    return;
                }
                while (it2.hasNext()) {
                    Map.Entry<String, String> entry = it2.next();
                    String key = entry.getKey();
                    if (key.equalsIgnoreCase(_TIME)) {
                        oneLine.append(stime);
                        continue;
                    }
                    Object val = sqlRslt.getString(key);
                    if (val == null) {
                        val = keys.contains(key) ? NULL : "";
                    }
                    val = ((String)val).replaceAll("\\s+", "");
                    record.put(entry.getValue(), (String)val);
                    if (!keys.contains(key) && ((String)val).indexOf(46) == -1 && !"".equals(val)) {
                        val = (String)val + ".";
                    }
                    oneLine.append('\t').append((String)val);
                }
                pw.println(oneLine);
                ++rowCounter;
                if (result == null) continue;
                result.add(record);
            }
        }
        catch (Throwable e) {
            this.m_logger.print(1, ERROR + "Exception: " + e.getMessage());
            return;
        }
        finally {
            if (sqlRslt != null) {
                try {
                    sqlRslt.close();
                }
                catch (Throwable throwable) {}
            }
            if (sqlStmt != null) {
                try {
                    sqlStmt.close();
                }
                catch (Throwable throwable) {}
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private void markAsSent(String table, long beginDateMillis, long endDateMillis, Statement sqlStmt) throws SQLException {
        String update = "UPDATE " + table + " SET " + PMS_STATUS + " = 2 WHERE " + PMS_STATUS + " = 1 AND " + COL_TIME + " >= " + beginDateMillis + " AND " + COL_TIME + " < " + endDateMillis;
        this.m_logger.print(2, "Mark as processed");
        this.m_logger.print(2, "UdateStmt: " + update);
        sqlStmt.executeUpdate(update);
    }

    private String buildSelectWithGrouping(String table, long beginDateMillis, int intervalSec, long endDateMillis, ArrayList<String> keys, ArrayList<String> values) {
        StringBuffer _time = new StringBuffer();
        _time.append("FLOOR(").append(COL_TIME).append(" / ").append(intervalSec * 1000).append(") * ").append(intervalSec);
        StringBuffer q = new StringBuffer();
        q.append("select date_format(from_unixtime(").append(_time).append("), \"%y%m%d %H:%i\") as ").append(STIME_AS_TIME_FORMATTED).append(", ").append(_time).append(" as ").append(INTERVL).append(", count(*) as ").append(SUMMARY);
        for (String key : keys) {
            q.append(", ").append(key);
        }
        for (String value : values) {
            q.append(", avg(").append(value).append(") as ").append(value);
        }
        q.append(", max(").append(PMS_STATUS).append(") as ").append(MAX_PMS_STATUS).append(" FROM ").append(table).append(" WHERE ").append(PMS_STATUS).append(" >= 1 AND ").append(COL_TIME).append(" >= ").append(beginDateMillis).append(" AND ").append(COL_TIME).append(" < ").append(endDateMillis).append(" group by ").append(INTERVL);
        for (String key : keys) {
            q.append(", ").append(key);
        }
        q.append("  HAVING ").append(MAX_PMS_STATUS).append(" = 1  ORDER BY ").append(INTERVL).append(' ');
        return q.toString();
    }

    private String buildSelectWithGroupingORA(String table, long beginDateMillis, int intervalSec, long endDateMillis, ArrayList<String> keys, ArrayList<String> values) {
        StringBuffer _time = new StringBuffer();
        _time.append("FLOOR(").append(COL_TIME).append(" / ").append(intervalSec * 1000).append(") * ").append(intervalSec);
        StringBuffer q = new StringBuffer();
        q.append("SELECT to_char( from_tz ( CAST ( 1/24/60/60 * (FLOOR(min(").append(COL_TIME).append(") / 300 / 1000) * 300) + to_timestamp('01011970','ddmmyyyy')  as TIMESTAMP), 'UTC') at time zone (select sessiontimezone from dual) ,'yymmdd hh24:mi') as ").append(STIME_AS_TIME_FORMATTED).append(", ").append(" count(*) as ").append(SUMMARY);
        for (String key : keys) {
            q.append(", \"").append(key).append('\"');
        }
        for (String value : values) {
            q.append(", avg(\"").append(value).append("\") as \"").append(value).append('\"');
        }
        q.append(" FROM ").append(table).append(" WHERE ").append(PMS_STATUS).append(" >= 1 AND ").append(COL_TIME).append(" >= ").append(beginDateMillis).append(" AND ").append(COL_TIME).append(" < ").append(endDateMillis).append(" group by ").append(_time);
        for (String key : keys) {
            q.append(", \"").append(key).append('\"');
        }
        q.append("  HAVING max(").append(PMS_STATUS).append(") = 1  ORDER BY ").append(_time);
        return q.toString();
    }

    private void markAsReadyToSend(String table, long beginDateMillis, long endDateMillis, Statement sqlStmt) throws SQLException {
        int limit = 5000;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(table).append(" SET ").append(PMS_STATUS).append(" = 1 WHERE ").append(PMS_STATUS).append(" IS NULL AND ").append(COL_TIME).append(" >= ").append(beginDateMillis).append(" AND ").append(COL_TIME).append(" < ").append(endDateMillis);
        if (m_isOracle) {
            sql.append(" AND rownum<=").append(limit);
        } else {
            sql.append(" LIMIT ").append(limit);
        }
        while (limit == sqlStmt.executeUpdate(sql.toString())) {
        }
    }

    private void alterTable(String table, Statement sqlStmt) throws SQLException {
        StringBuffer sql = new StringBuffer();
        if (m_isOracle) {
            sql.append("ALTER TABLE ").append(table).append(" ADD ( ").append(PMS_STATUS).append(" NUMBER(1) NULL )");
        } else {
            sql.append("ALTER TABLE ").append(table).append(" ADD COLUMN ").append(PMS_STATUS).append(" TINYINT NULL");
        }
        int sqlRet = sqlStmt.executeUpdate(sql.toString());
        this.m_logger.print(1, "ALTER TABLE " + table + " returns: " + sqlRet);
    }

    public boolean getKeyAndValues(String tableName, List<String> keys, List<String> values) {
        Statement stMain = null;
        ResultSet rs = null;
        boolean isPMSColumnFound = false;
        try {
            stMain = PMSExport.getConn().createStatement(1003, 1007);
            stMain.setQueryTimeout(300);
            StringBuffer sql = new StringBuffer();
            if (m_isOracle) {
                sql.append("SELECT * from ").append(tableName).append(" where rownum<=1");
            } else {
                sql.append("SELECT * from ").append(tableName).append(" limit 1");
            }
            rs = stMain.executeQuery(sql.toString());
            ResultSetMetaData rsMD = rs.getMetaData();
            int size = rsMD.getColumnCount();
            for (int i = 1; i <= size; ++i) {
                if (rsMD.getColumnName(i).equalsIgnoreCase(PMS_STATUS)) {
                    isPMSColumnFound = true;
                    continue;
                }
                if (rsMD.getColumnName(i).equalsIgnoreCase(_TIME)) continue;
                if (rsMD.getColumnTypeName(i).toLowerCase().startsWith("varchar")) {
                    keys.add(rsMD.getColumnName(i));
                    continue;
                }
                values.add(rsMD.getColumnName(i));
            }
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
            if (stMain != null) {
                try {
                    stMain.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return isPMSColumnFound;
    }

    public static synchronized Connection getConn() {
        DB db = ServerEngine.getInstance().getDB();
        if (m_connection == null) {
            if (db.m_isOraclePERF) {
                m_isOracle = true;
                m_connection = new OraConnector(ServerEngine.getInstance().getServerProps().getDB_PERF_Properties());
                if (COL_TIME.length() == 0 || COL_TIME.charAt(0) != '\"') {
                    COL_TIME = "\"" + COL_TIME + "\"";
                }
            } else {
                m_isOracle = false;
                m_connection = new Connector(ServerEngine.getInstance().getServerProps().getDB_PERF_Properties());
            }
        }
        if (!m_connection.isReady()) {
            m_connection.onOpen();
        }
        return m_connection.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sftpAll() {
        int i;
        File[] list;
        int total;
        int count;
        ChannelSftp sftp;
        if (this.m_sftpHost == null || this.m_sftpUser == null || this.m_sftpPass == null || this.m_sftpDir == null) {
            String err = "SFTP login parameters or SFTP-Directory are not complete in XML File. SFTP-Transfer will be skipped!";
            this.m_logger.print(1, ERROR + err);
            return ERROR + err;
        }
        Session session = null;
        Channel channel = null;
        JSch jsch = new JSch();
        try {
            session = jsch.getSession(this.m_sftpUser, this.m_sftpHost, this.m_sftpPort);
            session.setUserInfo(new UserInfo(){

                @Override
                public void showMessage(String message) {
                }

                @Override
                public boolean promptYesNo(String message) {
                    return true;
                }

                @Override
                public boolean promptPassword(String message) {
                    return true;
                }

                @Override
                public boolean promptPassphrase(String message) {
                    return false;
                }

                @Override
                public String getPassword() {
                    return PMSExport.this.m_sftpPass;
                }

                @Override
                public String getPassphrase() {
                    return null;
                }
            });
            session.connect();
            channel = session.openChannel("sftp");
            channel.connect();
            sftp = (ChannelSftp)channel;
            try {
                sftp.cd(this.m_sftpDir);
            }
            catch (Throwable e) {
                String err = "SFTP: can't change remote directory: " + this.m_sftpDir;
                this.m_logger.print(1, ERROR + err);
                String string2 = ERROR + err;
                if (channel != null) {
                    try {
                        channel.disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (session == null) return string2;
                try {
                    session.disconnect();
                    return string2;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return string2;
            }
            count = 0;
            total = 0;
            try {
                String mask = this.m_fileMask.replace($DATE, ".*");
                mask = mask.replace("<$BOOM_SERVER>", ServerEngine.getInstance().getServerProps().getHostname());
                mask = mask.replace($EXTCLASS, ".*");
                FileNameFilter ff = new FileNameFilter(mask);
                list = this.m_dir.listFiles(ff);
                total = list.length;
                if (total == 0) {
                    String string3 = "Nothing to transfer";
                    return string3;
                }
                i = 0;
            }
            catch (Throwable e) {
                String err = "SFTP Error - " + e.getMessage() + ". Transferred " + count + " of " + total + " files to " + this.m_sftpHost;
                this.m_logger.print(1, ERROR + err);
                String string5 = ERROR + err;
                return string5;
            }
        }
        catch (JSchException e) {
            String err = "SFTP: connection failed: " + e.getMessage();
            this.m_logger.print(1, ERROR + err);
            String string4 = ERROR + err;
            return string4;
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Throwable throwable) {}
            }
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
        while (true) {
            if (i >= total) {
                String msg = "Transferred " + count + " of " + total + " files to " + this.m_sftpHost;
                this.m_logger.print(1, msg);
                return msg;
            }
            File f = list[i];
            String relative = this.m_workingdir + "/" + f.getName();
            String tmpName = f.getName() + ".tmp";
            try {
                sftp.put(relative, tmpName);
                ++count;
                try {
                    sftp.rename(tmpName, f.getName());
                    this.m_logger.print(2, "File: " + f.getName() + " transferred. Bytes: " + f.length());
                }
                catch (SftpException e) {
                    this.m_logger.print(1, ERROR + e.getMessage() + " rename file: " + tmpName);
                }
                if (!f.delete()) {
                    this.m_logger.print(1, ERROR + "deleting file " + f.getName());
                }
            }
            catch (SftpException e) {
                this.m_logger.print(1, ERROR + e.getMessage() + " put file: " + tmpName);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sftpAll_PKI() {
        int i;
        File[] list;
        int total;
        int count;
        ChannelSftp sftp;
        if (this.m_sftpHost == null || this.m_sftpUser == null || this.m_sftpPrivateKey == null || this.m_sftpPrivateKeyPass == null || this.m_sftpDir == null) {
            String err = "SFTP Key-Authorization-Parameters or SFTP-Directory are not complete in XML File. SFTP-Transfer will be skipped!";
            this.m_logger.print(1, ERROR + err);
            return ERROR + err;
        }
        if (!this.m_dir.exists()) {
            String err = ERROR + "creating working directory " + this.m_dir.getPath();
            this.m_logger.print(1, err);
            return err;
        }
        Session session = null;
        Channel channel = null;
        JSch jsch = new JSch();
        try {
            byte[] bytes = null;
            try {
                bytes = this.m_sftpPrivateKeyPass.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                bytes = this.m_sftpPrivateKeyPass.getBytes();
            }
            jsch.addIdentity(this.m_sftpPrivateKey, this.m_sftpPublicKey, bytes);
            session = jsch.getSession(this.m_sftpUser, this.m_sftpHost, this.m_sftpPort);
            session.setUserInfo(new UserInfo(){

                @Override
                public void showMessage(String message) {
                }

                @Override
                public boolean promptYesNo(String message) {
                    return true;
                }

                @Override
                public boolean promptPassword(String message) {
                    return false;
                }

                @Override
                public boolean promptPassphrase(String message) {
                    return true;
                }

                @Override
                public String getPassword() {
                    return null;
                }

                @Override
                public String getPassphrase() {
                    return PMSExport.this.m_sftpPrivateKeyPass;
                }
            });
            session.connect();
            channel = session.openChannel("sftp");
            channel.connect();
            sftp = (ChannelSftp)channel;
            try {
                sftp.cd(this.m_sftpDir);
            }
            catch (Throwable e) {
                String err = "SFTP: can't change remote directory: " + this.m_sftpDir;
                this.m_logger.print(1, ERROR + err);
                String string2 = ERROR + err;
                if (channel != null) {
                    try {
                        channel.disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (session == null) return string2;
                try {
                    session.disconnect();
                    return string2;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return string2;
            }
            count = 0;
            total = 0;
            try {
                String mask = this.m_fileMask.replace($DATE, ".*");
                mask = mask.replace("<$BOOM_SERVER>", ServerEngine.getInstance().getServerProps().getHostname());
                mask = mask.replace($EXTCLASS, ".*");
                FileNameFilter ff = new FileNameFilter(mask);
                list = this.m_dir.listFiles(ff);
                total = list.length;
                if (total == 0) {
                    String string3 = "Nothing to transfer";
                    return string3;
                }
                i = 0;
            }
            catch (Throwable e) {
                String err = "SFTP Error - " + e.getMessage() + ". Transferred " + count + " of " + total + " files to " + this.m_sftpHost;
                this.m_logger.print(1, ERROR + err);
                String string5 = ERROR + err;
                return string5;
            }
        }
        catch (JSchException e) {
            String err = "SFTP: connection failed: " + e.getMessage();
            this.m_logger.print(1, ERROR + err);
            String string4 = ERROR + err;
            return string4;
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Throwable throwable) {}
            }
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
        while (true) {
            if (i >= total) {
                String msg = "Transferred " + count + " of " + total + " files to " + this.m_sftpHost;
                this.m_logger.print(1, msg);
                return msg;
            }
            File f = list[i];
            String relative = this.m_workingdir + "/" + f.getName();
            String tmpName = f.getName() + ".tmp";
            try {
                sftp.put(relative, tmpName);
                ++count;
                try {
                    sftp.rename(tmpName, f.getName());
                    this.m_logger.print(2, "File: " + f.getName() + " transferred. Bytes: " + f.length());
                }
                catch (SftpException e) {
                    this.m_logger.print(1, ERROR + e.getMessage() + " rename file: " + tmpName);
                }
                if (!f.delete()) {
                    this.m_logger.print(1, ERROR + "deleting file " + f.getName());
                }
            }
            catch (SftpException e) {
                this.m_logger.print(1, ERROR + e.getMessage() + " put file: " + tmpName);
            }
            ++i;
        }
    }

    static {
        m_isOracle = false;
    }

    public class Mapping {
        private String m_externalName = null;
        private Map<String, Map<String, String>> m_dbTables = new HashMap<String, Map<String, String>>();
        private String m_preProcessingSQL = null;

        public String getPreProcessingSQL() {
            return this.m_preProcessingSQL;
        }

        public void setPreProcessingSQL(String preProcessingSQL) {
            this.m_preProcessingSQL = preProcessingSQL;
        }

        public Mapping(PMSExport this$0, String extScope) {
            this.m_externalName = extScope;
        }

        public String getExternalScope() {
            return this.m_externalName;
        }
    }
}

