/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.ctrl.sc.in.ScActionCfgUpdate;
import com.blixx.ctrl.sc.in.ScUpdateActionTree_AddGrp;
import com.blixx.ctrl.sc.in.ScUpdateActionTree_DelGrp;
import com.blixx.log.RTLogger;
import com.blixx.server.ServerClient;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.jobs.ServerJob;
import com.blixx.server.jobs.SyncSlaveAssignmentsJob;
import com.blixx.shared.Action;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.utils.FileSyncUtils;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SyncSlaveActionsJob
extends ServerJob {
    public static final String JOB_NAME = "Synchronize Actions on PROXY Slaves";
    private static ServerJob m_this = null;
    protected String m_lastResult = "-";

    public static synchronized ServerJob getServerJob() {
        if (m_this == null) {
            JobConfig jc = new JobConfig();
            jc.setJobName(JOB_NAME);
            jc.setJobDescription("Automatically Synchronize Actions on PROXY servers");
            jc.setSchedulingInterval("10m");
            jc.getJobGroup().getAttribute("scheduling").setEditable(true);
            jc.setClassName(SyncSlaveAssignmentsJob.class.getCanonicalName());
            jc.setActive(true);
            jc.getJobGroup().getAttribute("jobname").setEditable(false);
            jc.getJobGroup().getAttribute("jobDescription").setEditable(false);
            jc.getJobGroup().getAttribute("class").setEditable(false);
            jc.getJobGroup().getAttribute("active").setEditable(true);
            CheckAttribute ac = new CheckAttribute("STOREXML", true, "Store XML file");
            ac.setEditable(false);
            ac.setEnabled(false);
            jc.getJobGroup().addAttribute(ac);
            try {
                m_this = new SyncSlaveActionsJob(jc);
            }
            catch (Throwable e) {
                RTLogger.print(2, "SyncSlaveActionsJob initialization failed", e);
            }
        }
        return m_this;
    }

    public SyncSlaveActionsJob(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    @Override
    public boolean onGetData() {
        StringBuffer res = new StringBuffer();
        for (SlaveServerCard ssc : ServerEngine.getInstance().getSlaves()) {
            this.syncActions(res, ssc);
        }
        this.m_lastResult = res.toString();
        if (this.m_lastResult.length() == 0) {
            this.m_lastResult = "No PROXY servers configured.";
        }
        RTLogger.print(3, this.m_lastResult);
        return true;
    }

    public synchronized void syncActions(StringBuffer res, SlaveServerCard ssc) {
        Pattern p = Pattern.compile("\\[(\\S+)\\](.+)(/?)");
        String actionsDir = "srv/actions/";
        if (ssc.getScenario() <= 1 || ssc.getScenario() == 8) {
            res.append(ssc.getHostName());
            if (!ssc.m_bc.isOnline()) {
                res.append(" FAILED\n");
                res.append(" server is offline\n");
            } else {
                int deleted = 0;
                int updated = 0;
                int error = 0;
                ServerClient sc = ssc.getServerClientStandAlone();
                sc.run("GET_DIR_HASH", actionsDir, new String[0]);
                if (sc.isSuccess()) {
                    res.append(" OK\n");
                    String all = (String)sc.getResultObject();
                    try {
                        String report = FileSyncUtils.verifyDigest(new File(actionsDir), all, false);
                        String[] lines = report.split("\n");
                        for (int i = 0; i < lines.length; ++i) {
                            try {
                                ScUpdateActionTree_DelGrp scdg;
                                Matcher m = p.matcher(lines[i]);
                                if (!m.matches() || m.group(1).equals("OK")) continue;
                                String flag = m.group(1);
                                String filename = m.group(2);
                                String actionGroupName = filename.replace(".act.xml", "");
                                if (flag.equals("D")) {
                                    scdg = new ScUpdateActionTree_DelGrp(ssc, actionGroupName);
                                    scdg.run();
                                    if (scdg.isSuccess()) {
                                        String resdg = "Deleted Action group: " + actionGroupName;
                                        RTLogger.print(2, resdg);
                                        ++deleted;
                                        continue;
                                    }
                                    throw new Exception("Delete failed. Action group=" + actionGroupName);
                                }
                                if (flag.equals("M")) {
                                    scdg = new ScUpdateActionTree_DelGrp(ssc, actionGroupName);
                                    scdg.run();
                                    if (!scdg.isSuccess()) {
                                        throw new Exception("Delete failed. Action group=" + actionGroupName);
                                    }
                                }
                                ScUpdateActionTree_AddGrp scAddGrp = new ScUpdateActionTree_AddGrp(ssc, actionGroupName);
                                scAddGrp.run();
                                if (!scAddGrp.isSuccess()) {
                                    throw new Exception("Create failed. Action group=" + actionGroupName);
                                }
                                GroupTreeObject actions = ServerEngine.getInstance().getActionRepository().getTree();
                                GroupTreeObject ag = actions.getChild(actionGroupName, "");
                                if (ag == null) continue;
                                List<GroupTreeObjectLast> actionGTOLs = ag.getAllGTOLs();
                                for (GroupTreeObjectLast agtol : actionGTOLs) {
                                    Action actionObject = (Action)agtol.getTreeObject().getObject();
                                    ScActionCfgUpdate upd = new ScActionCfgUpdate(ssc, actionGroupName, actionObject);
                                    upd.run();
                                    if (upd.isSuccess()) continue;
                                    throw new Exception("Update action failed. Action group=" + actionGroupName + " Action: " + actionObject.m_label);
                                }
                                ++updated;
                                res.append(" ").append(actionGroupName).append('\n');
                                continue;
                            }
                            catch (Exception e) {
                                ++error;
                                res.append(e.getMessage()).append("\n");
                                RTLogger.print(2, "SyncSlaveActions: Error processing Action Group. ", e);
                            }
                        }
                    }
                    catch (Throwable e) {
                        RTLogger.print(2, "SyncSlaveActions: Error: ", e);
                        res.append("SyncSlaveActions Error: " + e.getMessage() + "\n");
                    }
                    res.append("Synchronized " + updated + " action groups\n");
                } else {
                    res.append(" FAILED\n");
                    res.append(sc.getResultObject());
                }
            }
        }
    }
}

