/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.server.ServerClient;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.utils.FileSyncUtils;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SyncSlaveAssignmentsJob
extends ServerJob {
    public static final String JOB_NAME = "Synchronize Assignments on PROXY Slaves";
    private static ServerJob m_this = null;
    protected String m_lastResult = "-";

    public static synchronized ServerJob getServerJob() {
        if (m_this == null) {
            JobConfig jc = new JobConfig();
            jc.setJobName(JOB_NAME);
            jc.setJobDescription("Automatically Synchronize Assignments on PROXY servers");
            jc.setSchedulingInterval("10m");
            jc.getJobGroup().getAttribute("scheduling").setEditable(true);
            jc.setClassName(SyncSlaveAssignmentsJob.class.getCanonicalName());
            jc.setActive(true);
            jc.getJobGroup().getAttribute("jobname").setEditable(false);
            jc.getJobGroup().getAttribute("jobDescription").setEditable(false);
            jc.getJobGroup().getAttribute("class").setEditable(false);
            jc.getJobGroup().getAttribute("active").setEditable(true);
            CheckAttribute ac = new CheckAttribute("STOREXML", true, "Store XML file");
            ac.setEditable(false);
            ac.setEnabled(false);
            jc.getJobGroup().addAttribute(ac);
            try {
                m_this = new SyncSlaveAssignmentsJob(jc);
            }
            catch (Throwable e) {
                RTLogger.print(2, "SyncSlaveAssignmentsJob initialization failed", e);
            }
        }
        return m_this;
    }

    public SyncSlaveAssignmentsJob(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    @Override
    public JobConfig getJobConfig() {
        return super.getJobConfig();
    }

    @Override
    public boolean onGetData() {
        StringBuffer res = new StringBuffer();
        for (SlaveServerCard ssc : ServerEngine.getInstance().getSlaves()) {
            this.syncAssignments(res, ssc);
        }
        this.m_lastResult = res.toString();
        if (this.m_lastResult.length() == 0) {
            this.m_lastResult = "No PROXY servers configured.";
        }
        RTLogger.print(3, this.m_lastResult);
        return true;
    }

    public synchronized void syncAssignments(StringBuffer res, SlaveServerCard ssc) {
        Pattern p = Pattern.compile("\\[(\\S+)\\](.+)(/?)");
        String asnFilePath = "srv/policies/assignmentGroups.xml";
        if (ssc.getScenario() <= 1 || ssc.getScenario() == 8) {
            res.append(ssc.getHostName());
            if (!ssc.m_bc.isOnline()) {
                res.append(" FAILED\n");
                res.append(" server is offline\n");
            } else {
                ServerClient sc = ssc.getServerClientStandAlone();
                sc.run("GET_DIR_HASH", asnFilePath, new String[0]);
                if (sc.isSuccess()) {
                    res.append(" OK\n");
                    String all = (String)sc.getResultObject();
                    try {
                        int resultFlag = 0;
                        String report = FileSyncUtils.verifyDigest(new File(asnFilePath), all, false);
                        String[] lines = report.split("\n");
                        for (int i = 0; i < lines.length; ++i) {
                            Matcher m = p.matcher(lines[i]);
                            if (!m.matches() || m.group(1).equals("OK")) continue;
                            resultFlag = sc.run("MASTER_UPDATE", "ASSIGNMENTS", new String[]{asnFilePath}) ? 1 : 2;
                        }
                        switch (resultFlag) {
                            case 0: {
                                res.append("Assignment groups in sync\n");
                                ssc.pushCachedDeployments();
                                break;
                            }
                            case 1: {
                                res.append("Assignment groups synchronized\n");
                                ssc.pushCachedDeployments();
                                break;
                            }
                            case 2: {
                                res.append("Assignment groups synchronization failed\n");
                                break;
                            }
                        }
                    }
                    catch (Throwable e) {
                        RTLogger.print(2, "SyncSlaveAssignments: Error", e);
                        res.append("SyncSlaveAssignments Error" + e.getMessage() + "\n");
                    }
                } else {
                    res.append(" FAILED\n");
                    res.append(sc.getResultObject());
                }
            }
        }
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        super.setJobConfig(config);
    }
}

