/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.server.BinariesRepository;
import com.blixx.server.ServerClient;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.utils.FileSyncUtils;
import com.blixx.shared.utils.ZIP;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SyncSlaveBinariesJob
extends ServerJob {
    public static final String JOB_NAME = "Synchronize Binaries on PROXY Slaves";
    private static ServerJob m_this = null;
    protected String m_lastResult = "-";

    public static synchronized ServerJob getServerJob() {
        if (m_this == null) {
            JobConfig jc = new JobConfig();
            jc.setJobName(JOB_NAME);
            jc.setJobDescription("Automatically Synchronize binary packages on PROXY servers");
            jc.setSchedulingInterval("10m");
            jc.getJobGroup().getAttribute("scheduling").setEditable(true);
            jc.setClassName(SyncSlaveBinariesJob.class.getCanonicalName());
            jc.setActive(true);
            jc.getJobGroup().getAttribute("jobname").setEditable(false);
            jc.getJobGroup().getAttribute("jobDescription").setEditable(false);
            jc.getJobGroup().getAttribute("class").setEditable(false);
            jc.getJobGroup().getAttribute("active").setEditable(true);
            CheckAttribute ac = new CheckAttribute("STOREXML", true, "Store XML file");
            ac.setEditable(false);
            ac.setEnabled(false);
            jc.getJobGroup().addAttribute(ac);
            try {
                m_this = new SyncSlaveBinariesJob(jc);
            }
            catch (Throwable e) {
                RTLogger.print(2, "SyncSlaveBinariesJob initialization failed", e);
            }
        }
        return m_this;
    }

    public SyncSlaveBinariesJob(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    @Override
    public JobConfig getJobConfig() {
        return super.getJobConfig();
    }

    @Override
    public boolean onGetData() {
        StringBuffer res = new StringBuffer();
        for (SlaveServerCard ssc : ServerEngine.getInstance().getSlaves()) {
            this.syncBinaries(res, ssc);
        }
        this.m_lastResult = res.toString();
        if (this.m_lastResult.length() == 0) {
            this.m_lastResult = "No PROXY servers configured.";
        }
        RTLogger.print(3, this.m_lastResult);
        return true;
    }

    public synchronized void syncBinaries(StringBuffer res, SlaveServerCard ssc) {
        int synced = 0;
        BinariesRepository prep = ServerEngine.getInstance().getBinariesRepository();
        Pattern p = Pattern.compile("\\[(\\S+)\\](.+)");
        if (ssc.getScenario() <= 1 || ssc.getScenario() == 8) {
            res.append(ssc.getHostName());
            if (!ssc.m_bc.isOnline()) {
                res.append(" FAILED\n");
                res.append(" server is offline\n");
            } else {
                ServerClient sc = ssc.getServerClientStandAlone();
                sc.run("GET_DIR_HASH_SHORT", "./srv/packages", new String[0]);
                if (sc.isSuccess()) {
                    res.append(" OK\n");
                    String all = (String)sc.getResultObject();
                    LinkedList<String> toUpload = new LinkedList<String>();
                    LinkedList<String> toDeleteFiles = new LinkedList<String>();
                    LinkedList<String> toDeleteDirectories = new LinkedList<String>();
                    try {
                        RTLogger.print(5, all);
                        String report = FileSyncUtils.verifyDigestPackages(new File("./srv/packages"), all, false);
                        RTLogger.print(3, report);
                        String[] lines = report.split("\n");
                        for (int i = 0; i < lines.length; ++i) {
                            Matcher m;
                            if (lines[i].length() <= 3 || !(m = p.matcher(lines[i])).matches()) continue;
                            if (m.group(2).endsWith("/") && (m.group(1).equals("M") || m.group(1).equals("A"))) {
                                if (toUpload.contains(m.group(2))) continue;
                                toUpload.add(m.group(2));
                                continue;
                            }
                            if (m.group(2).endsWith("/") && m.group(1).equals("D")) {
                                if (toDeleteDirectories.contains(m.group(2))) continue;
                                toDeleteDirectories.add(m.group(2));
                                continue;
                            }
                            if (!m.group(1).equals("!")) continue;
                            if (m.group(2).endsWith("/")) {
                                toDeleteFiles.add(m.group(2));
                                toUpload.add(m.group(2));
                                continue;
                            }
                            toDeleteDirectories.add(m.group(2));
                            toUpload.add(m.group(2));
                        }
                    }
                    catch (Throwable e) {
                        RTLogger.print(2, "SyncSlaveBinary: Error", e);
                    }
                    if (toDeleteFiles.size() > 0) {
                        for (String filename : toDeleteFiles) {
                            String path = "./srv/packages" + File.separator + filename;
                            if (sc.run("DELETE_FILE", path, new String[0])) continue;
                            RTLogger.print(2, "SyncSlaveBinary: Error deleting file " + path);
                        }
                    }
                    if (toDeleteDirectories.size() > 0) {
                        for (String filename : toDeleteDirectories) {
                            String path = "./srv/packages" + File.separator + filename;
                            if (!sc.run("DELETE_FOLDER", path, new String[0])) {
                                RTLogger.print(2, "SyncSlaveBinary: Error deleting directory " + path);
                                continue;
                            }
                            if (toUpload.contains(filename)) continue;
                            ++synced;
                        }
                    }
                    if (toUpload.size() > 0) {
                        synced += this.upload(sc, toUpload);
                    }
                } else {
                    res.append(" FAILED\n");
                    res.append(sc.getResultObject());
                }
            }
        }
        res.append("Synchronized ").append(synced).append(" binary packages\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int upload(ServerClient sc, List<String> toUpload) {
        int synced = 0;
        File tmp = new File("ssbtmp" + System.currentTimeMillis() + ".zip");
        try {
            tmp.createNewFile();
            String zipFile = tmp.getCanonicalPath();
            ZIP zip = new ZIP();
            zip.zipDir("./srv/packages", toUpload, zipFile);
            StringBuffer action = new StringBuffer();
            action.append("UPD_BINARIES");
            for (int i = 0; i < toUpload.size(); ++i) {
                action.append(" \"").append(toUpload.get(i)).append('\"');
            }
            sc.run("MASTER_UPDATE", action.toString(), new String[]{zipFile});
            synced = toUpload.size();
        }
        catch (Throwable e) {
            RTLogger.print(2, "SyncSlaveBinary: Uploading Error", e);
        }
        finally {
            tmp.delete();
        }
        return synced;
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        super.setJobConfig(config);
    }
}

