/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.migrate;

import com.blixx.server.AgentCard;
import com.blixx.server.EventOperations;
import com.blixx.server.EventOperationsOutage;
import com.blixx.server.ServerEngine;
import com.blixx.server.UserManager;
import com.blixx.server.db.DB;
import com.blixx.server.db.DBOutage;
import com.blixx.server.db.DBProperties;
import com.blixx.server.ext.ForwardManager;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.Annotation;
import com.blixx.shared.Assignment;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.UItem;
import com.blixx.shared.User;
import com.blixx.shared.UserRole;
import com.blixx.shared.pg.PowerGroup;
import com.blixx.shared.utils.HashMapMap;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DBMigrate {
    public static void main(String[] args) {
        ServerEngine se = ServerEngine.getMockInstance();
        try {
            Object anno;
            List<String> annotations;
            se.setForwardManager(new FakeForwardManager());
            DB target = new DB();
            target.init(new DBProperties(new File("target_db.props")), new DBProperties(new File("target_db_perf.props")));
            DBOutage targetOutage = new DBOutage();
            targetOutage.init(new DBProperties(new File("target_db.props")), new DBProperties(new File("target_db_perf.props")));
            System.out.println("Moving AgentCards");
            AgentCard[] cards = se.getDB().readAgentCards();
            if (cards != null) {
                for (AgentCard agentCard : cards) {
                    target.saveAgentCard(agentCard);
                    System.out.println("moved: " + String.valueOf(agentCard));
                }
            } else {
                System.err.println("Agents not found!");
            }
            System.out.println("Moving Agent Attributes");
            Map<String, AgentCardCM> agentAttributes = se.getDB().readAgentCM();
            if (agentAttributes != null) {
                System.out.println("Agent Attributes will be stored");
                target.saveAgentCMs(agentAttributes.values());
                System.out.println("Agent Attributes stored OK");
            } else {
                System.err.println("Agent Attributes not found!");
            }
            System.out.println("AGENTS_EXT_LABELS will be not moved");
            List<Assignment> assignments = se.getDB().loadAssignments();
            if (assignments != null) {
                System.out.println("Assignments will be stored");
                int i = 0;
                for (Assignment assignment : assignments) {
                    System.out.println("Assignments " + i++ + " of " + assignments.size());
                    target.saveAssignment(assignment.getID(), assignment.getAgentID(), assignment.getName(), assignment.getUser(), assignment.getType(), assignment.getLock());
                }
                System.out.println("Assignments stored OK");
            }
            EventsMigrate eo = new EventsMigrate(se, se.getDB(), true);
            target.saveEvents(new LinkedHashMap<String, SEventFwd>(eo.getActiveAndInsertedAsClosed()));
            target.saveEventsExt(new LinkedHashMap<String, SEventFwd>(eo.getActiveAndInsertedAsClosed()));
            System.out.println("Moved active and inserted as closed events");
            target.saveEvents(new LinkedHashMap<String, SEventFwd>(eo.getClosed()));
            target.saveEventsExt(new LinkedHashMap<String, SEventFwd>(eo.getClosed()));
            System.out.println("Moved closed events");
            for (String string : eo.getActiveAndInsertedAsClosed().keySet()) {
                List<String> annotations2 = se.getDB().loadAnnotations(string);
                if (annotations2 == null || annotations2.isEmpty()) continue;
                HashMapMap<String, Annotation> anno2 = new HashMapMap<String, Annotation>();
                for (String string2 : annotations2) {
                    anno2.putV(string, Annotation.parseString(string2));
                }
                target.saveAnnotations(anno2);
                System.out.println(annotations2.size() + " annotations moved. event id: " + string);
            }
            for (String string : eo.getClosed().keySet()) {
                List<String> annotations2 = se.getDB().loadAnnotations(string);
                if (annotations2 == null || annotations2.isEmpty()) continue;
                HashMapMap<String, Annotation> anno2 = new HashMapMap<String, Annotation>();
                for (String string3 : annotations2) {
                    anno2.putV(string, Annotation.parseString(string3));
                }
                target.saveAnnotations(anno2);
                System.out.println(annotations2.size() + " annotations moved. event id: " + string);
            }
            eo.getActiveAndInsertedAsClosed().clear();
            eo.getClosed().clear();
            EventsMigrateOutage eventsMigrateOutage = new EventsMigrateOutage(se, se.getDB_OUTAGE(), true);
            targetOutage.saveEvents(new LinkedHashMap<String, SEventFwd>(eventsMigrateOutage.getActiveAndInsertedAsClosed()));
            targetOutage.saveEventsExt(new LinkedHashMap<String, SEventFwd>(eventsMigrateOutage.getActiveAndInsertedAsClosed()));
            System.out.println("Moved active and inserted as closed events");
            targetOutage.saveEvents(new LinkedHashMap<String, SEventFwd>(eventsMigrateOutage.getClosed()));
            targetOutage.saveEventsExt(new LinkedHashMap<String, SEventFwd>(eventsMigrateOutage.getClosed()));
            System.out.println("Moved closed events");
            for (String id : eventsMigrateOutage.getActiveAndInsertedAsClosed().keySet()) {
                annotations = se.getDB_OUTAGE().loadAnnotations(id);
                if (annotations == null || annotations.isEmpty()) continue;
                anno = new HashMapMap<String, Annotation>();
                for (String anStr : annotations) {
                    ((HashMapMap)anno).putV((String)id, (Annotation)Annotation.parseString(anStr));
                }
                targetOutage.saveAnnotations((HashMapMap<String, Annotation>)anno);
                System.out.println(annotations.size() + " annotations moved. event id: " + id);
            }
            for (String id : eventsMigrateOutage.getClosed().keySet()) {
                annotations = se.getDB_OUTAGE().loadAnnotations(id);
                if (annotations == null || annotations.isEmpty()) continue;
                anno = new HashMapMap();
                for (String anStr : annotations) {
                    ((HashMapMap)anno).putV(id, Annotation.parseString(anStr));
                }
                targetOutage.saveAnnotations((HashMapMap<String, Annotation>)anno);
                System.out.println(annotations.size() + " annotations moved. event id: " + id);
            }
            eventsMigrateOutage.getActiveAndInsertedAsClosed().clear();
            eventsMigrateOutage.getClosed().clear();
            FakeUserManager fakeUserManager = new FakeUserManager();
            fakeUserManager.getRoles().forEach(role -> {
                try {
                    target.savePowerGroups(role.getID(), new ArrayList<PowerGroup>(um.getPowerGroups(role.getID()).keySet()));
                    System.out.println("Stored PGs for user role id: " + role.getID());
                }
                catch (Exception e) {
                    System.out.println("Error storing PGs for user role id: " + role.getID());
                    e.printStackTrace();
                }
            });
            List<UItem> itemsSource = fakeUserManager.getUItems();
            List<UItem> itemsTarget = target.readItems();
            for (UItem uItem : itemsSource) {
                if (!itemsTarget.stream().noneMatch(itemT -> itemT.id == item.id)) continue;
                target.addItem(uItem.id, uItem.name, uItem.description);
            }
            List<UserRole> rolesSource = fakeUserManager.getRoles();
            rolesSource.forEach(sourceRole -> {
                try {
                    target.saveRole((UserRole)sourceRole);
                    System.out.println("Add Role " + String.valueOf(sourceRole));
                }
                catch (Exception e) {
                    System.out.println("Error adding Role " + String.valueOf(sourceRole));
                    e.printStackTrace();
                }
            });
            List<User> list = fakeUserManager.getUsers();
            list.forEach(sourceUser -> {
                try {
                    target.saveUser((User)sourceUser);
                    System.out.println("Add User " + String.valueOf(sourceUser));
                }
                catch (Exception e) {
                    System.out.println("Error adding User " + String.valueOf(sourceUser));
                    e.printStackTrace();
                }
            });
            System.out.println("agents " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM agents;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM agents;")));
            System.out.println("agents_ext " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM agents_ext;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM agents_ext;")));
            System.out.println("agents_ext_labels " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM agents_ext_labels;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM agents_ext_labels;")));
            System.out.println("annotations " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM annotations WHERE ID IN (SELECT ID FROM EVENTS);")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM annotations;")));
            System.out.println("assignments " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM assignments;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM assignments;")));
            System.out.println("events " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM events;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM events;")));
            System.out.println("events_ext " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM events_ext;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM events_ext;")));
            System.out.println("* events_a " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM events_a;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM events_a;")));
            System.out.println("* events_ext_a " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM events_ext_a;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM events_ext_a;")));
            System.out.println("instructions " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM instructions;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM instructions;")));
            System.out.println("items " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM items;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM items;")));
            System.out.println("o_agents " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM o_agents;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM o_agents;")));
            System.out.println("o_annotations " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM o_annotations;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM o_annotations;")));
            System.out.println("o_events " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM o_events;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM o_events;")));
            System.out.println("o_events_ext " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM o_events_ext;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM o_events_ext;")));
            System.out.println("pgitems " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM pgitems;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM pgitems;")));
            System.out.println("pgrights " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM pgrights;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM pgrights;")));
            System.out.println("pgroups " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM pgroups;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM pgroups;")));
            System.out.println("policies " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM policies;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM policies;")));
            System.out.println("rights " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM rights;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM rights;")));
            System.out.println("roles " + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM roles;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM roles;")));
            System.out.println("users" + String.valueOf(se.getDB().getConnectorArchive().query("SELECT COUNT(*) FROM users;")) + "-" + String.valueOf(target.getConnectorArchive().query("SELECT COUNT(*) FROM users;")));
            System.out.println("* - not moved");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println(" *** FINISHED *** ");
        System.exit(0);
    }

    public static class FakeForwardManager
    extends ForwardManager {
        @Override
        public void checkAllWhileLoading(SEventFwd se) {
        }
    }

    public static class EventsMigrate
    extends EventOperations {
        public EventsMigrate(ServerEngine se, DB db, boolean init) {
            super(se, db, init);
        }

        public Map<String, SEventFwd> getActiveAndInsertedAsClosed() {
            return this.m_activeAndInsertedAsClosed;
        }

        public Map<String, SEventFwd> getClosed() {
            return this.m_closed;
        }
    }

    public static class EventsMigrateOutage
    extends EventOperationsOutage {
        public EventsMigrateOutage(ServerEngine se, DB dboutage, boolean init) {
            super(se, dboutage, init);
        }

        public Map<String, SEventFwd> getActiveAndInsertedAsClosed() {
            return this.m_activeAndInsertedAsClosed;
        }

        public Map<String, SEventFwd> getClosed() {
            return this.m_closed;
        }
    }

    public static class FakeUserManager
    extends UserManager {
        public FakeUserManager() {
            this.loadItems();
            this.loadRoles();
            this.loadUsers();
            this.loadPowerGroups();
        }

        @Override
        public void removeZombieActions() {
        }
    }
}

