/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.notify;

import com.blixx.server.notify.QueuedNotifier;
import com.blixx.shared.Cryptor;
import com.blixx.shared.notify.NotificationMsg;
import com.blixx.shared.notify.Notifier;
import com.blixx.shared.notify.NovelConfig;
import com.blixx.shared.notify.Worker;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;

public class MailSender
extends QueuedNotifier {
    public static final String MAIL_PATTERN = "^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?!-)(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
    private static final String FILE_MAIL_FAILED = "mail.retry";
    private static final String FILE_MAIL_UNSENT = "mail.new";
    public static final String FILE_SMS_EXPIRED = "mail.failed";
    private static final String TRUST_ALL_SOCKET_FACTORY = TrustAllSSLSocketFactory.class.getName();

    public MailSender(NovelConfig config, Path mainNotifiDirectory) {
        super(config, mainNotifiDirectory);
        this.failedFileName = FILE_MAIL_FAILED;
        this.unsentFileName = FILE_MAIL_UNSENT;
        this.expiredFileName = FILE_SMS_EXPIRED;
    }

    @Override
    public synchronized void init() {
        String value;
        super.init();
        Properties p = this.getConfig().getProperties();
        if (!p.containsKey("mail.smtp.host") || "".equals(p.getProperty("mail.smtp.host"))) {
            throw new IllegalArgumentException(" Missing 'SMTP Host'!");
        }
        if (!p.containsKey("mail.smtp.port") || "".equals(p.getProperty("mail.smtp.port"))) {
            p.setProperty("mail.smtp.port", "25");
        }
        if (!p.containsKey("from") || "".equals(p.getProperty("from"))) {
            throw new IllegalArgumentException(" Missing E-Mail 'FROM' Address!");
        }
        if (!p.containsKey("to") || "".equals(p.getProperty("to"))) {
            throw new IllegalArgumentException(" Missing E-Mail 'TO' Address!");
        }
        p.setProperty("mail.transport.protocol", "smtp");
        if (p.getProperty("mail.smtp.starttls.enable") == null) {
            p.setProperty("mail.smtp.starttls.enable", "true");
        }
        if ((value = p.getProperty("mail.smtp.password")) != null && !value.isEmpty()) {
            p.setProperty("mail.smtp.password.encrypted", Cryptor.encrypt3(value));
            p.remove("mail.smtp.password");
        }
        DefaultAuthenticator auth = null;
        if (Boolean.parseBoolean(p.getProperty("mail.smtp.auth"))) {
            auth = new DefaultAuthenticator(p.getProperty("mail.smtp.user"), Cryptor.decrypt(p.getProperty("mail.smtp.password.encrypted")));
        }
        p.setProperty("mail.smtps.ssl.socketFactory.class", TRUST_ALL_SOCKET_FACTORY);
        p.setProperty("mail.smtps.ssl.socketFactory.fallback", "false");
        p.setProperty("mail.smtp.ssl.socketFactory.class", TRUST_ALL_SOCKET_FACTORY);
        p.setProperty("mail.smtp.ssl.socketFactory.fallback", "false");
        Session session = Session.getInstance(p, auth);
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.worker = new MailWorker(this, session);
        this.worker.start();
        this.isStarted = true;
    }

    class MailWorker
    extends Worker {
        private final Session session;

        public MailWorker(Notifier notifi, Session session) {
            super(notifi);
            this.setName("NF_" + notifi.getConfig().getId());
            this.session = session;
        }

        @Override
        public boolean sendMessage(NotificationMsg m, long t) throws InterruptedException {
            String userName;
            boolean gotProblem = true;
            Pattern pattern = Pattern.compile(MailSender.MAIL_PATTERN);
            Matcher matcher = pattern.matcher(userName = this.session.getProperties().getProperty("mail.smtp.user"));
            if (matcher.matches() && userName.equals(this.session.getProperties().getProperty("mail.smtp.password"))) {
                throw new IllegalArgumentException(" Username and Password can not be the same.");
            }
            ArrayList<InternetAddress> toList = new ArrayList<InternetAddress>();
            ArrayList<InternetAddress> replayList = new ArrayList<InternetAddress>();
            try {
                Email mail = null;
                mail = m.isHtml() ? new HtmlEmail() : new SimpleEmail();
                mail.setSubject(m.getSubject());
                mail.setMailSession(this.session);
                mail.setCharset("utf-8");
                String to = m.getTo();
                if (to == null || "".equals(to)) {
                    throw new IllegalArgumentException(" Missing E-Mail 'TO' Address!");
                }
                if (to.indexOf(59) != -1) {
                    String[] split = to.split(";");
                    for (int i = 0; i < split.length; ++i) {
                        String email = split[i];
                        if (email.length() == 0) continue;
                        InternetAddress ia = new InternetAddress(email);
                        toList.add(ia);
                    }
                    mail.setTo(toList);
                } else {
                    mail.addTo(m.getTo());
                }
                mail.setFrom(m.getFrom());
                InternetAddress ia = new InternetAddress(m.getFrom());
                replayList.add(ia);
                mail.setReplyTo(replayList);
                if (mail instanceof HtmlEmail) {
                    ((HtmlEmail)mail).setHtmlMsg(m.getMsg());
                } else {
                    mail.setMsg(m.getMsg());
                }
                String answer = mail.send();
                MailSender.this.log.print(1, "OK sent. Subj: " + mail.getSubject() + " to:(" + to + ") SMTP server answer: " + answer);
                MailSender.this.failed.remove(m);
                gotProblem = false;
            }
            catch (Throwable e) {
                MailSender.this.putErrorIntoMsg(m, e);
                MailSender.this.log.print(1, "Failed to send mail", e);
            }
            return gotProblem;
        }

        @Override
        public void shutDownHook() {
            MailSender.this.log.closeAllStreams();
        }
    }

    public static class TrustAllSSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory factory;
        private static final X509Certificate[] EMPTY_X509Certificate = new X509Certificate[0];

        public TrustAllSSLSocketFactory() {
            SSLContext sslcontext = null;
            try {
                sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, new TrustManager[]{new X509TrustManager(this){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return EMPTY_X509Certificate;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }}, new SecureRandom());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create the SSL context", e);
            }
            this.factory = sslcontext.getSocketFactory();
        }

        public static synchronized SocketFactory getDefault() {
            return new TrustAllSSLSocketFactory();
        }

        @Override
        public Socket createSocket(Socket socket, String s, int i, boolean flag) throws IOException {
            return this.factory.createSocket(socket, s, i, flag);
        }

        @Override
        public Socket createSocket(InetAddress inaddr, int i, InetAddress inaddr1, int j) throws IOException {
            return this.factory.createSocket(inaddr, i, inaddr1, j);
        }

        @Override
        public Socket createSocket(InetAddress inaddr, int i) throws IOException {
            return this.factory.createSocket(inaddr, i);
        }

        @Override
        public Socket createSocket(String s, int i, InetAddress inaddr, int j) throws IOException {
            return this.factory.createSocket(s, i, inaddr, j);
        }

        @Override
        public Socket createSocket(String s, int i) throws IOException {
            return this.factory.createSocket(s, i);
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.factory.createSocket();
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }
    }
}

