/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.notify;

import com.blixx.log.SALogger;
import com.blixx.server.notify.MessageStore;
import com.blixx.shared.notify.NotificationMsg;
import com.blixx.shared.notify.Notifier;
import com.blixx.shared.notify.NotifierQueueFull;
import com.blixx.shared.notify.NotifierStatus;
import com.blixx.shared.notify.NotifierStopped;
import com.blixx.shared.notify.NovelConfig;
import com.blixx.shared.notify.Worker;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class QueuedNotifier
extends Notifier {
    protected String failedFileName = "FAILED";
    protected String unsentFileName = "UNSENT";
    protected String expiredFileName = "EXPIRED";
    protected LinkedBlockingQueue<NotificationMsg> queue;
    protected LinkedBlockingQueue<NotificationMsg> failed;
    protected LinkedBlockingQueue<NotificationMsg> expiredQueue;
    protected Worker worker;
    protected ExpiredWorker expWorker;
    protected long expireInterval = 0x6DDD00L;
    protected long retryInterval = 600000L;
    protected int queueLimit = 500000;
    protected long expFileSize = 0x100000L;
    protected Path dirPath;
    protected SALogger log = new SALogger();
    protected AtomicInteger m_finalFailed = new AtomicInteger();

    protected QueuedNotifier(NovelConfig config, Path mainNotifiDirectory) {
        super(config);
        this.dirPath = mainNotifiDirectory.resolve("notifications").resolve(config.getId()).toAbsolutePath();
        this.log.setDir(this.dirPath.toString(), this.log.getFilePrefix());
    }

    @Override
    public synchronized void init() {
        this.expireInterval = this.m_config.getExpireInterval();
        if (this.expireInterval < 1000L) {
            throw new RuntimeException("Misconfigured Notification config! Expire interval is too small: " + this.expireInterval + "ms");
        }
        this.retryInterval = this.m_config.getRetryInterval();
        if (this.retryInterval < 1000L) {
            throw new RuntimeException("Misconfigured Notification config! Retry interval is too small: " + this.retryInterval + "ms");
        }
        this.queueLimit = this.m_config.getMaxQueueSize();
        if (this.queueLimit < 1) {
            throw new RuntimeException("Misconfigured Notification config! Queue limit is invalid: " + this.queueLimit);
        }
        long maxExpiredFileSize = this.m_config.getMaxExpiredFileSize();
        if (maxExpiredFileSize < 1L) {
            throw new RuntimeException("Misconfigured Notification config! Max file size is too small: " + maxExpiredFileSize + " bytes");
        }
        this.expFileSize = 1024L * maxExpiredFileSize;
        if (this.queue == null) {
            this.queue = new LinkedBlockingQueue(this.queueLimit);
            try {
                this.queue.addAll(MessageStore.read(this.dirPath.resolve(this.unsentFileName).toFile()));
            }
            catch (Exception e) {
                this.log.print(1, "Failed to read unsent queue", e);
            }
            this.failed = new LinkedBlockingQueue(this.queueLimit);
            try {
                this.failed.addAll(MessageStore.read(this.dirPath.resolve(this.failedFileName).toFile()));
            }
            catch (Exception e) {
                this.log.print(1, "Failed to read retry queue", e);
            }
            this.expiredQueue = new LinkedBlockingQueue();
        }
        if (this.expWorker != null) {
            this.expWorker.interrupt();
        }
        this.expWorker = new ExpiredWorker(this.expiredFileName);
        this.expWorker.start();
        this.m_finalFailed.set(0);
        this.log.print(1, "Notifier started");
    }

    @Override
    public synchronized NotificationMsg enqueueMsg(String from, String recipient, String msg, String subj, boolean isHtml) throws NotifierStopped, NotifierQueueFull {
        NotificationMsg mess = null;
        if (!this.isStarted()) {
            this.log.print(1, "Ignored message while sender is not running.");
            throw new NotifierStopped();
        }
        if (msg == null) {
            msg = "";
        }
        if (subj == null) {
            subj = "";
        }
        mess = this.createNotificationMsg(from, recipient, msg, subj, isHtml);
        try {
            this.queue.add(mess);
            StringBuilder sb = new StringBuilder("+Queue: ").append(msg);
            this.log.print(1, sb);
            this.saveOutgoingQueue();
        }
        catch (IllegalStateException e) {
            this.log.print(1, "Queue is full, message is ignored.");
            throw new NotifierQueueFull();
        }
        catch (Exception e) {
            this.log.print(1, "error", e);
        }
        return mess;
    }

    @Override
    public NotificationMsg createNotificationMsg(String from, String recipient, String msg, String subj, boolean isHtml) {
        NotificationMsg mess = new NotificationMsg();
        mess.setHtml(isHtml);
        mess.setMsg(msg);
        mess.setSubject(subj);
        mess.setTo(recipient);
        mess.setFrom(from);
        mess.setExpire(System.currentTimeMillis() + this.expireInterval);
        return mess;
    }

    @Override
    public int getFailedQueSize() {
        return this.failed == null ? 0 : this.failed.size();
    }

    @Override
    public int getQueSize() {
        return this.queue == null ? 0 : this.queue.size();
    }

    @Override
    public int getFailedFinal() {
        return this.m_finalFailed.get();
    }

    protected void spillQueue(Collection<NotificationMsg> msgs, File f) {
        try {
            MessageStore.save(msgs, f);
        }
        catch (Exception ex) {
            this.log.print(1, "Failed to store messages to file:" + f.getName(), ex);
        }
    }

    @Override
    public synchronized void shutdown() {
        this.isStarted = false;
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.saveOutgoingQueue();
        this.saveFailedQueue();
        if (this.expWorker != null) {
            this.expWorker.interrupt();
        }
        this.log.print(1, "Notifier stopped");
        this.log.closeAllStreams();
    }

    @Override
    public void saveFailedQueue() {
        if (this.failed != null) {
            this.spillQueue(this.failed, this.dirPath.resolve(this.failedFileName).toFile());
        }
    }

    @Override
    public void saveOutgoingQueue() {
        if (this.queue != null) {
            this.spillQueue(this.queue, this.dirPath.resolve(this.unsentFileName).toFile());
        }
    }

    protected void putErrorIntoMsg(NotificationMsg m, Throwable e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            StringBuilder sb = new StringBuilder(e.getMessage());
            sb.append("\ncaused by ").append(cause.getMessage());
            if (cause.getCause() != null) {
                sb.append("\ncaused by ").append(cause.getCause().getMessage());
            }
            m.error = sb.toString();
        } else {
            m.error = e.getMessage();
        }
    }

    @Override
    public Worker getWorker() {
        return this.worker;
    }

    @Override
    public NotifierStatus getActualStatus() {
        NotifierStatus ns = this.m_config.getNotifierStatus();
        ns.setFailedCount(this.getFailedFinal());
        ns.setQueueSize(this.getQueSize() + this.getFailedQueSize());
        return ns;
    }

    @Override
    public LinkedBlockingQueue<NotificationMsg> getExpiredQueue() {
        return this.expiredQueue;
    }

    @Override
    public LinkedBlockingQueue<NotificationMsg> getFailedQueue() {
        return this.failed;
    }

    @Override
    public LinkedBlockingQueue<NotificationMsg> getQueue() {
        return this.queue;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }

    class ExpiredWorker
    extends Thread {
        final SALogger m_expired = new SALogger();

        public ExpiredWorker(String baseName) {
            this.m_expired.setDir(QueuedNotifier.this.dirPath.toString(), baseName + ".expired");
            this.m_expired.setMaxSize(QueuedNotifier.this.expFileSize);
            this.m_expired.setMaxCount(10);
            this.m_expired.setLevel(1);
        }

        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        NotificationMsg msg;
                        if ((msg = QueuedNotifier.this.expiredQueue.poll(QueuedNotifier.this.retryInterval, TimeUnit.MILLISECONDS)) == null) {
                            continue;
                        }
                        String sb = "$from: " + msg.getFrom() + "\n$to: " + msg.getTo() + "\n$subj: " + msg.getSubject() + "\n$msg: " + msg.getMsg() + "\n";
                        this.m_expired.printStringDirect(sb);
                        QueuedNotifier.this.m_finalFailed.incrementAndGet();
                        this.m_expired.print(1, "Expired message dumped to the file.");
                    }
                }
                catch (Throwable throwable) {
                    this.m_expired.closeAllStreams();
                }
            }
            catch (Throwable throwable) {
                this.m_expired.closeAllStreams();
                throw throwable;
            }
        }
    }
}

