/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.perf;

import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.blixx.server.ServerEngine;
import com.blixx.shared.Interval;
import com.blixx.shared.SEventFwd;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.DateTickUnitType;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class Chart01
extends SchedulerTask {
    public static final Font TITLE_FONT = new Font("SansSerif", 0, 9);
    private static final Color COLOR_LIGHT_GREY = new Color(239, 239, 239);
    private static final Color COLOR_UNKNOWN = new Color(150, 150, 150);
    private static final Color COLOR_NORMAL = new Color(20, 255, 20);
    private static final Color COLOR_WARNING = new Color(37, 68, 131);
    private static final Color COLOR_MINOR = new Color(255, 255, 10);
    private static final Color COLOR_MAJOR = new Color(222, 142, 35);
    private static final Color COLOR_RED = new Color(255, 0, 0);
    private long m_lastTime = 0L;
    private boolean m_isRunning = false;

    public Chart01(String TaskName) {
        super(TaskName);
        this.setInterval(Interval.getSimpleInterval(300));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onGetData() {
        long time;
        if (!this.m_isRunning && (time = System.currentTimeMillis()) - this.m_lastTime > 60000L) {
            try {
                this.m_isRunning = true;
                this.generateCharts();
            }
            catch (Throwable e) {
                RTLogger.print(5, "Charting error: " + String.valueOf(e));
            }
            finally {
                this.m_isRunning = false;
                this.m_lastTime = System.currentTimeMillis();
            }
            RTLogger.print(5, "Charting " + (time - System.currentTimeMillis()) + "ms");
        }
        return true;
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public boolean onStartRun() {
        return true;
    }

    @Override
    public boolean onStopRun() {
        return true;
    }

    @Override
    protected boolean onStopTask() {
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCharts() {
        try {
            Stats7 stat = this.process();
            this.generateMessagesPieActive(stat, "srv/html/activeMsgPie.png", "Active Indications by Severity");
            this.generateMessagesPieClosed(stat, "srv/html/acknMsgPie.png", "Closed Indications by Severity");
            DefaultPieDataset<Object> pieDataset = new DefaultPieDataset<Object>();
            pieDataset.setValue((Object)"Auto ackn.", stat.autoClosed.get());
            pieDataset.setValue((Object)"Operator ackn.", stat.opClosed.get());
            this.saveFile("srv/html/auto_op_ackn.png", pieDataset, "Auto vs Operator closed");
            TreeMap<Integer, String> byCount = new TreeMap<Integer, String>(new Comparator<Integer>(this){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return Integer.compare(o2, o1);
                }
            });
            for (Map.Entry<String, AtomicInteger> en : stat.byHosts.entrySet()) {
                byCount.put(en.getValue().get(), en.getKey());
            }
            pieDataset = new DefaultPieDataset();
            Iterator it = byCount.entrySet().iterator();
            for (int count = 5; it.hasNext() && count > 0; --count) {
                Map.Entry en = it.next();
                pieDataset.setValue((Comparable)en.getValue(), (Number)en.getKey());
            }
            this.saveFile("srv/html/hostsInd.png", pieDataset, "Active Indications Top 5 Hosts");
            this.generateActivityCharts(stat);
            this.generateActivityBarCharts(stat);
        }
        catch (Throwable e) {
            RTLogger.print(3, "Error generating charts.", e);
        }
    }

    public void generateActivityCharts(Stats7 stat) throws IOException {
        TimeSeries ts_crit = new TimeSeries((Comparable)((Object)"critical"));
        TimeSeries ts_majo = new TimeSeries((Comparable)((Object)"major"));
        TimeSeries ts_mino = new TimeSeries((Comparable)((Object)"minor"));
        TimeSeries ts_warn = new TimeSeries((Comparable)((Object)"warning"));
        TimeSeries ts_norm = new TimeSeries((Comparable)((Object)"normal"));
        TimeSeries ts_unkn = new TimeSeries((Comparable)((Object)"unknown"));
        block0: for (int i = 0; i < 7; ++i) {
            Calendar curr = Calendar.getInstance();
            curr.setTimeInMillis(stat.min.getTimeInMillis());
            curr.add(5, i);
            for (int j = 0; j < 24; ++j) {
                curr.set(11, j);
                if (curr.after(Calendar.getInstance())) continue block0;
                Hour hour = new Hour(curr.getTime());
                ts_crit.addOrUpdate((RegularTimePeriod)hour, stat.crtitical[i][j]);
                ts_majo.addOrUpdate((RegularTimePeriod)hour, stat.major[i][j]);
                ts_mino.addOrUpdate((RegularTimePeriod)hour, stat.minor[i][j]);
                ts_warn.addOrUpdate((RegularTimePeriod)hour, stat.warning[i][j]);
                ts_norm.addOrUpdate((RegularTimePeriod)hour, stat.normal[i][j]);
                ts_unkn.addOrUpdate((RegularTimePeriod)hour, stat.unknown[i][j]);
            }
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(ts_crit);
        dataset.addSeries(ts_majo);
        dataset.addSeries(ts_mino);
        dataset.addSeries(ts_warn);
        dataset.addSeries(ts_norm);
        dataset.addSeries(ts_unkn);
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Indication activity last 7 days", "Time", "Indications count", dataset, true, false, false);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TextTitle timeOfRefresh = new TextTitle(sdf.format(new Date(System.currentTimeMillis())));
        timeOfRefresh.setFont(TITLE_FONT);
        chart.addSubtitle(timeOfRefresh);
        chart.getLegend().setBorder(0.0, 0.0, 0.0, 0.0);
        XYPlot plot = (XYPlot)chart.getPlot();
        chart.getLegend().setBackgroundPaint(COLOR_LIGHT_GREY);
        XYItemRenderer br = plot.getRenderer();
        br.setSeriesPaint(0, COLOR_RED);
        br.setSeriesPaint(1, COLOR_MAJOR);
        br.setSeriesPaint(2, COLOR_MINOR);
        br.setSeriesPaint(3, COLOR_WARNING);
        br.setSeriesPaint(4, COLOR_NORMAL);
        br.setSeriesPaint(5, COLOR_UNKNOWN);
        plot.setOutlineVisible(false);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        DateAxis dateAxis = (DateAxis)plot.getDomainAxis();
        dateAxis.setVerticalTickLabels(true);
        dateAxis.setTickUnit(new DateTickUnit(DateTickUnitType.HOUR, 8));
        SimpleDateFormat SDF_dmhm = new SimpleDateFormat("dd MMM HH:mm");
        dateAxis.setDateFormatOverride(SDF_dmhm);
        ChartUtils.saveChartAsPNG(new File("srv/html/indActivity7d.png"), chart, 600, 300);
        Day dayNow = new Day();
        JFreeChart chart2 = ChartFactory.createTimeSeriesChart("Indication activity today", "Time", "Indication count", dataset, true, false, false);
        TextTitle timeOfRefresh2 = new TextTitle(sdf.format(new Date(System.currentTimeMillis())));
        timeOfRefresh2.setFont(TITLE_FONT);
        chart2.addSubtitle(timeOfRefresh);
        chart2.getLegend().setBorder(0.0, 0.0, 0.0, 0.0);
        XYPlot plot2 = (XYPlot)chart2.getPlot();
        chart2.getLegend().setBackgroundPaint(COLOR_LIGHT_GREY);
        XYItemRenderer br2 = plot2.getRenderer();
        br2.setSeriesPaint(0, COLOR_RED);
        br2.setSeriesPaint(1, COLOR_MAJOR);
        br2.setSeriesPaint(2, COLOR_MINOR);
        br2.setSeriesPaint(3, COLOR_WARNING);
        br2.setSeriesPaint(4, COLOR_NORMAL);
        br2.setSeriesPaint(5, COLOR_UNKNOWN);
        DateAxis domainAxis = (DateAxis)plot2.getDomainAxis();
        domainAxis.setRange(dayNow.getStart(), dayNow.getEnd());
        plot2.setOutlineVisible(false);
        plot2.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        domainAxis.setVerticalTickLabels(true);
        domainAxis.setTickUnit(new DateTickUnit(DateTickUnitType.HOUR, 1));
        SimpleDateFormat SDF_hm = new SimpleDateFormat("HH:mm");
        domainAxis.setDateFormatOverride(SDF_hm);
        ChartUtils.saveChartAsPNG(new File("srv/html/indActivity1d.png"), chart2, 600, 300);
    }

    public void generateActivityBarCharts(Stats7 stat) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        SimpleDateFormat sdf_ddMM = new SimpleDateFormat("dd MMM");
        for (int i = 0; i < 7; ++i) {
            Calendar curr = Calendar.getInstance();
            curr.setTimeInMillis(stat.min.getTimeInMillis());
            curr.add(5, i);
            int crit = 0;
            int majo = 0;
            int mino = 0;
            int warn = 0;
            int norm = 0;
            int unkn = 0;
            for (int j = 0; j < 24; ++j) {
                crit += stat.crtitical[i][j].get();
                majo += stat.major[i][j].get();
                mino += stat.minor[i][j].get();
                warn += stat.warning[i][j].get();
                norm += stat.normal[i][j].get();
                unkn += stat.unknown[i][j].get();
            }
            String day = sdf_ddMM.format(curr.getTime());
            dataset.addValue(crit, (Comparable)((Object)"critical"), (Comparable)((Object)day));
            dataset.addValue(majo, (Comparable)((Object)"major"), (Comparable)((Object)day));
            dataset.addValue(mino, (Comparable)((Object)"minor"), (Comparable)((Object)day));
            dataset.addValue(warn, (Comparable)((Object)"warning"), (Comparable)((Object)day));
            dataset.addValue(norm, (Comparable)((Object)"normal"), (Comparable)((Object)day));
            dataset.addValue(unkn, (Comparable)((Object)"unknown"), (Comparable)((Object)day));
        }
        JFreeChart chart = ChartFactory.createBarChart("Indication activity last 7 days", "Time", "Indications count", dataset, PlotOrientation.VERTICAL, true, false, false);
        chart.getLegend().setBorder(0.0, 0.0, 0.0, 0.0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TextTitle timeOfRefresh = new TextTitle(sdf.format(new Date(System.currentTimeMillis())));
        timeOfRefresh.setFont(TITLE_FONT);
        chart.addSubtitle(timeOfRefresh);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        chart.getLegend().setBackgroundPaint(COLOR_LIGHT_GREY);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
        BarRenderer br = (BarRenderer)plot.getRenderer();
        br.setSeriesPaint(0, COLOR_RED);
        br.setSeriesPaint(1, COLOR_MAJOR);
        br.setSeriesPaint(2, COLOR_MINOR);
        br.setSeriesPaint(3, COLOR_WARNING);
        br.setSeriesPaint(4, COLOR_NORMAL);
        br.setSeriesPaint(5, COLOR_UNKNOWN);
        br.setItemMargin(0.0);
        try {
            ChartUtils.saveChartAsPNG(new File("srv/html/indBarActivity7d.png"), chart, 600, 500);
        }
        catch (IOException e) {
            RTLogger.print(3, "Error generating charts.", e);
        }
    }

    public void generateMessagesPieActive(Stats7 stat, String filename, String title) {
        try {
            DefaultPieDataset<String> pieDataset = new DefaultPieDataset<String>();
            pieDataset.setValue("critical", stat.active[5]);
            pieDataset.setValue("major", stat.active[4]);
            pieDataset.setValue("minor", stat.active[3]);
            pieDataset.setValue("warning", stat.active[2]);
            pieDataset.setValue("normal", stat.active[1]);
            pieDataset.setValue("unknown", stat.active[0]);
            this.saveFile(filename, pieDataset, title);
        }
        catch (Throwable e) {
            RTLogger.print(3, "Error generating charts.", e);
        }
    }

    public void generateMessagesPieClosed(Stats7 stat, String filename, String title) {
        try {
            DefaultPieDataset<String> pieDataset = new DefaultPieDataset<String>();
            pieDataset.setValue("critical", stat.closed[5]);
            pieDataset.setValue("major", stat.closed[4]);
            pieDataset.setValue("minor", stat.closed[3]);
            pieDataset.setValue("warning", stat.closed[2]);
            pieDataset.setValue("normal", stat.closed[1]);
            pieDataset.setValue("unknown", stat.closed[0]);
            this.saveFile(filename, pieDataset, title);
        }
        catch (Throwable e) {
            RTLogger.print(3, "Error generating charts.", e);
        }
    }

    public void saveFile(String filename, DefaultPieDataset pieDataset, String titleStr) throws IOException {
        JFreeChart chart = ChartFactory.createPieChart(titleStr, (PieDataset)pieDataset, false, false, false);
        TextTitle title = chart.getTitle();
        title.setFont(TITLE_FONT);
        title.setBorder(0.0, 0.0, 0.0, 0.0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TextTitle timeOfRefresh = new TextTitle(sdf.format(new Date(System.currentTimeMillis())));
        timeOfRefresh.setFont(TITLE_FONT);
        chart.addSubtitle(timeOfRefresh);
        Color color_white = new Color(255, 255, 255);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setSectionPaint((Comparable)((Object)"critical"), COLOR_RED);
        plot.setSectionPaint((Comparable)((Object)"major"), COLOR_MAJOR);
        plot.setSectionPaint((Comparable)((Object)"minor"), COLOR_MINOR);
        plot.setSectionPaint((Comparable)((Object)"warning"), COLOR_WARNING);
        plot.setSectionPaint((Comparable)((Object)"normal"), COLOR_NORMAL);
        plot.setSectionPaint((Comparable)((Object)"unknown"), COLOR_UNKNOWN);
        plot.setLabelFont(TITLE_FONT);
        plot.setLabelOutlinePaint(color_white);
        plot.setLabelGenerator(new StandardPieSectionLabelGenerator("{0} ({1})\n{2}"));
        plot.setLabelBackgroundPaint(color_white);
        plot.setOutlinePaint(color_white);
        plot.setOutlineVisible(false);
        plot.setInteriorGap(0.1);
        plot.setLabelGap(0.0);
        ChartUtils.saveChartAsPNG(new File(filename), chart, 300, 200);
    }

    public Stats7 process() {
        Stats7 stat = new Stats7();
        try {
            Iterator<SEventFwd> it = ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveAndInsertedAsClosedIterator();
            while (it.hasNext()) {
                stat.add(it.next());
            }
            it = ServerEngine.getInstance().getEventsRouter().getEventOperations().getClosedIterator();
            while (it.hasNext()) {
                stat.add(it.next());
            }
            stat.fillNullsAll();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return stat;
    }

    public static class Stats7 {
        public AtomicInteger[][] unknown = new AtomicInteger[7][24];
        public AtomicInteger[][] normal = new AtomicInteger[7][24];
        public AtomicInteger[][] warning = new AtomicInteger[7][24];
        public AtomicInteger[][] minor = new AtomicInteger[7][24];
        public AtomicInteger[][] major = new AtomicInteger[7][24];
        public AtomicInteger[][] crtitical = new AtomicInteger[7][24];
        public AtomicInteger[] active = new AtomicInteger[6];
        public AtomicInteger[] closed = new AtomicInteger[6];
        public AtomicInteger autoClosed = new AtomicInteger(0);
        public AtomicInteger opClosed = new AtomicInteger(0);
        public Calendar start = null;
        public Calendar min = null;
        public Map<String, AtomicInteger> byHosts = new HashMap<String, AtomicInteger>();
        public static final int MILLIS_IN_DAY = 86400000;

        public Stats7() {
            for (int i = 0; i < 6; ++i) {
                this.active[i] = new AtomicInteger(0);
                this.closed[i] = new AtomicInteger(0);
            }
            this.start = Calendar.getInstance();
            this.min = Calendar.getInstance();
            this.min.set(14, 0);
            this.min.set(13, 0);
            this.min.set(12, 0);
            this.min.set(10, 0);
            this.min.add(5, -6);
        }

        public void fillNullsAll() {
            this.fillNulls(this.unknown);
            this.fillNulls(this.normal);
            this.fillNulls(this.warning);
            this.fillNulls(this.minor);
            this.fillNulls(this.major);
            this.fillNulls(this.crtitical);
        }

        public void fillNulls(AtomicInteger[][] array) {
            for (int i = 0; i < array.length; ++i) {
                for (int j = 0; j < array[0].length; ++j) {
                    if (array[i][j] != null) continue;
                    array[i][j] = new AtomicInteger(0);
                }
            }
        }

        public void add(SEventFwd se) {
            AtomicInteger countByHost;
            int sev = se.getSeverityInt();
            if (sev < 0) {
                sev += 6;
            }
            if (se.isActive()) {
                this.active[sev].incrementAndGet();
            } else {
                this.closed[sev].incrementAndGet();
                if (se.isClosedByOperator()) {
                    this.opClosed.incrementAndGet();
                } else {
                    this.autoClosed.incrementAndGet();
                }
            }
            String node = se.getNode();
            if (node.length() == 0) {
                node = se.getAgentNode().length() > 0 ? se.getAgentNode() : "BOOM_SERVER";
            }
            if ((countByHost = this.byHosts.get(node)) == null) {
                countByHost = new AtomicInteger(1);
                this.byHosts.put(se.getNode(), countByHost);
            } else {
                countByHost.incrementAndGet();
            }
            long diffMillis = se.getSTime() - this.min.getTimeInMillis();
            if (diffMillis >= 0L) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(se.getSTime());
                int daysFromMin = (int)diffMillis / 86400000;
                int hour = cal.get(11);
                switch (se.getSeverityInt()) {
                    case -6: 
                    case 0: {
                        this.apply(this.unknown, daysFromMin, hour);
                        break;
                    }
                    case -5: 
                    case 1: {
                        this.apply(this.normal, daysFromMin, hour);
                        break;
                    }
                    case -4: 
                    case 2: {
                        this.apply(this.warning, daysFromMin, hour);
                        break;
                    }
                    case -3: 
                    case 3: {
                        this.apply(this.minor, daysFromMin, hour);
                        break;
                    }
                    case -2: 
                    case 4: {
                        this.apply(this.major, daysFromMin, hour);
                        break;
                    }
                    case -1: 
                    case 5: {
                        this.apply(this.crtitical, daysFromMin, hour);
                        break;
                    }
                }
            }
        }

        private void apply(AtomicInteger[][] array, int daysFromMin, int hour) {
            AtomicInteger count = array[daysFromMin][hour];
            if (count == null) {
                array[daysFromMin][hour] = new AtomicInteger(1);
            } else {
                count.incrementAndGet();
            }
        }
    }
}

