/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.perf;

import com.bes.utils.FilePathTraversalCheck;
import com.blixx.log.RTLogger;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerProperties;
import com.blixx.server.UserManager;
import com.blixx.server.ext.EventIterator;
import com.blixx.server.perf.PerfManager;
import com.blixx.server.perf.Response;
import com.blixx.shared.BM;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.ZIP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class NanoHTTPD {
    public static final String USER = "CONNECTED_USER";
    private static final String SEV_NORMAL = "sev_normal";
    private static final String SEV_UNKNOWN = "sev_unknown";
    private static final String SEV_WARNING = "sev_warning";
    private static final String SEV_MINOR = "sev_minor";
    private static final String SEV_MAJOR = "sev_major";
    private static final String SEV_CRITICAL = "sev_critical";
    private static final String ACTIVE_INDICATIONS = "ACTIVE_INDICATIONS";
    private static final String INDI_LIMIT = "indi_limit";
    private static final String UI_LIST = "UI_LIST";
    private static final String AGENTS_LIST = "AGENTS_LIST";
    private static final String PKG_LIST = "PKG_LIST";
    private static HashMap<String, String> m_global = new HashMap();
    public static final String HTTP_OK = "200 OK";
    public static final String HTTP_REDIRECT = "301 Moved Permanently";
    public static final String HTTP_FORBIDDEN = "403 Forbidden";
    public static final String HTTP_NOTFOUND = "404 Not Found";
    public static final String HTTP_BADREQUEST = "400 Bad Request";
    public static final String HTTP_INTERNALERROR = "500 Internal Server Error";
    public static final String HTTP_NOTIMPLEMENTED = "501 Not Implemented";
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_DEFAULT_BINARY = "application/octet-stream";
    private static Hashtable<String, String> theMimeTypes = new Hashtable();
    private static final String LICENCE = "Copyright (C) 2001,2005-2008 by Jarno Elonen <elonen@iki.fi>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";

    /*
     * Enabled aggressive exception aggregation
     */
    public Response serve(String uri, String method, Properties header, Map parms) {
        String response = "Request can not be processed.";
        if (uri.equalsIgnoreCase("/")) {
            uri = "/srv/html/index.html";
        }
        if (uri.startsWith("/status")) {
            int value;
            String username = header.getProperty(USER);
            if (username != null && (value = UserManager.getInstance().getRights(1003, username)) <= 1) {
                return new Response(HTTP_FORBIDDEN, MIME_HTML, "Access denied");
            }
            if (uri.equalsIgnoreCase("/status") || uri.equalsIgnoreCase("/status/")) {
                String htmlTemplate = this.loadTemplate("status.html", response);
                response = this.replaceAll(htmlTemplate, ServerEngine.getInstance().getStatus());
                return new Response(HTTP_OK, MIME_HTML, response);
            }
            if (uri.equalsIgnoreCase("/status/bsr") || uri.equalsIgnoreCase("/status/bsr/")) {
                HashMap<String, String> status = ServerEngine.getInstance().getStatus();
                File f = new File("bsr");
                try (FileOutputStream fos = new FileOutputStream(f);){
                    Response response2;
                    try (SDataOutputStream sdo = new SDataOutputStream(fos, 1);){
                        StringBuffer sb = new StringBuffer();
                        for (Map.Entry en : status.entrySet()) {
                            String key = (String)en.getKey();
                            Object val = en.getValue();
                            sb.append(key).append('=').append(val).append('\n');
                        }
                        sdo.writeUTF(sb.toString());
                        response2 = this.serveFile("/" + f.getName(), header, new File("."), false);
                    }
                    return response2;
                }
                catch (Throwable e1) {
                    RTLogger.print(3, "BSR error:", e1);
                    return new Response(HTTP_NOTFOUND, MIME_HTML, "ERROR");
                }
            }
            if (uri.endsWith(".png")) {
                return this.serveFile(uri.substring("/status".length()), header, new File("."), false);
            }
        } else {
            if (uri.startsWith("/perf")) {
                int value;
                String username = header.getProperty(USER);
                if (username != null && (value = UserManager.getInstance().getRights(1003, username)) <= 1) {
                    return new Response(HTTP_FORBIDDEN, MIME_HTML, "Access denied");
                }
                return this.processPerf(uri, header, parms);
            }
            if (uri.startsWith("/deploy")) {
                return this.processDeploy(uri, header);
            }
            if (uri.equals("/indi") || uri.equals("/indi/")) {
                int value;
                String username = header.getProperty(USER);
                if (username != null && (value = UserManager.getInstance().getRights(1000, username)) < 1) {
                    return new Response(HTTP_FORBIDDEN, MIME_HTML, "Access denied");
                }
                return this.processIndi(uri, header, parms);
            }
        }
        return this.serveFile(uri, header, new File("."), false);
    }

    private Response processIndi(String uriStr, Properties header, Map params) {
        String m;
        String htmlTemplate = this.loadTemplate("indi.html", "no data");
        List<SEventFwd> col = ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveIndications(false);
        EventIterator it = null;
        String username = header.getProperty(USER);
        if (username == null) {
            it = col.iterator();
        } else {
            Iterator<SEventFwd> itOrig = col.iterator();
            it = new EventIterator(itOrig, ServerEngine.getInstance().getForwardManager(), username);
        }
        StringBuffer sb = new StringBuffer();
        int max = 2000;
        boolean m_unkn = true;
        boolean m_norm = true;
        boolean m_warn = true;
        boolean m_mino = true;
        boolean m_majo = true;
        boolean m_crit = true;
        if (params.containsKey(INDI_LIMIT)) {
            m = (String)params.get(INDI_LIMIT);
            try {
                max = Integer.parseInt(m);
                if (max == 0) {
                    max = Integer.MAX_VALUE;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        m_norm = params.containsKey(SEV_NORMAL) ? (m = (String)params.get(SEV_NORMAL)).equalsIgnoreCase("true") : false;
        m_unkn = params.containsKey(SEV_UNKNOWN) ? (m = (String)params.get(SEV_UNKNOWN)).equalsIgnoreCase("true") : false;
        m_warn = params.containsKey(SEV_WARNING) ? (m = (String)params.get(SEV_WARNING)).equalsIgnoreCase("true") : false;
        m_mino = params.containsKey(SEV_MINOR) ? (m = (String)params.get(SEV_MINOR)).equalsIgnoreCase("true") : false;
        m_majo = params.containsKey(SEV_MAJOR) ? (m = (String)params.get(SEV_MAJOR)).equalsIgnoreCase("true") : false;
        m_crit = params.containsKey(SEV_CRITICAL) ? (m = (String)params.get(SEV_CRITICAL)).equalsIgnoreCase("true") : false;
        String agentID = null;
        if (params.containsKey("AGENTID")) {
            agentID = (String)params.get("AGENTID");
        } else if (params.containsKey("BOOMAGENTID")) {
            agentID = (String)params.get("BOOMAGENTID");
        }
        int count = 0;
        if (it != null) {
            while (it.hasNext()) {
                SEventFwd ie = (SEventFwd)it.next();
                if (agentID != null && !agentID.equals(ie.getT1()) || '-' != ie.getState()) continue;
                int severityInt = ie.getSeverityInt();
                if (severityInt < 0) {
                    severityInt += 6;
                }
                if (!(severityInt == 5 && m_crit || severityInt == 4 && m_majo || severityInt == 3 && m_mino || severityInt == 2 && m_warn || severityInt == 1 && m_norm) && (severityInt != 0 || !m_unkn)) continue;
                sb.append(this.eventToHTML(ie));
                if (++count < max) continue;
                break;
            }
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(ACTIVE_INDICATIONS, sb.toString());
        p.put(INDI_LIMIT, "" + max);
        p.put(SEV_CRITICAL, "true");
        p.put(SEV_MAJOR, "true");
        p.put(SEV_MINOR, "true");
        p.put(SEV_WARNING, "true");
        p.put(SEV_NORMAL, "true");
        p.put(SEV_UNKNOWN, "true");
        if (m_unkn) {
            p.put("sev_unknown_checked", "checked=\"checked\"");
        } else {
            p.put("sev_unknown_checked", "");
        }
        if (m_norm) {
            p.put("sev_normal_checked", "checked=\"checked\"");
        } else {
            p.put("sev_normal_checked", "");
        }
        if (m_warn) {
            p.put("sev_warning_checked", "checked=\"checked\"");
        } else {
            p.put("sev_warning_checked", "");
        }
        if (m_mino) {
            p.put("sev_minor_checked", "checked=\"checked\"");
        } else {
            p.put("sev_minor_checked", "");
        }
        if (m_majo) {
            p.put("sev_major_checked", "checked=\"checked\"");
        } else {
            p.put("sev_major_checked", "");
        }
        if (m_crit) {
            p.put("sev_critical_checked", "checked=\"checked\"");
        } else {
            p.put("sev_critical_checked", "");
        }
        htmlTemplate = this.replaceAll(htmlTemplate, p);
        return new Response(HTTP_OK, MIME_HTML, htmlTemplate);
    }

    private String eventToHTML(SEventFwd ie) {
        StringBuffer sb = new StringBuffer();
        String color = "#FFFFFF";
        switch (ie.getSeverityInt()) {
            case -1: 
            case 5: {
                color = "f0aaaa";
                break;
            }
            case -2: 
            case 4: {
                color = "f0c0a0";
                break;
            }
            case -3: 
            case 3: {
                color = "f0f0bb";
                break;
            }
            case -4: 
            case 2: {
                color = "aaaaf0";
                break;
            }
            case -5: 
            case 1: {
                color = "aaf0aa";
                break;
            }
        }
        sb.append("<tr BGCOLOR=\"").append(color).append("\">");
        sb.append("<td>").append("<img src=/srv/html/" + ie.getSeverity() + ".png>").append("</td>");
        sb.append("<td>").append(ie.getDuplicates()).append("</td>");
        sb.append("<td>").append(BM.m_sdf.format(new Date(ie.getTime()))).append("</td>");
        sb.append("<td>").append(ie.getNode()).append("</td>");
        sb.append("<td>").append(ie.getApplication()).append("</td>");
        sb.append("<td>").append(ie.getGroup()).append("</td>");
        sb.append("<td>").append(ie.getObject()).append("</td>");
        sb.append("<td>").append(ie.getText()).append("</td>");
        if (ie.getTypeA() > 0) {
            sb.append("<td>").append('+').append("</td>");
        } else {
            sb.append("<td>").append('-').append("</td>");
        }
        if (ie.getTypeK() > 0) {
            sb.append("<td>").append('+').append("</td>");
        } else {
            sb.append("<td>").append('-').append("</td>");
        }
        sb.append("<td>").append(ie.getAgentNode()).append("</td>");
        sb.append("<td>").append(BM.m_sdf.format(new Date(ie.getSTime()))).append("</td>");
        sb.append("</tr>");
        return sb.toString();
    }

    private Response processDeploy(String uriStr, Properties header) {
        if (uriStr.equalsIgnoreCase("/deploy") || uriStr.equalsIgnoreCase("/deploy/")) {
            String deploy_root = "srv/deploy";
            File srv_deploy = new File(deploy_root);
            if (!srv_deploy.exists()) {
                return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "Deployment data not found");
            }
            File agentRoot = new File(srv_deploy, "agent");
            if (!agentRoot.exists()) {
                return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "Agents were not found.");
            }
            StringBuffer responseBuffer = new StringBuffer();
            File[] files = agentRoot.listFiles();
            Arrays.sort(files, new Comparator<File>(this){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            boolean isAgentJarExist = false;
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                if (files[i].isDirectory()) {
                    responseBuffer.append("<li><a href=\"/deploy/agent/").append(name).append("_").append(BM.PRODUCT_lowercase).append("_agent.zip\">").append(name).append("</a>\n");
                    continue;
                }
                if (!name.endsWith("_agent.jar")) continue;
                isAgentJarExist = true;
            }
            if (!isAgentJarExist) {
                return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "Agent jar file was deleted from the server.");
            }
            m_global.put(AGENTS_LIST, responseBuffer.toString());
            this.ui2html(srv_deploy);
            this.pkg2html(srv_deploy);
            String htmlTemplate = this.loadTemplate("deploy.html", "no data");
            String response = this.replaceAll(htmlTemplate, m_global);
            return new Response(HTTP_OK, MIME_HTML, response);
        }
        if (uriStr.startsWith("/deploy/agent/") && uriStr.endsWith(".zip")) {
            try {
                String deploy_root = "srv/deploy";
                File srv_deploy = new File(deploy_root);
                if (!srv_deploy.exists()) {
                    return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "Deploy directory not found.");
                }
                File agentRoot = new File(srv_deploy, "agent");
                if (FilePathTraversalCheck.isPathTraversal(Paths.get("srv/deploy/agent/", new String[0]), agentRoot)) {
                    return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "Access Denied.");
                }
                if (!agentRoot.exists()) {
                    return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "Agents were not found.");
                }
                String dir_name = uriStr.replace("/deploy/agent/", "");
                File platform_dir = new File(agentRoot, dir_name = dir_name.replace("_" + BM.PRODUCT_lowercase + "_agent.zip", ""));
                if (!platform_dir.exists()) {
                    RTLogger.print(1, "HTTP can't find directory /deploy/agent/" + dir_name);
                    return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "File not found.");
                }
                File agentTrustStore = new File(agentRoot, "truststore.p12");
                File agentCONF = new File(agentRoot, "agent.conf");
                NanoHTTPD.updateAgentConf(agentCONF);
                File agentJAR = new File(agentRoot, BM.PRODUCT_lowercase + "_agent.jar");
                if (!agentJAR.exists()) {
                    RTLogger.print(1, "HTTP can't find file: /deploy/agent/" + BM.PRODUCT_lowercase + "_agent.jar");
                    return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, BM.PRODUCT_lowercase + "_agent.jar not found.");
                }
                String sourcePath = "srv/deploy/agent/" + dir_name;
                String resultFile = dir_name + "_" + BM.PRODUCT_lowercase + "_agent.zip";
                ZIP zip = new ZIP();
                long time = System.currentTimeMillis();
                String targetZipPath = "srv/deploy/agent/" + resultFile + time;
                zip.zipAgent(sourcePath, targetZipPath, agentJAR, agentCONF, agentTrustStore);
                Response response = this.serveFile("/srv/deploy/agent/" + resultFile + time, header, new File("."), false);
                response.toDeleteAfterProcessing = new File(targetZipPath);
                return response;
            }
            catch (Throwable e) {
                RTLogger.print(2, "HTTP 500 " + e.getMessage());
                return new Response(HTTP_INTERNALERROR, MIME_PLAINTEXT, "Server failed to process request");
            }
        }
        if (uriStr.startsWith("/deploy/ui/")) {
            String filename = uriStr.replace("/deploy/ui/", "srv/deploy/ui/");
            if (FilePathTraversalCheck.isPathTraversal(Paths.get("srv/deploy/ui/", new String[0]), filename)) {
                return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "Access Denied.");
            }
            File guiFile = new File(filename);
            if (!guiFile.exists()) {
                return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "File not found.");
            }
            return this.serveFile("/" + filename, header, new File("."), false);
        }
        if (uriStr.startsWith("/deploy/pkg/")) {
            String filename = uriStr.replace("/deploy/pkg/", "srv/deploy/pkg/");
            if (FilePathTraversalCheck.isPathTraversal(Paths.get("srv/deploy/pkg/", new String[0]), filename)) {
                return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "Access Denied.");
            }
            File guiFile = new File(filename);
            if (!guiFile.exists()) {
                return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "File not found.");
            }
            return this.serveFile("/" + filename, header, new File("."), false);
        }
        return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "File not found.");
    }

    public static synchronized String generateStaticAgents() {
        StringBuffer sb = new StringBuffer();
        File agent_dir = new File("srv/deploy/agent");
        File agentTrustStore = new File(agent_dir, "truststore.p12");
        File agentCONF = new File(agent_dir, "agent.conf");
        try {
            NanoHTTPD.updateAgentConf(agentCONF);
        }
        catch (Throwable e1) {
            sb.append("Error: updating agent.conf file\n");
            return sb.toString();
        }
        File pkg = new File("srv/deploy/pkg/");
        if (!pkg.exists()) {
            pkg.mkdirs();
        }
        File[] listAgentFolders = agent_dir.listFiles();
        Arrays.sort(listAgentFolders, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (int i = 0; i < listAgentFolders.length; ++i) {
            try {
                File dir = listAgentFolders[i];
                if (!dir.isDirectory()) continue;
                File agentJAR = new File(agent_dir, BM.PRODUCT_lowercase + "_agent.jar");
                if (!agentJAR.exists()) {
                    RTLogger.print(1, "HTTP can't find file: srv/deploy/agent/" + BM.PRODUCT_lowercase + "_agent.jar");
                    sb.append("Error: can't find file: srv/deploy/agent/" + BM.PRODUCT_lowercase + "_agent.jar\n");
                    break;
                }
                String sourcePath = dir.getCanonicalPath();
                String resultFile = dir.getName() + "_" + BM.PRODUCT_lowercase + "_agent.zip";
                ZIP zip = new ZIP();
                String targetZipPath = "srv/deploy/pkg/" + resultFile;
                zip.zipAgent(sourcePath, targetZipPath, agentJAR, agentCONF, agentTrustStore);
                sb.append("zipped ").append(resultFile).append('\n');
                continue;
            }
            catch (Throwable e) {
                RTLogger.print(1, "Error creating static package.", e);
            }
        }
        return sb.toString();
    }

    public static synchronized void updateAgentConf(File agentCONF) throws IOException {
        String agtid;
        String agtPort;
        String srvPort;
        String clusterIP;
        String clusterName;
        String commType;
        String srvIP;
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(agentCONF);){
            props.load(fis);
        }
        ServerProperties serverProps = ServerEngine.getInstance().getServerProps();
        boolean needsToSave = false;
        String srvName = props.getProperty("MAIN_SERVER_NAME");
        if (srvName == null || !srvName.equals(serverProps.getHostname())) {
            props.setProperty("MAIN_SERVER_NAME", serverProps.getHostname());
            needsToSave = true;
        }
        if ((srvIP = props.getProperty("MAIN_SERVER_IP")) == null || !srvIP.equals(serverProps.getIP())) {
            props.setProperty("MAIN_SERVER_IP", serverProps.getIP());
            needsToSave = true;
        }
        if ((commType = props.getProperty("COMM_TYPE")) == null) {
            props.setProperty("COMM_TYPE", "TLS");
            needsToSave = true;
        }
        if (!((clusterName = serverProps.getClusterName()) == null || clusterName.isEmpty() || srvName != null && srvName.equals(clusterName))) {
            props.setProperty("MAIN_SERVER_NAME", clusterName);
            needsToSave = true;
        }
        if (!((clusterIP = serverProps.getClusterIP()) == null || clusterIP.isEmpty() || srvIP != null && srvIP.equals(clusterIP))) {
            props.setProperty("MAIN_SERVER_IP", clusterIP);
            needsToSave = true;
        }
        if (serverProps.getClusterNodes() != null && serverProps.getClusterNodes().length() > 0) {
            props.setProperty("CLUSTER_NODES", serverProps.getClusterNodes());
            needsToSave = true;
        }
        if ((srvPort = props.getProperty("MAIN_SERVER_PORT")) == null || !srvPort.equals("" + serverProps.getServerPort())) {
            props.setProperty("MAIN_SERVER_PORT", "" + serverProps.getServerPort());
            needsToSave = true;
        }
        if ((agtPort = props.getProperty("AGENT_PORT")) == null || !agtPort.equals("" + serverProps.getAgentPort())) {
            props.setProperty("AGENT_PORT", "" + serverProps.getAgentPort());
            needsToSave = true;
        }
        if ((agtid = props.getProperty("AGENT_ID")) != null && agtid.length() > 0) {
            props.setProperty("AGENT_ID", "");
            needsToSave = true;
        }
        if (needsToSave) {
            try (FileOutputStream fos = new FileOutputStream(agentCONF);){
                props.store(fos, "Updated by BOOM Server");
            }
        }
    }

    public void ui2html(File srv_deploy) {
        File uiRoot = new File(srv_deploy, "ui");
        if (!uiRoot.exists()) {
            m_global.put(UI_LIST, "not available");
        } else {
            StringBuffer responseBuffer = new StringBuffer();
            responseBuffer.append("<table border=0>");
            File[] files = uiRoot.listFiles();
            Arrays.sort(files, new Comparator<File>(this){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                if (!files[i].isDirectory()) continue;
                responseBuffer.append("<tr><td>").append(name).append("</td><td>");
                File[] listFiles = files[i].listFiles();
                Arrays.sort(listFiles, new Comparator<File>(this){

                    @Override
                    public int compare(File o1, File o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (int j = 0; j < listFiles.length; ++j) {
                    String nameF = listFiles[j].getName();
                    if (!listFiles[j].isFile()) continue;
                    if (j > 0) {
                        responseBuffer.append("</td></tr><tr><td></td><td>");
                    }
                    responseBuffer.append("&nbsp;&nbsp;&nbsp;<a href=\"/deploy/ui/" + name + "/").append(nameF).append("\">").append(nameF).append("</a>");
                }
                responseBuffer.append("</td></tr>");
            }
            responseBuffer.append("</table>");
            m_global.put(UI_LIST, responseBuffer.toString());
        }
    }

    public void pkg2html(File srv_deploy) {
        File uiRoot = new File(srv_deploy, "pkg");
        if (!uiRoot.exists()) {
            m_global.put(PKG_LIST, "not available");
        } else {
            StringBuffer responseBuffer = new StringBuffer();
            responseBuffer.append("<table border=0>");
            File[] files = uiRoot.listFiles();
            Arrays.sort(files, new Comparator<File>(this){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                if (files[i].isDirectory()) continue;
                responseBuffer.append("<tr><td>");
                responseBuffer.append("&nbsp;&nbsp;&nbsp;<a href=\"/deploy/pkg/").append(name).append("\">").append(name).append("</a>");
                responseBuffer.append("</td></tr>");
            }
            responseBuffer.append("</table>");
            m_global.put(PKG_LIST, responseBuffer.toString());
        }
    }

    private Response processPerf(String uriStr, Properties header, Map params) {
        PerfManager pm;
        File res;
        Object response = "Request failed";
        if (params == null || params.size() == 0) {
            PerfManager pm2 = new PerfManager();
            response = "<html><head><STYLE TYPE=\"text/css\"><!-- TD{font-family: Arial; font-size: 8pt;} ---></STYLE></head><body><small>";
            String html = "";
            try {
                html = pm2.getClassesListHTML();
            }
            catch (Throwable e) {
                RTLogger.print(3, "", e);
            }
            response = (String)response + html;
            response = (String)response + "</small></body></html>";
            return new Response(HTTP_OK, MIME_HTML, (String)response);
        }
        if (params.size() == 1 && params.containsKey("class")) {
            PerfManager pm3 = new PerfManager();
            response = pm3.getClassHTML_v2("&", (String)params.get("class"));
            return new Response(HTTP_OK, MIME_HTML, (String)response);
        }
        String table = (String)params.get("class");
        String field = (String)params.get("field");
        String from = (String)params.get("from");
        String to = (String)params.get("to");
        long l_from = 0L;
        long l_to = System.currentTimeMillis();
        long interval = 604800000L;
        String intervalStr = (String)params.get("interval");
        if (from == null || to == null) {
            try {
                interval = Long.parseLong(intervalStr);
                l_to = System.currentTimeMillis();
                l_from = System.currentTimeMillis() - interval;
            }
            catch (NumberFormatException e) {
                return new Response(HTTP_INTERNALERROR, MIME_HTML, "Invalid interval");
            }
        }
        try {
            l_from = BM.m_sdf.parse(from).getTime();
            l_to = BM.m_sdf.parse(to).getTime();
        }
        catch (ParseException e) {
            l_from = -1L;
            l_to = -1L;
            return new Response(HTTP_INTERNALERROR, MIME_HTML, "Invalid date format");
        }
        if (table == null || field == null) {
            return new Response(HTTP_INTERNALERROR, MIME_HTML, (String)response);
        }
        params.remove("class");
        params.remove("field");
        params.remove("interval");
        Object exludes = params.remove("excludes");
        LinkedList<String> excludeKeys = new LinkedList<String>();
        if (exludes != null) {
            if (exludes instanceof String) {
                String value = (String)exludes;
                excludeKeys.add(value);
            } else if (exludes instanceof List) {
                excludeKeys = (List)exludes;
            }
        }
        if ((res = (pm = new PerfManager()).getChart(table, field, l_from, l_to, params, excludeKeys)) != null) {
            Response r = this.serveFile("/srv/html/perf/" + res.getName(), header, new File("."), false);
            r.toDeleteAfterProcessing = res;
            return r;
        }
        response = "Error generating Chart";
        return new Response(HTTP_INTERNALERROR, MIME_HTML, (String)response);
    }

    public String loadTemplate(String templateName, String defaultKey) {
        Object html = "";
        File template = new File(ServerEngine.getInstance().getMainDir() + File.separator + "srv" + File.separator + "html" + File.separator + templateName);
        if (template.exists()) {
            try (FileInputStream fis = new FileInputStream(template);){
                byte[] h = new byte[fis.available()];
                fis.read(h);
                html = new String(h);
            }
            catch (Throwable e) {
                RTLogger.print(3, "Can't read template: " + templateName, e);
            }
        } else {
            html = "<html><body>" + defaultKey + "</body></html>";
        }
        return html;
    }

    public String replaceAll(String htmlTemplate, Map<String, String> params) {
        for (String name : params.keySet()) {
            htmlTemplate = htmlTemplate.replace("[" + name + "]", params.get(name));
        }
        return htmlTemplate;
    }

    private String encodeUri(String uri) {
        Object newUri = "";
        StringTokenizer st = new StringTokenizer(uri, "/ ", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("/")) {
                newUri = (String)newUri + "/";
                continue;
            }
            if (tok.equals(" ")) {
                newUri = (String)newUri + "%20";
                continue;
            }
            newUri = (String)newUri + URLEncoder.encode(tok);
        }
        return newUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response serveFile(String uri, Properties header, File homeDir, boolean allowDirectoryListing) {
        if (((String)uri).indexOf("srv/html/activeMsgPie.png") != -1 || ((String)uri).indexOf("srv/html/acknMsgPie.png") != -1 || ((String)uri).indexOf("srv/html/auto_op_ackn.png") != -1 || ((String)uri).indexOf("srv/html/hostsInd.png") != -1 || ((String)uri).indexOf("srv/html/indActivity1d.png") != -1 || ((String)uri).indexOf("srv/html/indActivity7d.png") != -1 || ((String)uri).indexOf("srv/html/indBarActivity7d.png") != -1) {
            // empty if block
        }
        if (!homeDir.isDirectory()) {
            return new Response(HTTP_INTERNALERROR, MIME_PLAINTEXT, "INTERNAL ERRROR: serveFile(): given homeDir is not a directory.");
        }
        if (((String)(uri = ((String)uri).trim().replace(File.separatorChar, '/'))).indexOf(63) >= 0) {
            uri = ((String)uri).substring(0, ((String)uri).indexOf(63));
        }
        if (((String)uri).startsWith("..") || ((String)uri).endsWith("..") || ((String)uri).indexOf("../") >= 0) {
            return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: Won't serve ../ for security reasons.");
        }
        File f = new File(homeDir, (String)uri);
        if (!f.exists()) {
            return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "Error 404, file not found.");
        }
        if (f.isDirectory()) {
            if (!((String)uri).endsWith("/")) {
                uri = (String)uri + "/";
                Response r = new Response(HTTP_REDIRECT, MIME_HTML, "<html><body>Redirected: <a href=\"" + (String)uri + "\">" + (String)uri + "</a></body></html>");
                r.addHeader("Location", (String)uri);
                return r;
            }
            if (new File(f, "index.html").exists()) {
                f = new File(homeDir, (String)uri + "/index.html");
            } else if (new File(f, "index.htm").exists()) {
                f = new File(homeDir, (String)uri + "/index.htm");
            } else {
                if (allowDirectoryListing) {
                    String u;
                    int slash;
                    String[] files = f.list();
                    String msg = "<html><body><h1>Directory " + (String)uri + "</h1><br/>";
                    if (((String)uri).length() > 1 && (slash = (u = ((String)uri).substring(0, ((String)uri).length() - 1)).lastIndexOf(47)) >= 0 && slash < u.length()) {
                        msg = msg + "<b><a href=\"" + ((String)uri).substring(0, slash + 1) + "\">..</a></b><br/>";
                    }
                    for (int i = 0; i < files.length; ++i) {
                        File curFile = new File(f, files[i]);
                        boolean dir = curFile.isDirectory();
                        if (dir) {
                            msg = msg + "<b>";
                            int n = i;
                            files[n] = files[n] + "/";
                        }
                        msg = msg + "<a href=\"" + this.encodeUri((String)uri + files[i]) + "\">" + files[i] + "</a>";
                        if (curFile.isFile()) {
                            long len = curFile.length();
                            msg = msg + " &nbsp;<font size=2>(";
                            msg = len < 1024L ? msg + curFile.length() + " bytes" : (len < 0x100000L ? msg + curFile.length() / 1024L + "." + curFile.length() % 1024L / 10L % 100L + " KB" : msg + curFile.length() / 0x100000L + "." + curFile.length() % 0x100000L / 10L % 100L + " MB");
                            msg = msg + ")</font>";
                        }
                        msg = msg + "<br/>";
                        if (!dir) continue;
                        msg = msg + "</b>";
                    }
                    return new Response(HTTP_OK, MIME_HTML, msg);
                }
                return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: No directory listing.");
            }
        }
        FileInputStream fis = null;
        try {
            String mime = null;
            int dot = f.getCanonicalPath().lastIndexOf(46);
            if (dot >= 0) {
                mime = theMimeTypes.get(f.getCanonicalPath().substring(dot + 1).toLowerCase());
            }
            if (mime == null) {
                mime = MIME_DEFAULT_BINARY;
            }
            long startFrom = 0L;
            String range = header.getProperty("Range");
            if (range != null && range.startsWith("bytes=")) {
                int minus = (range = range.substring("bytes=".length())).indexOf(45);
                if (minus > 0) {
                    range = range.substring(0, minus);
                }
                try {
                    startFrom = Long.parseLong(range);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            fis = new FileInputStream(f);
            long skipped = fis.skip(startFrom);
            Response r = new Response(HTTP_OK, mime, fis);
            r.addHeader("Content-length", "" + (f.length() - skipped));
            r.addHeader("Content-range", skipped + "-" + (f.length() - 1L) + "/" + f.length());
            Response response = r;
            return response;
        }
        catch (IOException ioe) {
            Response response = new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: Reading file failed.");
            return response;
        }
    }

    static {
        StringTokenizer st = new StringTokenizer("htm\t\ttext/html html\t\ttext/html txt\t\ttext/plain asc\t\ttext/plain gif\t\timage/gif jpg\t\timage/jpeg jpeg\t\timage/jpeg png\t\timage/png mp3\t\taudio/mpeg m3u\t\taudio/mpeg-url pdf\t\tapplication/pdf doc\t\tapplication/msword ogg\t\tapplication/x-ogg zip\t\tapplication/octet-stream exe\t\tapplication/octet-stream class\t\tapplication/octet-stream ");
        while (st.hasMoreTokens()) {
            theMimeTypes.put(st.nextToken(), st.nextToken());
        }
    }
}

