/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.perf;

import com.blixx.sa.perf.DDFField;
import com.blixx.sa.perf.DDFTable;
import com.blixx.server.ServerEngine;
import com.blixx.server.db.DB;
import com.blixx.shared.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;

public class PerfSubmitter {
    File ignoreFile = new File("srv/etc/ignorePerfClasses.dat");
    private ConcurrentSkipListSet<String> m_ignorePerfClasses = new ConcurrentSkipListSet();

    public PerfSubmitter() {
        try {
            if (!this.ignoreFile.exists()) {
                this.ignoreFile.createNewFile();
            } else {
                this.reloadIgnorePerfClasses();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reloadIgnorePerfClasses() throws IOException {
        List<String> classes = FileUtils.readFileAsList(this.ignoreFile);
        this._setIgnorePerfClasses(classes);
    }

    private void _setIgnorePerfClasses(List<String> perfClassNames) {
        this.m_ignorePerfClasses.addAll(perfClassNames);
        this.m_ignorePerfClasses.retainAll(perfClassNames);
    }

    public void setIgnorePerfClasses(List<String> perfClassNames) {
        Collections.sort(perfClassNames);
        try {
            FileUtils.writeFileAsList(this.ignoreFile, perfClassNames);
            this._setIgnorePerfClasses(perfClassNames);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addIgnorePerfClass(String className) {
        this.m_ignorePerfClasses.add(className);
    }

    public void removeIgnorePerfClass(String className) {
        this.m_ignorePerfClasses.remove(className);
    }

    public void clearIgnorePerfClasses() {
        this.m_ignorePerfClasses.clear();
    }

    public boolean isPerfClassIgnored(String className) {
        return this.m_ignorePerfClasses.contains(className);
    }

    public ConcurrentSkipListSet<String> getPerfClassesIgnored() {
        return this.m_ignorePerfClasses;
    }

    public void submitValues(long time, String fields, String className, String[] values) {
        if (!this.m_ignorePerfClasses.contains(className)) {
            DB db = ServerEngine.getInstance().getDB();
            className = ((String)className).toUpperCase();
            className = db.m_isOraclePERF ? "\"" + (String)className + "\"" : "`" + (String)className + "`";
            try {
                db.insertPerfData(time, fields, db.getPerfDBname(), (String)className, values);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static String getAlterTableSQL(String fieldSubmitted, String className, boolean isOracle, List<DDFField> existingFields) {
        String fieldsNorm = DDFTable.normalizeFields(fieldSubmitted, isOracle);
        String[] arr = fieldsNorm.split(",");
        StringBuffer alter = new StringBuffer();
        alter.append("ALTER TABLE ").append(ServerEngine.getInstance().getDB().getPerfDBname()).append('.');
        if (!(className.length() != 0 && className.charAt(0) == '\"' || className.length() != 0 && className.charAt(0) == '`')) {
            if (isOracle) {
                alter.append('\"').append(className).append("\" ");
            } else {
                alter.append('`').append(className).append("` ");
            }
        } else {
            alter.append(className).append(' ');
        }
        if (existingFields == null) {
            throw new RuntimeException("Alter table failed. No existing fields found.");
        }
        boolean isFirst = true;
        for (int i = 0; i < arr.length; ++i) {
            String submittedField = arr[i].trim().split("\\s+")[0];
            if (existingFields.contains(new DDFField(submittedField, 0))) continue;
            if (!isOracle) {
                if (isFirst) {
                    isFirst = false;
                    alter.append("ADD ").append(arr[i]);
                    continue;
                }
                alter.append(", ADD ").append(arr[i]);
                continue;
            }
            if (isFirst) {
                isFirst = false;
                alter.append("ADD (").append(arr[i]);
                continue;
            }
            alter.append(", ").append(arr[i]);
        }
        if (isOracle) {
            alter.append(')');
        }
        return alter.toString();
    }

    public static String getCreateTableSQL(String fieldSubmitted, String className, boolean isOracle) {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("CREATE TABLE ").append(ServerEngine.getInstance().getDB().getPerfDBname()).append('.');
        if (!(className.length() != 0 && className.charAt(0) == '\"' || className.length() != 0 && className.charAt(0) == '`')) {
            if (isOracle) {
                sbSql.append('\"').append(className).append("\" (");
            } else {
                sbSql.append('`').append(className).append("` (");
            }
        } else {
            sbSql.append(className).append(" (");
        }
        fieldSubmitted = DDFTable.normalizeFields(fieldSubmitted, isOracle);
        sbSql.append(fieldSubmitted);
        sbSql.append(')');
        if (!isOracle) {
            sbSql.append(" DEFAULT CHARSET=utf8");
        }
        return sbSql.toString();
    }
}

