/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.services;

import com.blixx.server.AgentCard;
import com.blixx.server.NodeGroupRepository;
import com.blixx.server.ServerEngine;
import com.blixx.server.services.ServiceDashBoard;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.Severity;
import com.blixx.shared.utils.EventStorageUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EventFilter {
    public static final int START_WITH = 1;
    public static final int ENDS_WITH = 2;
    public static final int CONTAINS = 3;
    public static final int EXACTLY = 4;
    public static final int BIGGER = 5;
    public static final int LESS = 6;
    public static final String COL_CA_NAME = "CA name";
    public static final String COL_CA_VALUE = "CA value";
    public static final String COL_NODE_GROUP = "Node group";
    public static final String COL_NODE_GROUP_EXT = "Node group [Hosts]";
    public static final int COL_CA_NAME_INT = 100;
    public static final int COL_CA_VALUE_INT = 101;
    public static final int COL_NODE_GROUP_INT = 102;
    public static final String COL_SERVICEDASHBOARD = "ServiceD";
    public static final int COL_SERVICEDASHBOARD_INT = 103;
    public static final int COL_NODE_GROUP_EXT_INT = 104;
    public String m_column = null;
    public int m_columnInt = -1;
    public String m_pattern = null;
    Pattern m_filter = null;
    public int m_mode = 0;
    public boolean m_caseSensitive = true;
    public boolean m_isNOT = false;
    public double m_doubleVal = 0.0;
    public int m_filtered = 0;
    public boolean m_isLocked = false;
    public int m_Availability = 0;
    public int m_KPIs = 0;
    public boolean m_isActive = true;
    private String m_label = null;
    public static final String COL_TIME_PLUSDUPLICATE = "TimePlusDuplicates";
    public static final String OWNED_ME = "Me";
    public static final String OWNED_ME_NOBODY = "Me+Nobody";
    public static final String OWNED_NOBODY = "Nobody";
    public static final String OWNED_OTHER = "Other";
    public ServiceDashBoard m_serviceDashboard = null;
    static Map<String, String> m_dbnames = new HashMap<String, String>();

    protected EventFilter() {
    }

    public EventFilter(ServiceDashBoard sdb) {
        this.m_serviceDashboard = sdb;
        this.m_columnInt = 103;
        this.m_column = COL_SERVICEDASHBOARD;
        this.m_label = "Service: " + sdb.getName();
        this.m_pattern = sdb.getID();
    }

    public EventFilter(String label, String columnName, String pattern, boolean caseSensitive, int mode, boolean isLocked, int typeA, int typeK) {
        this.m_label = label == null ? "" : label.trim();
        this.m_Availability = typeA;
        this.m_KPIs = typeK;
        this.m_isLocked = isLocked;
        this.m_caseSensitive = caseSensitive;
        try {
            this.m_column = columnName;
            if (this.m_column.equals(COL_SERVICEDASHBOARD)) {
                this.m_columnInt = 103;
            } else if (this.m_column.equals(COL_CA_NAME)) {
                this.m_columnInt = 100;
            } else if (this.m_column.equals(COL_CA_VALUE)) {
                this.m_columnInt = 101;
            } else if (this.m_column.equals(COL_NODE_GROUP)) {
                this.m_columnInt = 102;
                pattern = pattern.replace("/root/_Groups/", "");
            } else if (this.m_column.equals(COL_NODE_GROUP_EXT)) {
                this.m_columnInt = 104;
                pattern = pattern.replace("/root/_Groups/", "");
            } else if (this.m_column.equals(COL_TIME_PLUSDUPLICATE)) {
                this.m_columnInt = EventStorageUtils.getColumnID("Time");
            } else {
                this.m_columnInt = EventStorageUtils.getColumnID(columnName);
                if (this.m_columnInt == 0) {
                    try {
                        pattern = Severity.getSeverity(Severity.getSeverity(pattern));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (this.m_columnInt == -1) {
                this.m_filter = Pattern.compile(".*", 40);
                return;
            }
            Object patternToCompile = ".*";
            this.m_mode = mode;
            this.m_pattern = pattern;
            if (this.m_columnInt == 102 || this.m_columnInt == 104) {
                if (pattern.indexOf(124) == -1) {
                    patternToCompile = this.getPatternToCompileNodeGroup(pattern, mode);
                } else {
                    String[] spl = pattern.split("\\Q|\\E");
                    for (int i = 0; i < spl.length; ++i) {
                        patternToCompile = (String)patternToCompile + this.getPatternToCompileNodeGroup(spl[i], mode);
                        if (i >= spl.length - 1) continue;
                        patternToCompile = (String)patternToCompile + "|";
                    }
                }
            } else if (pattern.indexOf(124) == -1) {
                patternToCompile = this.m_columnInt == 101 ? this.getPatternToCompileCAValue(pattern, mode) : this.getPatternToCompile(pattern, mode);
            } else {
                patternToCompile = "";
                String[] spl = pattern.split("\\Q|\\E");
                for (int i = 0; i < spl.length; ++i) {
                    patternToCompile = this.m_columnInt == 101 ? (String)patternToCompile + this.getPatternToCompileCAValue(spl[i], mode) : (String)patternToCompile + this.getPatternToCompile(spl[i], mode);
                    if (i >= spl.length - 1) continue;
                    patternToCompile = (String)patternToCompile + "|";
                }
            }
            this.m_filter = caseSensitive ? Pattern.compile((String)patternToCompile, 40) : Pattern.compile((String)patternToCompile, 42);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private String getPatternToCompile(String pattern, int mode) throws ParseException {
        Object patternToCompile = ".*";
        switch (mode) {
            case 1: {
                patternToCompile = "(?:^\\Q" + pattern + "\\E.*)";
                break;
            }
            case 2: {
                patternToCompile = "(?:.*\\Q" + pattern + "\\E$)";
                break;
            }
            case 3: {
                patternToCompile = "(?:.*\\Q" + pattern + "\\E.*)";
                break;
            }
            case 4: {
                patternToCompile = "(?:\\Q" + pattern + "\\E)";
                break;
            }
            case 5: 
            case 6: {
                if (this.m_column.equals("Time") || this.m_column.equals("SrvTime") || this.m_column.equals(COL_TIME_PLUSDUPLICATE)) {
                    SimpleDateFormat m_sdf_milliSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                    Date date = m_sdf_milliSec.parse(pattern);
                    this.m_doubleVal = date.getTime();
                    break;
                }
                this.m_doubleVal = Double.parseDouble(pattern);
                break;
            }
        }
        return patternToCompile;
    }

    private String getPatternToCompileCAValue(String pattern, int mode) throws ParseException {
        Object patternToCompile = ".*";
        switch (mode) {
            case 1: {
                patternToCompile = "(?:[^=]*=\\Q" + pattern + "\\E.*)";
                break;
            }
            case 2: {
                patternToCompile = "(?:[^=\r\n]*=.*\\Q" + pattern + "\\E$)";
                break;
            }
            case 3: {
                patternToCompile = "(?:[^=]*=\\Q" + pattern + "\\E.*)";
                break;
            }
            case 4: {
                patternToCompile = "(?:[^=]*=\\Q" + pattern + "\\E$)";
                break;
            }
        }
        return patternToCompile;
    }

    private String getPatternToCompileNodeGroup(String pattern, int mode) throws ParseException {
        Object patternToCompile = ".*";
        switch (mode) {
            case 1: {
                if (pattern.endsWith("/")) {
                    pattern = pattern.substring(0, pattern.length() - 1);
                    patternToCompile = "^(?:\\Q" + pattern + "\\E)(|/.*)";
                    break;
                }
                patternToCompile = "^(?:\\Q" + pattern + "\\E).*";
                break;
            }
            case 2: {
                patternToCompile = ".*(?:\\Q" + pattern + "\\E/?)$";
                break;
            }
            case 3: {
                patternToCompile = ".*(?:\\Q" + pattern + "\\E).*";
                break;
            }
            case 4: {
                patternToCompile = "(?:\\Q" + pattern + "\\E/?)(|/)";
                break;
            }
        }
        return patternToCompile;
    }

    public boolean select(SEventFwd e) {
        if (!this.m_isActive) {
            return true;
        }
        if (this.m_columnInt == -1) {
            if (this.m_isNOT) {
                return e.getTypeA() < this.m_Availability || e.getTypeK() < this.m_KPIs;
            }
            return e.getTypeA() >= this.m_Availability && e.getTypeK() >= this.m_KPIs;
        }
        switch (this.m_columnInt) {
            case 103: {
                if (this.m_serviceDashboard == null) {
                    return false;
                }
                this.m_serviceDashboard.processActiveOrClosed(Arrays.asList(e));
                return this.m_serviceDashboard.contains(e);
            }
            case 100: 
            case 101: {
                return this.checkCANameOrValue(e);
            }
            case 102: {
                String agentID = e.getT1();
                if (agentID != null) {
                    List<String> nodeGroups = NodeGroupRepository.getInstance().getNodeGroupPathes(agentID);
                    for (String path : nodeGroups) {
                        if (!this.m_filter.matcher(path).matches()) continue;
                        return true;
                    }
                }
                return false;
            }
            case 104: {
                HashSet<String> agentIDs = new HashSet<String>();
                if (e.getT1() != null && e.getT1().length() > 0) {
                    agentIDs.add(e.getT1());
                }
                for (AgentCard acExt : ServerEngine.getInstance().getAgentRepository().getExternalHosts(e.getNode())) {
                    agentIDs.add(acExt.getAgentID());
                }
                for (String id : agentIDs) {
                    List<String> nodeGroups = NodeGroupRepository.getInstance().getNodeGroupPathes(id);
                    for (String path : nodeGroups) {
                        if (!this.m_filter.matcher(path).matches()) continue;
                        return true;
                    }
                }
                return false;
            }
            case 31: {
                return false;
            }
        }
        return this.checkAttribute(e);
    }

    private boolean checkAttribute(SEventFwd e) {
        if (this.m_mode >= 5) {
            if (this.m_column.equals(COL_TIME_PLUSDUPLICATE)) {
                try {
                    double d1 = e.getFirstTime();
                    double d2 = e.getTime();
                    double d3 = -1.0;
                    if (e instanceof SEventFwd) {
                        d3 = e.getTFA();
                    }
                    boolean isMatch = true;
                    if (this.m_mode == 5) {
                        boolean bl = isMatch = d1 > this.m_doubleVal || d2 > this.m_doubleVal;
                        if (d3 > 0.0) {
                            isMatch = isMatch || d3 > this.m_doubleVal;
                        }
                    } else if (this.m_mode == 6) {
                        boolean bl = isMatch = d1 < this.m_doubleVal || d2 < this.m_doubleVal;
                        if (d3 > 0.0) {
                            boolean bl2 = isMatch = isMatch || d3 < this.m_doubleVal;
                        }
                    }
                    if (this.m_isNOT) {
                        return !isMatch;
                    }
                    return isMatch;
                }
                catch (Throwable e1) {
                    return true;
                }
            }
            try {
                double d = 0.0;
                if (this.m_column.equals("Time")) {
                    d = e.getTime();
                } else if (this.m_column.equals("SrvTime")) {
                    d = e.getSTime();
                } else {
                    String text = EventStorageUtils.getText(e, this.m_columnInt);
                    d = Double.parseDouble(text);
                }
                boolean isMatch = true;
                if (this.m_mode == 5) {
                    isMatch = d > this.m_doubleVal;
                } else if (this.m_mode == 6) {
                    boolean bl = isMatch = d < this.m_doubleVal;
                }
                if (this.m_isNOT) {
                    return !isMatch;
                }
                return isMatch;
            }
            catch (NumberFormatException e1) {
                return true;
            }
        }
        String text = EventStorageUtils.getText(e, this.m_columnInt);
        Matcher m = this.m_filter.matcher(text);
        if (this.m_isNOT) {
            return !m.matches() && e.getTypeA() >= this.m_Availability && e.getTypeK() >= this.m_KPIs;
        }
        return m.matches() && e.getTypeA() >= this.m_Availability && e.getTypeK() >= this.m_KPIs;
    }

    private boolean checkCANameOrValue(SEvent e) {
        if (e instanceof SEventFwd) {
            SEventFwd sef = (SEventFwd)e;
            if (this.m_columnInt == 100) {
                boolean res = false;
                for (String key : sef.m_CustomAttributes.keySet()) {
                    String spl;
                    Matcher m;
                    String name;
                    int EQ;
                    if (!key.startsWith("CA") || (EQ = (name = sef.m_CustomAttributes.get(key)).indexOf(61)) == -1 || !(m = this.m_filter.matcher(spl = name.substring(0, EQ))).matches()) continue;
                    res = true;
                    break;
                }
                if (this.m_isNOT) {
                    res = !res;
                }
                return res && e.getTypeA() >= this.m_Availability && e.getTypeK() >= this.m_KPIs;
            }
            boolean res = false;
            for (Map.Entry<String, String> en : sef.m_CustomAttributes.entrySet()) {
                Matcher m;
                if (!en.getKey().startsWith("CA") || !(m = this.m_filter.matcher(en.getValue())).matches()) continue;
                res = true;
                break;
            }
            if (this.m_isNOT) {
                res = !res;
            }
            return res && e.getTypeA() >= this.m_Availability && e.getTypeK() >= this.m_KPIs;
        }
        return !this.m_isNOT;
    }

    public void setLabel(String label) {
        this.m_label = label;
        if (label == null) {
            this.m_label = "";
        }
    }

    public String getLabel() {
        if (this.m_label == null) {
            this.m_label = "";
        }
        return this.m_label;
    }

    public String getLabelOrName() {
        if (this.m_label == null) {
            this.m_label = "";
        }
        if (this.m_label.length() == 0) {
            return this.toString();
        }
        return this.m_label;
    }

    public String toString() {
        if (this.m_column == null || this.m_column.length() == 0) {
            return "";
        }
        StringBuffer res = new StringBuffer();
        res.append(this.m_column);
        if (this.m_isNOT) {
            res.append(" NOT");
        }
        switch (this.m_mode) {
            case 1: {
                res.append(" STARTS WITH ");
                break;
            }
            case 2: {
                res.append(" ENDS WITH ");
                break;
            }
            case 3: {
                res.append(" CONTAINS ");
                break;
            }
            case 4: {
                res.append(" == ");
                break;
            }
            case 5: {
                res.append(" > ");
                break;
            }
            case 6: {
                res.append(" < ");
                break;
            }
        }
        res.append(this.m_pattern);
        if (this.m_Availability > 0) {
            res.append(" +Availabilty");
        }
        if (this.m_KPIs > 0) {
            res.append(" +KPI");
        }
        if (this.m_caseSensitive) {
            res.append(" +case sensitive");
        }
        return res.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventFilter) {
            return this.toString().equals(String.valueOf(obj));
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static String getSQLWhere(String colName, int mode, String value) {
        StringBuffer sb = new StringBuffer();
        String dbname = m_dbnames.get(colName);
        if (dbname == null) {
            return "";
        }
        switch (mode) {
            case 1: {
                sb.append(dbname).append(" LIKE '").append(value).append("%'");
                break;
            }
            case 2: {
                sb.append(dbname).append(" LIKE '%").append(value).append("'");
                break;
            }
            case 3: {
                sb.append(dbname).append(" LIKE '%").append(value).append("%'");
                break;
            }
            case 4: {
                sb.append(dbname).append(" = '").append(value).append("'");
                break;
            }
        }
        return sb.toString();
    }

    static {
        m_dbnames.put("Application", "EVENTS_A.APPLICATION");
        m_dbnames.put("Group", "EVENTS_A.MSGGRP");
        m_dbnames.put("Object", "EVENTS_A.OBJECT");
        m_dbnames.put("Host", "EVENTS_A.NODE");
        m_dbnames.put("Agent", "EVENTS_A.AGENTNODE");
        m_dbnames.put("Text", "EVENTS_A.MSGTEXT");
    }
}

