/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.services;

import com.blixx.server.services.EventFilterGroup;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.EventsAndStatus;
import com.blixx.shared.ext.IServiceStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceDashBoard
implements Comparable<ServiceDashBoard> {
    protected Map<String, EventFilterGroup> m_filters = new ConcurrentHashMap<String, EventFilterGroup>();
    protected String m_name = null;
    protected String m_id = null;
    protected String m_description = "";

    public ServiceDashBoard(String name, String id, String description, Collection<EventFilterGroup> filters) {
        this.m_name = name;
        this.m_id = id;
        this.m_description = description;
        for (EventFilterGroup efg : filters) {
            this.addFilters(efg);
        }
    }

    public void processActiveOrClosed(Collection<SEventFwd> events) {
        for (SEventFwd sef : events) {
            this.processActiveOrClosed(sef);
        }
    }

    public void removeAllClosed() {
        for (EventFilterGroup next : this.m_filters.values()) {
            next.removeAllClosed();
        }
    }

    public boolean contains(SEventFwd event) {
        for (EventFilterGroup next : this.m_filters.values()) {
            if (!next.contains(event)) continue;
            return true;
        }
        return false;
    }

    public void processActiveOrClosed(SEventFwd sef) {
        if ('-' == sef.getState() && this.contains(sef)) {
            return;
        }
        for (EventFilterGroup next : this.m_filters.values()) {
            if ('-' == sef.getState() && sef.getSeverityInt() >= 0) {
                if (!next.isMatched(sef)) continue;
                next.add(sef);
                break;
            }
            next.remove(sef);
        }
    }

    public int getMaxAV() {
        int severity = 1;
        for (EventFilterGroup next : this.m_filters.values()) {
            severity = Math.max(severity, next.getMaxAV());
        }
        return severity;
    }

    public int getMaxKPI() {
        int severity = 1;
        for (EventFilterGroup next : this.m_filters.values()) {
            severity = Math.max(severity, next.getMaxKPI());
        }
        return severity;
    }

    public int getMaxOther() {
        int severity = 1;
        for (EventFilterGroup next : this.m_filters.values()) {
            severity = Math.max(severity, next.getMaxOther());
        }
        return severity;
    }

    public int getCount(int sev, boolean av, boolean kpi, boolean other) {
        int sum = 0;
        for (EventFilterGroup next : this.m_filters.values()) {
            sum += next.getCount(sev, av, kpi, other);
        }
        return sum;
    }

    public String getID() {
        return this.m_id;
    }

    public String getDescription() {
        return this.m_description;
    }

    protected void addFilters(EventFilterGroup filter) {
        if (filter != null && filter.getName() != null) {
            this.m_filters.put(filter.getName(), filter);
        }
    }

    protected void removeFilters(EventFilterGroup filter) {
        if (filter != null && filter.getName() != null) {
            this.m_filters.remove(filter.getName());
        }
    }

    public IServiceStatus getFilterGroupByName(String name) {
        if (name != null && name.length() > 0 && this.m_filters.containsKey(name)) {
            return this.m_filters.get(name);
        }
        return null;
    }

    public Map<String, EventFilterGroup> getFilters() {
        return this.m_filters;
    }

    public Boolean hasFilterGroup(String name) {
        return this.m_filters.containsKey(name);
    }

    public String getName() {
        return this.m_name;
    }

    public List<EventsAndStatus> getEvents() {
        return new ArrayList<EventsAndStatus>(this.m_filters.values());
    }

    public double getWAvrgAV() {
        int sum = 0;
        double tempWA = 0.0;
        for (EventFilterGroup next : this.m_filters.values()) {
            int mul = next.getCountAV(false, false);
            tempWA += next.getWAverageAV() * (double)mul;
            sum += mul;
        }
        return sum == 0 ? 0.0 : tempWA / (double)sum;
    }

    public double getWAvrgKPI() {
        int sum = 0;
        double tempWA = 0.0;
        for (EventFilterGroup next : this.m_filters.values()) {
            int mul = next.getCountKPI(false, false);
            tempWA += next.getWAverageKPI() * (double)mul;
            sum += mul;
        }
        return sum == 0 ? 0.0 : tempWA / (double)sum;
    }

    public double getWAvrgOther() {
        int sum = 0;
        double tempWA = 0.0;
        for (EventFilterGroup next : this.m_filters.values()) {
            int mul = next.getCountOther(false, false);
            tempWA += next.getWAverageOther() * (double)mul;
            sum += mul;
        }
        return sum == 0 ? 0.0 : tempWA / (double)sum;
    }

    public Map<SEventFwd, SEventFwd> getEventMap() {
        HashMap<SEventFwd, SEventFwd> map = new HashMap<SEventFwd, SEventFwd>();
        for (EventFilterGroup next : this.m_filters.values()) {
            map.putAll(next.getEvents().getEventMap());
        }
        return map;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(String.valueOf(obj));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(ServiceDashBoard o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public boolean isIdenticalByAttributes(ServiceDashBoard sdb) {
        try {
            if (this.getID().equals(sdb.getID()) && this.getName().equals(sdb.getName()) && this.getDescription().equals(sdb.getDescription()) && this.m_filters.size() == sdb.m_filters.size()) {
                for (Map.Entry<String, EventFilterGroup> entry : this.m_filters.entrySet()) {
                    if (sdb.m_filters.containsKey(entry.getKey())) {
                        EventFilterGroup second = sdb.m_filters.get(entry.getKey());
                        if (entry.getValue().equals(second)) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

