/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.services;

import com.blixx.log.RTLogger;
import com.blixx.server.services.EventFilter;
import com.blixx.server.services.EventFilterGroup;
import com.blixx.server.services.ServiceDashBoard;
import com.blixx.shared.SecureDocumentBuilderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceDashboardFactory {
    public static final String ID = "ID";
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String SSD_LIST = "SSD_LIST";
    public static final String SSD = "SSD";
    public static String SSDFILE = "ssd.xml";
    public static String GLOBAL_SSDFILE = "global.ssd.xml";
    public static final String GLOBAL_SSDFILE_SRV_PATH = "srv/services/" + GLOBAL_SSDFILE;
    public static String FILTER_LIST = "FILTER_LIST";
    public static String FILTER = "FILTER";
    public static String FILTER_NAME = "FILTER_NAME";
    public static String LABEL = "LABEL";
    public static String IS_LOCKED = "IS_LOCKED";
    public static String AVAILABILITY = "AVAILABILITY";
    public static String KPI = "KPI";
    public static String COLUMN_NAME = "COLUMN_NAME";
    public static String ISNOT = "ISNOT";
    public static String PATTERN = "PATTERN";
    public static String CASE_SENSITIVE = "CASE_SENSITIVE";
    public static String MODE = "MODE";

    public List<ServiceDashBoard> loadLocalFile(File file) {
        LinkedList<ServiceDashBoard> list = new LinkedList<ServiceDashBoard>();
        if (file.length() == 0L) {
            return list;
        }
        try (FileInputStream fio = new FileInputStream(file);){
            Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fio);
            Element top = doc.getDocumentElement();
            NodeList nl = top.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node item = nl.item(i);
                String node = item.getNodeName();
                if (!node.equals(SSD)) continue;
                ServiceDashBoard efg = this.createServiceObject(item);
                list.add(efg);
            }
        }
        catch (Throwable e) {
            RTLogger.print(1, "Error parsing xml file: " + e.getMessage());
            RTLogger.print(2, "", e);
        }
        return list;
    }

    private ServiceDashBoard createServiceObject(Node item) {
        String name = ((Element)item).getAttribute(NAME);
        String id = ((Element)item).getAttribute(ID);
        String description = ((Element)item).getAttribute(DESCRIPTION);
        if (id == null || id.length() == 0) {
            id = UUID.randomUUID().toString();
        }
        LinkedList<EventFilterGroup> efg_list = new LinkedList<EventFilterGroup>();
        NodeList fl = item.getChildNodes();
        for (int j = 0; j < fl.getLength(); ++j) {
            String fnode = fl.item(j).getNodeName();
            if (!fnode.equals(FILTER_LIST)) continue;
            ArrayList<EventFilter> list = this.processElement((Element)fl.item(j));
            String groupName = ((Element)fl.item(j)).getAttribute(NAME);
            EventFilterGroup group = new EventFilterGroup(groupName);
            group.addFilters(list);
            efg_list.add(group);
        }
        ServiceDashBoard efg = new ServiceDashBoard(name, id, description, efg_list);
        return efg;
    }

    protected ArrayList<EventFilter> processElement(Element top) {
        NodeList nl = top.getChildNodes();
        ArrayList<EventFilter> filterList = new ArrayList<EventFilter>(nl.getLength());
        for (int i = 0; i < nl.getLength(); ++i) {
            String node = nl.item(i).getNodeName();
            if (!node.equals(FILTER)) continue;
            String label = ((Element)nl.item(i)).getAttribute(LABEL);
            String columnName = ((Element)nl.item(i)).getAttribute(COLUMN_NAME);
            String condIsNot = ((Element)nl.item(i)).getAttribute(ISNOT);
            String pattern = ((Element)nl.item(i)).getAttribute(PATTERN);
            String caseSensitive = ((Element)nl.item(i)).getAttribute(CASE_SENSITIVE);
            String mode = ((Element)nl.item(i)).getAttribute(MODE);
            String isLocked = ((Element)nl.item(i)).getAttribute(IS_LOCKED);
            String typeA = ((Element)nl.item(i)).getAttribute(AVAILABILITY);
            String typeK = ((Element)nl.item(i)).getAttribute(KPI);
            EventFilter eventFilter = new EventFilter(label, columnName, pattern, Boolean.valueOf(caseSensitive), Integer.valueOf(mode), Boolean.valueOf(isLocked), Integer.valueOf(typeA), Integer.valueOf(typeK));
            eventFilter.m_isNOT = Boolean.valueOf(condIsNot);
            filterList.add(eventFilter);
        }
        return filterList;
    }
}

