/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.utils;

import com.blixx.log.RTLogger;
import com.blixx.server.ServerEngine;
import com.blixx.shared.utils.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;

public class BkpFile {
    public static boolean isEnabled = true;
    private static String bkpPath;

    public static synchronized void move(String file) {
        if (isEnabled) {
            BkpFile.move(new File(file));
        }
    }

    public static synchronized void move(File file) {
        if (!isEnabled) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        long max = System.currentTimeMillis() - 2073600000L;
        String name = file.getName();
        String bkpPath = ServerEngine.getInstance().getMainDir() + File.separator + "srv" + File.separator + "bkp";
        File bkpDir = new File(bkpPath);
        if (!bkpDir.exists()) {
            bkpDir.mkdirs();
        }
        HashMap<String, Integer> map = BkpFile.checkFiles(file, max, bkpDir);
        int i = 1;
        String bkpname = name + "." + i;
        if (map.containsKey(name)) {
            Integer maxn = map.get(name);
            bkpname = name + "." + (maxn + 1);
        }
        File bkp = new File(bkpDir, bkpname);
        file.renameTo(bkp);
    }

    public static synchronized File backup(String file) {
        if (!isEnabled) {
            return null;
        }
        return BkpFile.backup(new File(file));
    }

    public static synchronized File backup(File file) {
        File bkp = null;
        if (!isEnabled) {
            return bkp;
        }
        try {
            File bkpDir;
            if (!file.exists()) {
                return bkp;
            }
            long max = System.currentTimeMillis() - 2073600000L;
            String name = file.getName();
            if (bkpPath == null) {
                bkpPath = ServerEngine.getInstance().getMainDir() + File.separator + "srv" + File.separator + "bkp";
            }
            if (!(bkpDir = new File(bkpPath)).exists()) {
                bkpDir.mkdirs();
            }
            HashMap<String, Integer> map = BkpFile.checkFiles(file, max, bkpDir);
            int i = 1;
            String bkpname = name + "." + i;
            if (map.containsKey(name)) {
                Integer maxn = map.get(name);
                bkpname = name + "." + (maxn + 1);
            }
            bkp = new File(bkpDir, bkpname);
            FileUtils.copyFile(file, bkp);
        }
        catch (Throwable e) {
            bkp = null;
            RTLogger.print(3, "bkp failed for file: " + file.getName(), e);
        }
        return bkp;
    }

    public static File getLastBkp(File original) {
        File lastBkp;
        Integer num;
        File bkpDir;
        if (!isEnabled) {
            return null;
        }
        if (bkpPath == null) {
            bkpPath = ServerEngine.getInstance().getMainDir() + File.separator + "srv" + File.separator + "bkp";
        }
        if (!(bkpDir = new File(bkpPath)).exists()) {
            return null;
        }
        HashMap<String, Integer> map = BkpFile.checkFiles(original, 0L, bkpDir);
        if (map.size() > 0 && (num = map.get(original.getName())) != null && (lastBkp = new File(bkpDir, original.getName() + "." + num.toString())).exists() && lastBkp.length() > 0L) {
            return lastBkp;
        }
        return null;
    }

    private static HashMap<String, Integer> checkFiles(File file, long max, File bkpDir) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (!isEnabled) {
            return map;
        }
        final String filePrefix = file.getName();
        FilenameFilter fnf = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(filePrefix);
            }
        };
        File[] list = bkpDir.listFiles(fnf);
        ArrayList<String> names = new ArrayList<String>();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                String filename;
                if ((list[i].lastModified() < max || list[i].length() == 0L) && list[i].delete() || !(filename = list[i].getName()).startsWith(file.getName())) continue;
                names.add(filename);
                int li = filename.lastIndexOf(46);
                if (li == -1) continue;
                try {
                    String lastDigits = filename.substring(li + 1);
                    Integer num = Integer.valueOf(lastDigits);
                    String woDigits = filename.substring(0, li);
                    map.put(woDigits, num);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return map;
    }
}

