/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.utils;

import com.blixx.server.SPolicyRepository;
import com.blixx.server.ServerEngine;
import com.blixx.shared.AbstractCondition;
import com.blixx.shared.AbstractConditions;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.Condition;
import com.blixx.shared.Conditions;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgConditions;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SearchPolicies {
    private Map<String, String> m_matchedPolicies2 = new HashMap<String, String>();
    private SPolicyRepository m_polRep = ServerEngine.getInstance().getPolicyRepository();
    public static String POL = "p";
    public static String COND = "c";
    private static String ANY_ATTRIBUTES = "ANY_ATTRIBUTES";

    public SearchPolicies(String gloablSearchText, List<String> propertyTypeAndName) {
        if (this.m_polRep == null) {
            return;
        }
        List<String> polTypes = this.getPolicyTypes(propertyTypeAndName);
        Map<String, AbstractPolicy> knownPolicies = this.m_polRep.getAllPolicyMap();
        for (Map.Entry<String, AbstractPolicy> en : knownPolicies.entrySet()) {
            List conds;
            AbstractConditions conditions;
            Map<String, String> match;
            AbstractPolicy policy;
            String polName = en.getKey();
            AbstractPolicy o = en.getValue();
            if (o instanceof Policy) {
                policy = (Policy)o;
                if (!polTypes.contains("mon")) continue;
                match = this.searchInMainProperties("mon", policy.getName(), ((Policy)policy).getMainProperties(), gloablSearchText, ANY_ATTRIBUTES);
                if (match.size() > 0) {
                    this.m_matchedPolicies2.putAll(match);
                }
                conditions = ((Policy)policy).getConditions();
                conds = conditions.getConditionList();
                for (AbstractCondition c : conds) {
                    match = this.searchInConditionProperties("mon", policy.getName(), c.getConditionId(), c.getDescription(), ((Condition)c).getProperties(), gloablSearchText, ANY_ATTRIBUTES);
                    if (match.size() <= 0) continue;
                    this.m_matchedPolicies2.putAll(match);
                }
                continue;
            }
            if (!(o instanceof MsgPolicy)) continue;
            policy = (MsgPolicy)o;
            if (!polTypes.contains("msg")) continue;
            match = this.searchInMainProperties("msg", policy.getName(), ((MsgPolicy)policy).getMainProperties(), gloablSearchText, ANY_ATTRIBUTES);
            if (match.size() > 0) {
                this.m_matchedPolicies2.putAll(match);
            }
            conditions = ((MsgPolicy)policy).getConditions();
            conds = conditions.getConditionList();
            for (AbstractCondition c : conds) {
                match = this.searchInConditionProperties("msg", policy.getName(), c.getConditionId(), c.getDescription(), ((MsgCondition)c).getProperties(), gloablSearchText, ANY_ATTRIBUTES);
                if (match.size() <= 0) continue;
                this.m_matchedPolicies2.putAll(match);
            }
        }
    }

    public SearchPolicies(List<String> propertyTypeAndName) {
        if (this.m_polRep == null) {
            return;
        }
        List<String> requiredPolTypes = this.getPolicyTypes(propertyTypeAndName);
        List<String[]> propList = this.collectProperties(propertyTypeAndName);
        Map<String, AbstractPolicy> knownPolicies = this.m_polRep.getAllPolicyMap();
        for (Map.Entry<String, AbstractPolicy> en : knownPolicies.entrySet()) {
            String[] property;
            Map<String, String> map;
            String polName = en.getKey();
            AbstractPolicy pol = en.getValue();
            if (pol instanceof Policy && !requiredPolTypes.contains("mon") || pol instanceof MsgPolicy && !requiredPolTypes.contains("msg")) continue;
            int count = 0;
            HashMap<String, String> match = new HashMap<String, String>();
            for (int i = 0; i < propList.size() && (map = this.doesPropertyMatchAll(pol, property = propList.get(i))) != null && map.size() > 0; ++i) {
                match.putAll(map);
                ++count;
            }
            if (count != propList.size()) continue;
            this.m_matchedPolicies2.putAll(match);
        }
    }

    public List<String> getPolicyTypes(List<String> properties) {
        LinkedList<String> types = new LinkedList<String>();
        String polTypes = properties.get(0);
        if (polTypes.indexOf(9658) != -1) {
            types.add("mon");
            types.add("msg");
        } else {
            types.add(polTypes);
        }
        return types;
    }

    public List<String[]> collectProperties(List<String> properties) {
        ArrayList<String[]> propertyList = new ArrayList<String[]>();
        for (int i = 1; i < properties.size(); ++i) {
            String prop = properties.get(i);
            int SEP = prop.indexOf(9658);
            if (SEP == -1) continue;
            String propType = prop.substring(0, SEP);
            int SEP2 = prop.indexOf(9658, SEP + 1);
            int tl = prop.length();
            if (SEP2 != -1) {
                tl = SEP2;
            }
            String propName = prop.substring(SEP + 1, tl);
            if (tl + 1 >= prop.length()) continue;
            String propValue = prop.substring(tl + 1, prop.length());
            if ("".equals(propType) && "".equals(propName) && "".equals(propValue)) continue;
            propertyList.add(new String[]{propType, propName, propValue});
        }
        return propertyList;
    }

    public Map<String, String> doesPropertyMatchAll(Object pol, String[] property) {
        HashMap<String, String> allMatches = new HashMap<String, String>();
        String propType = property[0];
        String propName = property[1];
        String searchText = property[2];
        if (pol instanceof Policy) {
            Policy policy = (Policy)pol;
            if (POL.equals(propType)) {
                Properties mainProps = policy.getMainProperties();
                Map<String, String> match = this.searchInMainProperties("mon", policy.getName(), mainProps, searchText, propName);
                if (match.size() > 0) {
                    allMatches.putAll(match);
                }
            } else if (COND.equals(propType)) {
                Conditions conditions = policy.getConditions();
                List conds = conditions.getConditionList();
                for (Condition c : conds) {
                    Map<String, String> match = this.searchInConditionProperties("mon", policy.getName(), c.getConditionId(), c.getDescription(), c.getProperties(), searchText, propName);
                    if (match.size() <= 0) continue;
                    allMatches.putAll(match);
                }
            }
        } else if (pol instanceof MsgPolicy) {
            MsgPolicy policy = (MsgPolicy)pol;
            if (POL.equals(propType)) {
                Properties mainProps = policy.getMainProperties();
                Map<String, String> match = this.searchInMainProperties("msg", policy.getName(), mainProps, searchText, propName);
                if (match.size() > 0) {
                    allMatches.putAll(match);
                }
            } else if (COND.equals(propType)) {
                MsgConditions conditions = policy.getConditions();
                List conds = conditions.getConditionList();
                for (MsgCondition c : conds) {
                    Map<String, String> match = this.searchInConditionProperties("msg", policy.getName(), c.getConditionId(), c.getDescription(), c.getProperties(), searchText, propName);
                    if (match.size() <= 0) continue;
                    allMatches.putAll(match);
                }
            }
        }
        if (allMatches.size() > 0) {
            return allMatches;
        }
        return null;
    }

    private Map<String, String> searchInMainProperties(String polType, String polName, Properties mainProps, String searchText, String mainPropName) {
        HashMap<String, String> match = new HashMap<String, String>();
        StringBuffer sb = null;
        if (mainPropName != null && mainPropName.equals(ANY_ATTRIBUTES)) {
            for (String string : mainProps.keySet()) {
                String propValue = mainProps.getProperty(string);
                if (!propValue.toLowerCase().contains(searchText.toLowerCase())) continue;
                sb = new StringBuffer();
                sb.append(polType).append('\u25ba').append(polName).append('\u25ba').append(string);
                match.put(sb.toString(), "");
            }
        } else {
            String propValue = mainProps.getProperty(mainPropName);
            if (propValue.toLowerCase().contains(searchText.toLowerCase())) {
                sb = new StringBuffer();
                sb.append(polType).append('\u25ba').append(polName).append('\u25ba').append(mainPropName);
                match.put(sb.toString(), "");
            }
        }
        return match;
    }

    private Map<String, String> searchInConditionProperties(String polType, String polName, String condID, String condDesc, Properties cProps, String searchText, String condPropName) {
        HashMap<String, String> match = new HashMap<String, String>();
        StringBuffer sb = null;
        if (condPropName != null && condPropName.equals(ANY_ATTRIBUTES)) {
            for (String string : cProps.keySet()) {
                String propValue = cProps.getProperty(string);
                if (!propValue.toLowerCase().contains(searchText.toLowerCase())) continue;
                sb = new StringBuffer();
                sb.append(polType).append('\u25ba').append(polName).append('\u25ba').append(condID).append('\u25ba').append(condDesc).append('\u25ba').append(string);
                match.put(sb.toString(), "");
            }
        } else {
            String propValue = cProps.getProperty(condPropName);
            if (propValue.toLowerCase().contains(searchText.toLowerCase())) {
                sb = new StringBuffer();
                sb.append(polType).append('\u25ba').append(polName).append('\u25ba').append(condID).append('\u25ba').append(condDesc).append('\u25ba').append(condPropName);
                match.put(sb.toString(), "");
            }
        }
        return match;
    }

    public Map<String, String> getResult() {
        return this.m_matchedPolicies2;
    }
}

