/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.utils;

import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.Interval;
import com.blixx.shared.SEventFwd;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UpdateDBObjectHourly
extends SchedulerTask {
    private long lastIndicationTimeChecked = 0L;

    public UpdateDBObjectHourly() {
        super("UpdateDBObjectHourly");
        this.setInterval(Interval.getSimpleInterval(600));
    }

    @Override
    public boolean onGetData() {
        long tempMaxTime = 0L;
        Iterator<SEventFwd> itE = ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveAndInsertedAsClosedIterator();
        while (itE.hasNext()) {
            SEventFwd se = itE.next();
            if (se.getSTime() < this.lastIndicationTimeChecked || se.getNode().equals(se.getAgentNode())) continue;
            List<AgentCard> externalHosts = ServerEngine.getInstance().getAgentRepository().getExternalHosts(se.getNode());
            for (AgentCard ac : externalHosts) {
                if (!ac.isLocalAgent() || ac.getLastTimeOnline() >= se.getSTime()) continue;
                ac.setLastTimeOnline();
                if (RTLogger.getCurrentLevel() < 6) continue;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                RTLogger.print(6, "AC External {} LIT = %s", ac, sdf.format(new Date(ac.getLastTimeOnline())));
            }
            tempMaxTime = Math.max(tempMaxTime, se.getSTime());
        }
        this.lastIndicationTimeChecked = tempMaxTime;
        Map<String, AgentCard> map = ServerEngine.getInstance().getAgentRepository().getAgentCards();
        for (Map.Entry<String, AgentCard> en : map.entrySet()) {
            AgentCard ac;
            ac = en.getValue();
            if (!ac.isLocalAgent() || ac.getLastTimeOnline() <= 0L) continue;
            try {
                AgentCardCM acm = ServerEngine.getInstance().getAgentRepository().getAgentCardCM(ac.getAgentID());
                if (acm == null) {
                    acm = new AgentCardCM(ac.getAgentID());
                    acm.add("LIT", ac.getLastTimeOnline());
                    ServerEngine.getInstance().getAgentRepository().saveAgentCardCM(acm);
                    continue;
                }
                Long time = 0L;
                try {
                    Object value = acm.getValue("LIT");
                    if (value != null) {
                        time = Long.parseLong(String.valueOf(value));
                    }
                }
                catch (Throwable e) {
                    RTLogger.print(6, "Error parsing agent {} LIT: {}", ac, acm.getValue("LIT"));
                }
                if (time != null && time >= ac.getLastTimeOnline()) continue;
                acm.add("LIT", ac.getLastTimeOnline());
                ServerEngine.getInstance().getAgentRepository().saveAgentCardCM(acm);
            }
            catch (Throwable e) {
                RTLogger.print(5, String.valueOf(ac), e);
            }
        }
        return true;
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public boolean onStartRun() {
        return true;
    }

    @Override
    public boolean onStopRun() {
        return true;
    }

    @Override
    protected boolean onStopTask() {
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }
}

