/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.AbstractCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public abstract class AbstractConditions<V extends AbstractCondition> {
    public static final String _DESCRIPTION = "DESCRIPTION";
    public static final String _UUID = "CONDITION_ID";
    public UUID uuid = null;
    public String description = "";
    protected List<Properties> m_failedProperties = new ArrayList<Properties>();
    protected ArrayList<V> m_conditions = new ArrayList(1);

    public AbstractConditions() {
        this.uuid = UUID.randomUUID();
    }

    public List<V> getConditionList() {
        return this.m_conditions;
    }

    public void addCondition(V c) {
        this.m_conditions.add(c);
    }

    public abstract V addNewCondition();

    public V getCondition(String uuid) {
        AbstractCondition c = null;
        for (AbstractCondition ct : this.m_conditions) {
            if (!ct.condition_id.equals(uuid)) continue;
            c = ct;
            break;
        }
        return (V)c;
    }

    public int getConditionNumber(String uuid) {
        int pos = -1;
        if (this.m_conditions != null) {
            for (int i = 0; i < this.m_conditions.size(); ++i) {
                AbstractCondition ct = (AbstractCondition)this.m_conditions.get(i);
                if (!ct.condition_id.equals(uuid)) continue;
                pos = i;
                break;
            }
        }
        return pos;
    }

    public Properties getProperties() {
        Properties p = new Properties();
        if (this.description == null) {
            this.description = "";
        }
        p.setProperty(_DESCRIPTION, this.description);
        p.setProperty(_UUID, this.uuid.toString());
        return p;
    }

    public int getConditionCount() {
        return this.m_conditions.size();
    }

    public V getCondition(int pos) {
        return (V)((AbstractCondition)this.m_conditions.get(pos));
    }

    public List<Properties> getFailedConditions() {
        return this.m_failedProperties;
    }
}

