/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.log.RTLogger;
import com.blixx.shared.IID;
import com.blixx.shared.IODataStream;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.ITreeObject;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public class Assignment
implements IID,
IODataStream,
ITreeObject {
    public static final String ID = "ID";
    public static final String ASSIGNMENT = "ASSIGNMENT";
    public static final String AGENT_ID = "AGENT_ID";
    public static final String _TYPE = "_TYPE";
    public static final String USER = "USER";
    public static final String FTIME = "FTIME";
    public static final String UTIME = "UTIME";
    public static final String _LOCK = "_LOCK";
    private UUID m_id = null;
    private String m_name = null;
    private String m_type = null;
    private String m_agentID = null;
    private String m_user = null;
    private long m_ftime = 0L;
    private long m_utime = 0L;
    private int m_lock = 0;
    private String oid = null;

    public static Assignment getInstance(String agentID, String asName, String user, String type) {
        Assignment as = new Assignment();
        as.m_id = UUID.randomUUID();
        as.m_name = asName.intern();
        as.m_type = type;
        as.m_agentID = agentID;
        as.m_user = user;
        as.m_ftime = System.currentTimeMillis();
        as.m_utime = 0L;
        as.m_lock = 0;
        return as;
    }

    public static Assignment getInstance(Map<String, Object> row) {
        Assignment as = new Assignment();
        try {
            as.m_id = UUID.fromString((String)row.get(ID));
            as.m_name = (String)row.get(ASSIGNMENT);
            if (as.m_name != null) {
                as.m_name = as.m_name.intern();
            }
            as.m_type = (String)row.get(_TYPE);
            as.m_agentID = (String)row.get(AGENT_ID);
            if (as.m_agentID != null) {
                as.m_agentID = as.m_agentID.trim();
            }
            as.m_user = (String)row.get(USER);
            as.m_ftime = Long.parseLong(String.valueOf(row.get(FTIME)));
            as.m_utime = Long.parseLong(String.valueOf(row.get(UTIME)));
            as.m_lock = 0;
            try {
                as.m_lock = Integer.parseInt(String.valueOf(row.get(_LOCK)));
            }
            catch (NumberFormatException e) {
                RTLogger.print(5, "", e);
            }
        }
        catch (NumberFormatException e) {
            RTLogger.print(5, "", e);
            as = null;
        }
        return as;
    }

    @Override
    public String getID() {
        return this.m_id.toString();
    }

    public void setID(String id) {
        this.m_id = UUID.fromString(id);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String m_name) {
        this.m_name = m_name;
    }

    public String getAgentID() {
        return this.m_agentID;
    }

    public void setAgentID(String m_agentid) {
        this.m_agentID = m_agentid;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public long getFtime() {
        return this.m_ftime;
    }

    public long getUtime() {
        return this.m_utime;
    }

    public void setUtime(long m_utime) {
        this.m_utime = m_utime;
    }

    public int getLock() {
        return this.m_lock;
    }

    public void setLock(int m_lock) {
        if (this.m_lock == 1 && m_lock == 3) {
            m_lock = 4;
        }
        if (this.m_type.equals("pga") && m_lock == 2) {
            m_lock = 0;
        }
        if (this.m_lock == 1 && m_lock == 2) {
            m_lock = 1;
        }
        this.m_lock = m_lock;
        this.m_utime = System.currentTimeMillis();
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public void setType(String type) {
        this.m_type = type;
    }

    @Override
    public String getComparableName() {
        return this.m_name;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public void setObject(Object obj) {
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        this.m_agentID = dis.readUTF();
        this.m_id = UUID.fromString(dis.readUTF());
        this.m_name = dis.readUTF().intern();
        this.m_type = dis.readUTF().intern();
        this.m_user = dis.readUTF().intern();
        this.m_lock = dis.readInt();
        this.m_ftime = dis.readLong();
        this.m_utime = dis.readLong();
        return this;
    }

    @Override
    public void send(SDataOutputStream out) throws IOException {
        out.writeUTF(this.getAgentID());
        out.writeUTF(this.getID());
        out.writeUTF(this.getName());
        out.writeUTF(this.getType());
        out.writeUTF(this.getUser());
        out.writeInt(this.getLock());
        out.writeLong(this.getFtime());
        out.writeLong(this.getUtime());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Assignment) {
            Assignment in = (Assignment)obj;
            return this.m_name.equals(in.m_name) && this.m_type.equals(in.m_type) && this.m_agentID.equals(in.getAgentID());
        }
        return false;
    }

    public int hashCode() {
        if (this.m_id == null) {
            return super.hashCode();
        }
        return this.m_id.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName()).append(" {").append(this.getType()).append("}{").append(this.getAgentID()).append("} ").append(this.getLock());
        return sb.toString();
    }

    @Override
    public String getOID() {
        return this.oid;
    }

    @Override
    public void setOID(String oid) {
        this.oid = oid;
    }
}

