/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.AbstractCondition;
import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.PatternMatcherThread;
import com.blixx.shared.Severity;
import com.blixx.shared.exceptions.ConfigException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class Condition
extends AbstractCondition
implements Cloneable {
    protected double threshold = Double.NaN;
    protected double reset = Double.NaN;
    protected long silenceCount = 0L;
    protected boolean ignoreReset = false;
    protected int setSeverity = 0;
    protected int resetStateMinutes = 0;
    protected boolean sendFirst = false;

    public static Condition getNew(int number) {
        Condition c = new Condition();
        c.description = "Condition " + (number + 1);
        c.silenceCount = 0L;
        c.ignoreReset = false;
        c.resetStateMinutes = 0;
        c.reset = 0.0;
        c.set_text = "Monitor <$NAME> value (<$VALUE>) exceeded the threshold <$THRESHOLD>.";
        c.threshold = 0.0;
        c.actionType = "SEND".intern();
        c.initCAs();
        return c;
    }

    public static Condition getInstance(Properties prop, boolean isResetNeeded) throws ConfigException {
        String resend;
        Condition c = new Condition();
        c.initFrom(prop);
        c.set_text = prop.getProperty("TEXT", "").trim();
        c.threshold = Condition.getDouble(prop.getProperty("THRESHOLD").trim());
        c.reset = Condition.getDouble(prop.getProperty("RESET").trim());
        if (isResetNeeded && Double.isNaN(c.reset)) {
            c.reset = c.threshold;
        }
        if ((resend = prop.getProperty("RESEND")) != null) {
            c.resetStateMinutes = (int)Condition.getDouble(resend);
        }
        try {
            c.silenceCount = Long.parseLong(prop.getProperty("DURATION").trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String ss = prop.getProperty("SEVERITY").trim();
        c.setSeverity = ss.length() == 1 ? Integer.parseInt(ss) : Severity.getSeverity(ss);
        try {
            c.ignoreReset = Boolean.parseBoolean(prop.getProperty("IGNORE_RESET", "false").trim());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        String sendFirst = prop.getProperty("SEND_FIRST");
        if (sendFirst != null && sendFirst.equalsIgnoreCase("true")) {
            c.sendFirst = true;
        }
        return c;
    }

    public static double getDouble(String tresh) {
        double d = Double.NaN;
        try {
            d = Double.parseDouble(tresh);
        }
        catch (NumberFormatException e) {
            if (tresh.indexOf(46) != -1) {
                tresh = tresh.replace('.', ',');
            } else if (tresh.indexOf(44) != -1) {
                tresh = tresh.replace(',', '.');
            }
            try {
                d = Double.parseDouble(tresh);
            }
            catch (NumberFormatException e1) {
                throw new ConfigException("Threshold incorrect");
            }
        }
        return d;
    }

    public double getThreshold() {
        return this.threshold;
    }

    @Override
    public Properties getProperties() {
        Properties p = super.getProperties();
        p.setProperty("THRESHOLD", "" + this.threshold);
        p.setProperty("RESET", "" + this.reset);
        p.setProperty("DURATION", "" + this.silenceCount);
        p.setProperty("SEVERITY", Severity.getSeverity(this.setSeverity));
        p.setProperty("KEY", this.msgkey);
        p.setProperty("TEXT", this.set_text);
        p.setProperty("RESEND", "" + this.resetStateMinutes);
        p.setProperty("SET_GROUP", this.set_msggrp);
        if (this.ignoreReset) {
            p.setProperty("IGNORE_RESET", "TRUE");
        } else {
            p.setProperty("IGNORE_RESET", "FALSE");
        }
        if (this.sendFirst) {
            p.setProperty("SEND_FIRST", "" + this.sendFirst);
        }
        this.putCustomAttributes(p);
        return p;
    }

    @Override
    public String getAsSourceString(String policy_name) {
        StringBuilder sb = new StringBuilder();
        sb.append("Monitor:").append(policy_name).append(':').append(this.condition_id);
        return sb.toString();
    }

    public boolean isObjectMatch(String object, Map<String, String> addVariablesHere) {
        boolean isMatch = false;
        if (this.m_filter_obj != null) {
            Map<String, String> m;
            PatternMatchResult matchesR = PatternMatcherThread.match(this.m_filter_obj, object);
            boolean bl = isMatch = matchesR != null && matchesR.isMatch();
            if (addVariablesHere != null && isMatch && (m = matchesR.getVariableMap()) != null && m.size() > 0) {
                addVariablesHere.putAll(m);
            }
        }
        return isMatch;
    }

    public Condition clone() {
        Properties nP = this.getProperties();
        nP.setProperty("CONDITION_ID", UUID.randomUUID().toString());
        nP.setProperty("HELPTEXT_ID", UUID.randomUUID().toString());
        Condition newCondition = Condition.getInstance(nP, this.ignoreReset);
        return newCondition;
    }

    public double getReset() {
        return this.reset;
    }

    public void setReset(double reset) {
        this.reset = reset;
    }

    public long getSilenceCount() {
        return this.silenceCount;
    }

    public void setSilenceCount(long duration) {
        this.silenceCount = duration;
    }

    public boolean isIgnoreReset() {
        return this.ignoreReset;
    }

    public void setIgnoreReset(boolean ignoreReset) {
        this.ignoreReset = ignoreReset;
    }

    public int getResetStateMinutes() {
        return this.resetStateMinutes;
    }

    public void setResetStateMinutes(int resend) {
        this.resetStateMinutes = resend;
    }

    public boolean isSendFirst() {
        return this.sendFirst;
    }

    public void setSendFirst(boolean sendFirst) {
        this.sendFirst = sendFirst;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public int getSetSeverity() {
        return this.setSeverity;
    }

    public void setSetSeverity(int setSeverity) {
        this.setSeverity = setSeverity;
    }
}

