/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.bes.utils.CommTokenManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.io.LRUConcurrentCache;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;

public class Cryptor {
    private static final Pattern d = Pattern.compile("\\d+");
    private static final int DIFF = 305;
    private static final int MAX_BYTES_LENGTH = 250000000;
    private static final int MAX_STRING_LENGTH = 0x5000000;
    private static final int USE_CACHE_MAX_STRING_LENGTH = 10;
    private static final LRUConcurrentCache<String, byte[]> cacheV1 = new LRUConcurrentCache(5000);
    private static final LRUConcurrentCache<String, byte[]> cacheV2 = new LRUConcurrentCache(5000);
    private static final Charset charset = StandardCharsets.UTF_8;
    private static final String v4key = "boom";
    private static boolean useIntern = true;
    private static final ByteArrayPool byteArrayPool = new ByteArrayPool();

    public static String encrypt(String in) {
        StringBuilder out = new StringBuilder();
        byte[] b = in.getBytes();
        int index = 0;
        byte[] byArray = b;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int value;
            index = value = byArray[i];
            if (9 < (index += 305) && index < 100) {
                out.append("0");
            } else if (index < 9) {
                out.append("00");
            }
            out.append(index);
        }
        return out.toString();
    }

    public static String decrypt(String in) {
        byte[] mass;
        if (in == null || in.isEmpty()) {
            return in;
        }
        if (!d.matcher(in).matches()) {
            return Cryptor.decrypt2(in);
        }
        try {
            int index = 0;
            mass = new byte[in.length() / 3];
            for (int i = 0; i < in.length(); i += 3) {
                String t = in.substring(i, i + 3);
                int v = Integer.parseInt(t) - 305;
                mass[index] = (byte)v;
                ++index;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Decryption failed!");
        }
        return new String(mass);
    }

    public static String decryptV3(String in, String secretKeyV3) {
        if (in == null || in.isEmpty()) {
            return in;
        }
        try {
            return Cryptor.readUTFV3(in, secretKeyV3);
        }
        catch (IOException e) {
            RTLogger.print(1, e.getMessage());
            return "";
        }
    }

    public static String decryptV4(String in) {
        return Cryptor.decryptV3(in, v4key);
    }

    public static String encrypt2(String in) {
        try {
            return Base64.getEncoder().encodeToString(Cryptor.writeUTF(in, 1, ""));
        }
        catch (IOException e) {
            RTLogger.print(1, e.getMessage());
            return "";
        }
    }

    private static String decrypt2(String in) {
        if (in == null || in.isEmpty()) {
            return in;
        }
        String res = "error32256";
        try {
            res = Cryptor.readUTF(in);
        }
        catch (Throwable e) {
            RTLogger.print(1, e.getMessage());
        }
        return res;
    }

    public static String encrypt3(String in) {
        try {
            return Base64.getEncoder().encodeToString(Cryptor.writeUTF(in, 2, ""));
        }
        catch (IOException e) {
            RTLogger.print(1, e.getMessage());
            return "";
        }
    }

    public static String encrypt4(String in) {
        try {
            return Base64.getEncoder().encodeToString(Cryptor.writeUTF(in, 4, v4key));
        }
        catch (IOException e) {
            RTLogger.print(1, e.getMessage());
            return "";
        }
    }

    public static byte[] writeUTF(String msg, int version, String secretKeyV3) throws IOException {
        if (version >= 3 && secretKeyV3.isEmpty()) {
            throw new IllegalStateException("Please define the secret key first for V3");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (DataOutputStream stream = new DataOutputStream(bos);){
            switch (version) {
                case 3: {
                    stream.writeInt(-10);
                    break;
                }
                case 4: {
                    stream.writeInt(-20);
                    break;
                }
                case 2: {
                    stream.writeInt(-5);
                    break;
                }
                case 0: {
                    stream.writeInt(-30);
                    break;
                }
            }
            if (msg == null || msg.isEmpty()) {
                stream.writeInt(0);
            } else {
                if (msg.length() > 0x5000000) {
                    msg = msg.substring(0, 0x5000000);
                }
                byte[] cached = null;
                if (msg.length() < 10) {
                    switch (version) {
                        case 1: {
                            cached = cacheV1.get(msg);
                            break;
                        }
                        case 2: {
                            cached = cacheV2.get(msg);
                        }
                    }
                }
                if (cached != null) {
                    stream.writeInt(cached.length);
                    stream.write(cached);
                } else {
                    byte[] toEnc = msg.getBytes(charset);
                    byte[] enc = Cryptor.writeEncoded(toEnc, 0, toEnc.length, version, secretKeyV3);
                    if (enc != null) {
                        stream.writeInt(enc.length);
                        stream.write(enc);
                        if (msg.length() < 10) {
                            switch (version) {
                                case 1: {
                                    cacheV1.put(msg, enc);
                                    break;
                                }
                                case 2: {
                                    cacheV2.put(msg, enc);
                                }
                            }
                        }
                    } else {
                        stream.writeInt(0);
                    }
                }
            }
        }
        return bos.toByteArray();
    }

    public static byte[] writeFileEncoded(InputStream fis, long maxChunkSize, int version, String secretKeyV3) throws IOException {
        if (version >= 3 && secretKeyV3.isEmpty()) {
            throw new IllegalStateException("Please define the secret key first for V3");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (DataOutputStream stream = new DataOutputStream(bos);){
            stream.writeInt(version);
            byte[] arr = new byte[65536];
            int countB = -1;
            for (long sent = 0L; sent < maxChunkSize && (countB = fis.read(arr)) != -1; sent += (long)countB) {
                byte[] enc = Cryptor.writeEncoded(arr, 0, countB, version, secretKeyV3);
                stream.writeInt(enc.length);
                stream.write(enc);
            }
            stream.writeInt(-1);
        }
        return bos.toByteArray();
    }

    public static String readUTF(String source, String defaultReturnValue) {
        String res = defaultReturnValue;
        try {
            res = Cryptor.readUTF(source);
        }
        catch (Exception e) {
            RTLogger.print(1, e.getMessage());
        }
        return res;
    }

    public static String readUTF(DataInputStream source, String defaultReturnValue) {
        String res = defaultReturnValue;
        try {
            res = Cryptor.readUTF(source);
        }
        catch (Exception e) {
            RTLogger.print(1, e.getMessage());
        }
        return res;
    }

    public static String readUTF(String source) throws IOException {
        return Cryptor.readUTFV3(source, v4key);
    }

    public static String readUTF(DataInput source) throws IOException {
        return Cryptor.readUTFV3(source, v4key, new int[]{1});
    }

    public static String readUTFV3(DataInput source, String secretKeyV3, int[] lastProtocolVersion) throws IOException {
        String result = null;
        int version = 1;
        if (lastProtocolVersion != null && lastProtocolVersion.length > 0) {
            version = lastProtocolVersion[0];
        }
        int size = 0;
        try {
            size = source.readInt();
            if (size < 0 || size > 250000000) {
                switch (size) {
                    case -30: {
                        size = source.readInt();
                        version = 0;
                        break;
                    }
                    case -5: {
                        size = source.readInt();
                        version = 2;
                        break;
                    }
                    case -10: {
                        size = source.readInt();
                        version = 3;
                        break;
                    }
                    case -20: {
                        size = source.readInt();
                        version = 4;
                        break;
                    }
                    case 557933411: {
                        throw new IOException("Agent was re-assigned to another server???");
                    }
                    default: {
                        throw new IOException("transport failed" + size);
                    }
                }
                if (lastProtocolVersion != null && lastProtocolVersion.length > 0) {
                    lastProtocolVersion[0] = version;
                }
            }
            if (version == 4 && secretKeyV3 == null) {
                secretKeyV3 = v4key;
            }
            if ((version == 3 || version == 4) && secretKeyV3.isEmpty()) {
                throw new IllegalStateException("Please define the secret key first for V3");
            }
            if (size == 0) {
                return "";
            }
            if (size < 0 || size > 250000000) {
                throw new IOException("transport failed--" + size);
            }
            byte[] toDec = version == 0 ? new byte[size] : byteArrayPool.borrow(size);
            source.readFully(toDec, 0, size);
            byte[] dec = Cryptor.readEncoded(toDec, size, version, secretKeyV3);
            byteArrayPool.offer(toDec);
            if (dec == null) {
                throw new IOException("Incorrect transport SecretKey");
            }
            result = useIntern ? new String(dec, charset).intern() : new String(dec, charset);
        }
        catch (Exception e) {
            IOException iox = new IOException(e.getMessage());
            iox.setStackTrace(e.getStackTrace());
            throw iox;
        }
        return result;
    }

    public static byte[] writeEncoded(byte[] toEnc, int start, int length, int version, String secretKeyV3) {
        return switch (version) {
            case 1 -> CommTokenManager.encryptV1(toEnc, start, length);
            case 2 -> CommTokenManager.encryptV2(toEnc, start, length);
            case 3 -> CommTokenManager.encryptV3(toEnc, secretKeyV3, start, length);
            case 4 -> CommTokenManager.encryptV4(toEnc, secretKeyV3, start, length);
            default -> Arrays.copyOfRange(toEnc, start, start + length);
        };
    }

    private static byte[] readEncoded(byte[] toDec, int size, int version, String secretKeyV3) {
        byte[] dec = null;
        switch (version) {
            case 4: {
                dec = CommTokenManager.decryptV4(toDec, 0, size, secretKeyV3);
                break;
            }
            case 3: {
                dec = CommTokenManager.decryptV3(toDec, 0, size, secretKeyV3);
                break;
            }
            case 2: {
                dec = CommTokenManager.decryptV2(toDec, 0, size);
                break;
            }
            case 0: {
                dec = toDec;
                break;
            }
            default: {
                dec = CommTokenManager.decryptV1(toDec, 0, size);
            }
        }
        return dec;
    }

    public static String readUTFV3(String source, String secretKeyV3) throws IOException {
        String result = null;
        source = source.replace("\\r\\n", "").replace("\r\n", "").trim();
        byte[] arr = Base64.getDecoder().decode(source);
        ByteArrayInputStream bin = new ByteArrayInputStream(arr);
        try (DataInputStream stream = new DataInputStream(bin);){
            result = Cryptor.readUTFV3(stream, secretKeyV3, new int[]{1});
        }
        return result;
    }

    public static boolean readFile(DataInput stream, String fullPath, boolean isDecode, int version, boolean append, String secretKeyV3) throws FileNotFoundException, IOException {
        String dir;
        File fdir;
        boolean success = true;
        if ((fullPath = fullPath.replace('\\', '/')).indexOf(47) != -1 && !(fdir = new File(dir = fullPath.substring(0, fullPath.lastIndexOf(47)))).exists() && !fdir.mkdirs()) {
            RTLogger.print(1, "error mkdirs {}", dir);
            throw new FileNotFoundException("dir: " + dir);
        }
        long lastLogTime = System.currentTimeMillis();
        long logIntervalMs = 5000L;
        try (FileOutputStream fos2 = new FileOutputStream(fullPath, append);
             BufferedOutputStream bos = new BufferedOutputStream(fos2);){
            int blockSize = -1;
            long totalSize = 0L;
            byte[] inArr = new byte[65536];
            while ((blockSize = stream.readInt()) > 0) {
                if (blockSize != inArr.length) {
                    inArr = new byte[blockSize];
                }
                stream.readFully(inArr);
                totalSize += (long)inArr.length;
                if (isDecode) {
                    inArr = Cryptor.readEncoded(inArr, inArr.length, version, secretKeyV3);
                }
                bos.write(inArr);
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastLogTime <= logIntervalMs) continue;
                RTLogger.print(2, "Reading file... progress: %sMB (blocksize=%s) file: %s", totalSize / 0x100000L, blockSize, fullPath);
                lastLogTime = currentTime;
            }
        }
        catch (EOFException fos2) {
        }
        catch (Exception e) {
            success = false;
            RTLogger.print(1, e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        return success;
    }

    private static class ByteArrayPool {
        private final int maxPerBucket;
        private final ConcurrentHashMap<Integer, ConcurrentLinkedQueue<byte[]>> pools = new ConcurrentHashMap();

        public ByteArrayPool() {
            this(128);
        }

        public ByteArrayPool(int maxPerBucket) {
            this.maxPerBucket = Math.max(1, maxPerBucket);
        }

        private static int nextPowerOfTwo(int n) {
            int r;
            for (r = 1; r < n; r <<= 1) {
            }
            return r;
        }

        public byte[] borrow(int size) {
            byte[] arr;
            int bucket = ByteArrayPool.nextPowerOfTwo(size);
            ConcurrentLinkedQueue q = this.pools.get(bucket);
            if (q == null) {
                q = this.pools.computeIfAbsent(bucket, b -> new ConcurrentLinkedQueue());
            }
            if ((arr = q.poll()) == null || arr.length != bucket) {
                arr = new byte[bucket];
            }
            return arr;
        }

        public void offer(byte[] arr) {
            if (arr == null) {
                return;
            }
            int bucket = ByteArrayPool.nextPowerOfTwo(arr.length);
            ConcurrentLinkedQueue q = this.pools.get(bucket);
            if (q == null) {
                q = this.pools.computeIfAbsent(bucket, b -> new ConcurrentLinkedQueue());
            }
            if (q.size() < this.maxPerBucket) {
                q.offer(arr);
            }
        }

        public void clear() {
            this.pools.clear();
        }

        public Map<Integer, Integer> status() {
            HashMap<Integer, Integer> st = new HashMap<Integer, Integer>();
            for (Map.Entry<Integer, ConcurrentLinkedQueue<byte[]>> e : this.pools.entrySet()) {
                st.put(e.getKey(), e.getValue().size());
            }
            return st;
        }
    }
}

