/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;

public class DeploymentStatus {
    protected String m_id = null;
    protected String m_acid = null;
    protected long m_initTime = 0L;
    protected long m_expireTime = 0L;
    protected String m_type = null;
    protected int m_state = 0;
    protected List<String> m_fileNames = new ArrayList<String>(0);
    public static final String TYPE_UNDEPLOY_PKG = "UPKG";
    public static final String TYPE_UNDEPLOY_POLICIES = "UNDEPLOY_POLICES";
    public static final String TYPE_UPLOAD_JAR = "JAR";
    public static final String TYPE_UPLOAD_POLICY = "POLICY";
    public static final String TYPE_UPLOAD_PKG = "PKG";

    public DeploymentStatus() {
    }

    public DeploymentStatus(String deploymentID, String acid, long initTime, long expireTime, String type, int state) {
        this.m_id = deploymentID;
        this.m_acid = acid;
        this.m_initTime = initTime;
        this.m_expireTime = expireTime;
        this.m_type = type;
        this.m_state = state;
    }

    public void initFromJson(JsonObject el) {
        this.m_id = el.getAsJsonPrimitive("id").getAsString();
        this.m_acid = el.getAsJsonPrimitive("acid").getAsString();
        this.m_initTime = el.getAsJsonPrimitive("itime").getAsLong();
        this.m_expireTime = el.getAsJsonPrimitive("etime").getAsLong();
        this.m_type = el.getAsJsonPrimitive("type").getAsString();
        this.m_state = el.getAsJsonPrimitive("state").getAsInt();
        JsonArray arr = el.getAsJsonArray("files");
        for (JsonElement elf : arr) {
            this.m_fileNames.add(elf.getAsString());
        }
    }

    public JsonElement getJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("id", this.getID());
        obj.addProperty("acid", this.getAcid());
        obj.addProperty("itime", this.getInitTime());
        obj.addProperty("etime", this.getExpireTime());
        obj.addProperty("type", this.getType());
        obj.addProperty("state", this.getState());
        JsonArray array = new JsonArray();
        for (String fileName : this.getFileNames()) {
            array.add(new JsonPrimitive(fileName));
        }
        obj.add("files", array);
        return obj;
    }

    public String getID() {
        return this.m_id;
    }

    public void setID(String id) {
        this.m_id = id;
    }

    public String getAcid() {
        return this.m_acid;
    }

    public void setAcid(String acid) {
        this.m_acid = acid;
    }

    public long getInitTime() {
        return this.m_initTime;
    }

    public void setInitTime(long initTime) {
        this.m_initTime = initTime;
    }

    public long getExpireTime() {
        return this.m_expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.m_expireTime = expireTime;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public int getState() {
        return this.m_state;
    }

    public void setState(int state) {
        this.m_state = state;
    }

    public List<String> getFileNames() {
        return this.m_fileNames;
    }

    public void setFileNames(List<String> fileNames) {
        this.m_fileNames = fileNames;
    }
}

