/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.exceptions.ConfigException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Interval {
    private static final String WRONG_INCOMING_FORMAT_OF_INTERVAL = "Wrong incoming format of interval: ";
    public static final int OneDay = 86400;
    public static final int OneWeek = 604800;
    public static final int OneHour = 3600;
    public static Pattern mainPattern = Pattern.compile("\\s*(?:(\\d+)w)?(?:(\\d+)d)?(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?(.*)");
    public static Pattern fixedTimePeriodPattern = Pattern.compile("\\s*([w|d|h|m])(\\d+)?:(\\d+)?:(\\d+)?:(\\d+)?\\s*");
    public static Pattern emergencyPattern = Pattern.compile("(\\d+).*");
    public static Pattern notOfficialSecondsPattern = Pattern.compile("\\s*sec:(\\d+).*");
    public static final int PLAIN_SECONDS = 0;
    public static final int FIXED_HOURLY = 1;
    public static final int FIXED_DAILY = 2;
    public static final int FIXED_WEEKLY = 3;
    public static final int FIXED_MONTHLY = 5;
    public static final int FIXED_SHIFTED_MINUTES = 4;
    public AtomicInteger m_type = new AtomicInteger(0);
    public AtomicInteger m_shiftSeconds = new AtomicInteger(0);
    public AtomicInteger m_intervalSeconds = new AtomicInteger(60);

    private Interval() {
        this(0);
    }

    private Interval(int type) {
        this.m_type.set(type);
    }

    private Interval(int type, int intervalSeconds, int shiftSeconds) {
        this.m_type.set(type);
        this.m_shiftSeconds.set(shiftSeconds);
        this.m_intervalSeconds.set(intervalSeconds);
    }

    public static Interval getSimpleInterval(int seconds) {
        Interval ivl = new Interval();
        ivl.m_intervalSeconds.set(seconds);
        return ivl;
    }

    public static Interval getHourlyInterval(int minutes, int seconds) {
        Interval ivl = new Interval(1);
        ivl.m_intervalSeconds.set(3600);
        ivl.m_shiftSeconds.set(minutes * 60 + seconds);
        return ivl;
    }

    public static Interval getDailyInterval(int hours, int minutes, int seconds) {
        Interval ivl = new Interval(2);
        ivl.m_intervalSeconds.set(86400);
        ivl.m_shiftSeconds.set(hours * 3600 + minutes * 60 + seconds);
        return ivl;
    }

    public static Interval getWeeklyInterval(int days, int hours, int minutes, int seconds) {
        Interval ivl = new Interval(3);
        ivl.m_intervalSeconds.set(604800);
        ivl.m_shiftSeconds.set(days * 86400 + hours * 3600 + minutes * 60 + seconds);
        return ivl;
    }

    public long getIntervalMilliseconds() {
        return 1000L * (long)this.m_intervalSeconds.get();
    }

    public int getIntervalSeconds() {
        return this.m_intervalSeconds.get();
    }

    public int getIntervalMinutes() {
        return this.getIntervalSeconds() / 60;
    }

    public int getShiftSeconds() {
        return this.m_shiftSeconds.get();
    }

    public int getType() {
        return this.m_type.get();
    }

    public static Interval parseInterval(String input, int overrideIfIncorrectToValue) {
        Interval intervalObj = new Interval(0, -1, 0);
        Matcher m = fixedTimePeriodPattern.matcher(input);
        if (m.matches()) {
            String secS;
            String minS;
            String hoursS;
            String character = m.group(1);
            String daysS = m.group(2);
            if (daysS == null) {
                daysS = "0";
            }
            if ((hoursS = m.group(3)) == null) {
                hoursS = "0";
            }
            if ((minS = m.group(4)) == null) {
                minS = "0";
            }
            if ((secS = m.group(5)) == null) {
                secS = "0";
            }
            int days = Integer.parseInt(daysS);
            int hours = Integer.parseInt(hoursS);
            int min = Integer.parseInt(minS);
            int sec = Integer.parseInt(secS);
            if ((days < 8 || character.charAt(0) == 'm') && hours < 24 && min < 60 && sec < 60) {
                intervalObj = new Interval(0, -1, 0);
                if (input.charAt(0) == 'm') {
                    int interval = days * 60;
                    intervalObj.m_type.set(4);
                    intervalObj.m_intervalSeconds.set(interval);
                    int shift = hours * 3600 + min * 60 + sec;
                    intervalObj.m_shiftSeconds.set(shift);
                    if (intervalObj.m_intervalSeconds.get() * 60 < shift) {
                        return null;
                    }
                } else {
                    if (input.charAt(0) == 'w') {
                        intervalObj.m_type.set(3);
                        intervalObj.m_intervalSeconds.set(0);
                        intervalObj.m_intervalSeconds.set(604800);
                    } else if (input.charAt(0) == 'd') {
                        intervalObj.m_type.set(2);
                        intervalObj.m_intervalSeconds.set(86400);
                        days = 0;
                    } else if (input.charAt(0) == 'h') {
                        intervalObj.m_type.set(1);
                        intervalObj.m_intervalSeconds.set(3600);
                        days = 0;
                        hours = 0;
                    }
                    int interval = days * 86400 + hours * 3600 + min * 60 + sec;
                    intervalObj.m_shiftSeconds.set(interval);
                }
            }
        } else {
            int seconds;
            block18: {
                seconds = -1;
                try {
                    seconds = Interval.parseInterval(input);
                }
                catch (ConfigException e) {
                    if (overrideIfIncorrectToValue <= -1) break block18;
                    seconds = overrideIfIncorrectToValue;
                }
            }
            if (seconds > -1) {
                intervalObj = new Interval();
                intervalObj.m_type.set(0);
                intervalObj.m_shiftSeconds.set(0);
                intervalObj.m_intervalSeconds.set(seconds);
            }
        }
        return intervalObj;
    }

    private static int parseInterval(String interval) throws ConfigException {
        int ival = -1;
        if (interval == null || interval.length() == 0) {
            throw new ConfigException(WRONG_INCOMING_FORMAT_OF_INTERVAL + interval);
        }
        Matcher m = mainPattern.matcher(interval.toLowerCase());
        Matcher msec = notOfficialSecondsPattern.matcher(interval.toLowerCase());
        if (msec.matches()) {
            try {
                String sec = msec.group(1);
                ival = Integer.parseInt(sec);
            }
            catch (Throwable sec) {}
        } else if (m.matches()) {
            try {
                String weeks = m.group(1);
                String days = m.group(2);
                String hours = m.group(3);
                String min = m.group(4);
                String sec = m.group(5);
                String other = m.group(6);
                if (other != null && other.length() > 0) {
                    throw new ConfigException(WRONG_INCOMING_FORMAT_OF_INTERVAL + interval);
                }
                if (null == weeks && null == days && null == hours && null == min && null == sec) {
                    Matcher m2 = emergencyPattern.matcher(interval.toLowerCase());
                    if (m2.matches()) {
                        min = m2.group(1);
                    } else {
                        throw new ConfigException(WRONG_INCOMING_FORMAT_OF_INTERVAL + interval);
                    }
                }
                int total = 0;
                if (sec != null) {
                    total += Integer.parseInt(sec);
                }
                if (min != null) {
                    total += Integer.parseInt(min) * 60;
                }
                if (hours != null) {
                    total += Integer.parseInt(hours) * 3600;
                }
                if (days != null) {
                    total += Integer.parseInt(days) * 86400;
                }
                if (weeks != null) {
                    total += Integer.parseInt(weeks) * 86400 * 7;
                }
                ival = total;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (ival < 0) {
            throw new ConfigException(WRONG_INCOMING_FORMAT_OF_INTERVAL + interval);
        }
        return ival;
    }

    public static boolean checkInterval(String interval) {
        return Interval.parseInterval(interval, -1).getIntervalSeconds() >= 0;
    }

    public static boolean checkInterval(String interval, int minimumSeconds) {
        return Interval.parseInterval(interval, -1).getIntervalSeconds() >= minimumSeconds;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Interval) {
            Interval ivl = (Interval)obj;
            if (this.m_type.get() == ivl.m_type.get() && this.m_intervalSeconds.get() == ivl.m_intervalSeconds.get() && this.m_shiftSeconds.get() == ivl.m_shiftSeconds.get()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.m_intervalSeconds.get();
    }

    public String toString() {
        Object res = this.getIntervalSeconds() + "s";
        switch (this.m_type.get()) {
            case 0: {
                int total = this.getIntervalSeconds();
                int days = total / 86400;
                int hours = (total -= days * 86400) / 3600;
                int min = (total -= hours * 3600) / 60;
                int sec = total -= min * 60;
                StringBuilder sb = new StringBuilder();
                if (days > 0) {
                    sb.append(days).append('d');
                }
                if (hours > 0) {
                    sb.append(hours).append('h');
                }
                if (min > 0) {
                    sb.append(min).append('m');
                }
                if (sec > 0) {
                    sb.append(sec).append('s');
                }
                res = sb.toString();
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                StringBuilder sb3 = new StringBuilder();
                sb3.append("h0:00");
                res = sb3.toString();
                break;
            }
            default: {
                res = this.getIntervalSeconds() / 60 + "m";
            }
        }
        return res;
    }
}

