/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MonitorSerie {
    public static final String NOVALUE = "NoValue";
    public static final String JSON_DATA = "data";
    public static final String JSON_VALUE = "v";
    public static final String JSON_TIME = "t";
    public static final String JSON_HOST = "host";
    public static final String JSON_OBJECT = "obj";
    public static final String JSON_POLICY = "pol";
    public static final int MAX_DEFAULT = 300;
    public static final String CONC = "@@";
    private String policyName = null;
    private String object = null;
    private String host = null;
    private String key = null;
    private List<TimeValue> values = new LinkedList<TimeValue>();
    private int maxSize = 300;

    public MonitorSerie(String policyName, String object) {
        this.policyName = policyName == null ? "" : policyName.intern();
        this.object = object == null ? "" : object.intern();
    }

    public MonitorSerie(String policyName, String object, int maxSize) {
        this(policyName, object);
        this.maxSize = maxSize;
    }

    public MonitorSerie(String policyName, String object, String host) {
        this(policyName, object);
        if (host != null) {
            this.host = host.intern();
        }
    }

    public MonitorSerie(String policyName, String object, String host, int maxSize) {
        this(policyName, object, host);
        this.maxSize = maxSize;
    }

    public MonitorSerie add(double value, long time) {
        this.values.add(0, new TimeValue(time, value));
        while (this.values.size() > this.maxSize) {
            this.values.remove(this.values.size() - 1);
        }
        return this;
    }

    public MonitorSerie clear() {
        this.values.clear();
        return this;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getObject() {
        return this.object;
    }

    public String getHost() {
        return this.host;
    }

    public String getKey() {
        if (this.key == null) {
            this.key = this.getPolicyName() + CONC + this.getObject();
            if (this.host != null) {
                this.key = this.key + CONC + this.getHost();
            }
        }
        return this.key;
    }

    public TimeValue getLatestValue() {
        return this.values.isEmpty() ? null : this.values.get(0);
    }

    public TimeValue getOldestValue() {
        int pos = this.values.size() - 1;
        return pos >= 0 ? this.values.get(pos) : null;
    }

    public int size() {
        return this.values.size();
    }

    public String getLatestValueAsString() {
        return this.getLatestValue() == null ? NOVALUE : String.valueOf(this.getLatestValue());
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public List<TimeValue> getValues() {
        return this.values;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getKey());
        Iterator<TimeValue> it = this.values.iterator();
        while (it.hasNext()) {
            TimeValue tv = it.next();
            sb.append(' ').append(tv.toString());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public JsonElement toJson() {
        JsonObject top = new JsonObject();
        top.addProperty(JSON_POLICY, this.getPolicyName());
        top.addProperty(JSON_OBJECT, this.getObject());
        top.addProperty(JSON_HOST, this.getHost() == null ? "" : this.getHost());
        JsonArray jso = new JsonArray();
        ArrayList<TimeValue> data = new ArrayList<TimeValue>(this.values);
        Collections.reverse(data);
        for (TimeValue tv : data) {
            JsonObject serieElement = new JsonObject();
            JsonPrimitive time = new JsonPrimitive(tv.getTime());
            JsonPrimitive value = new JsonPrimitive(tv.getValue());
            serieElement.add(JSON_TIME, time);
            serieElement.add(JSON_VALUE, value);
            jso.add(serieElement);
        }
        top.add(JSON_DATA, jso);
        return top;
    }

    public static MonitorSerie create(JsonElement element) {
        JsonObject jobj = element.getAsJsonObject();
        String policyName = jobj.get(JSON_POLICY).getAsString();
        String object = jobj.get(JSON_OBJECT).getAsString();
        String host = jobj.get(JSON_HOST).getAsString();
        MonitorSerie ms = new MonitorSerie(policyName, object, host);
        JsonArray data = jobj.getAsJsonArray(JSON_DATA);
        for (JsonElement o : data) {
            if (!(o instanceof JsonObject)) continue;
            JsonObject dataElement = (JsonObject)o;
            long time = dataElement.getAsJsonPrimitive(JSON_TIME).getAsLong();
            double value = dataElement.getAsJsonPrimitive(JSON_VALUE).getAsDouble();
            ms.add(value, time);
        }
        return ms;
    }

    public void compact() {
        Double currentValue = null;
        LinkedList<TimeValue> toRemove = new LinkedList<TimeValue>();
        int count = 0;
        for (TimeValue tv : this.values) {
            if (currentValue == null) {
                currentValue = tv.getValue();
                continue;
            }
            if (Double.compare(currentValue, tv.getValue()) == 0) {
                ++count;
                toRemove.add(tv);
                continue;
            }
            if (count > 0) {
                toRemove.remove(toRemove.size() - 1);
            }
            count = 0;
            currentValue = tv.getValue();
        }
        this.values.removeAll(toRemove);
    }

    public Summary getSummary() {
        Summary summary = new Summary();
        summary.setMaxTime(this.getLatestValue().getTime());
        summary.setMinTime(this.getOldestValue().getTime());
        for (TimeValue tv : this.values) {
            double value = tv.getValue();
            if (value > summary.getMaxValue()) {
                summary.setMaxValue(value);
            }
            if (!(value < summary.getMinValue())) continue;
            summary.setMinValue(value);
        }
        return summary;
    }

    public static class TimeValue {
        final long time;
        final double value;

        public TimeValue(long time, double value) {
            this.time = time;
            this.value = value;
        }

        public long getTime() {
            return this.time;
        }

        public double getValue() {
            return this.value;
        }

        public int hashCode() {
            return (int)this.time;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TimeValue)) {
                return false;
            }
            TimeValue ts = (TimeValue)obj;
            return this.time == ts.time && this.value == ts.value;
        }

        public String toString() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(new Date(this.time)) + "=" + this.value;
        }
    }

    public static class Summary {
        private long minTime = 0L;
        private long maxTime = 0L;
        private double minValue = Double.MAX_VALUE;
        private double maxValue = Double.MIN_VALUE;

        public long getMinTime() {
            return this.minTime;
        }

        public void setMinTime(long minTime) {
            this.minTime = minTime;
        }

        public long getMaxTime() {
            return this.maxTime;
        }

        public void setMaxTime(long maxTime) {
            this.maxTime = maxTime;
        }

        public double getMinValue() {
            return this.minValue;
        }

        public void setMinValue(double minValue) {
            this.minValue = minValue;
        }

        public double getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(double maxValue) {
            this.maxValue = maxValue;
        }
    }
}

