/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.PatternMatchTimeout;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class PatternMatcherThread
implements Callable<PatternMatchResult> {
    protected PatternB pattern;
    protected String text;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(4);

    public PatternMatcherThread(PatternB pattern, String text) {
        this.pattern = pattern;
        this.text = text;
    }

    @Override
    public PatternMatchResult call() throws Exception {
        return this.pattern.matchesR(this.text);
    }

    public static PatternMatchResult match(PatternB pattern, String text) {
        return PatternMatcherThread.match(pattern, text, 5000L);
    }

    public static PatternMatchResult match(PatternB pattern, String text, long timeoutMS) throws PatternMatchTimeout {
        PatternMatchResult pmr = null;
        if (pattern.isMatchAll()) {
            if (pattern.getOvVariables() != null && pattern.getOvVariables().size() == 1) {
                HashMap<String, String> vars = new HashMap<String, String>(2);
                vars.put(pattern.getOvVariables().getFirst(), text);
                pmr = new PatternMatchResult(true, vars);
            } else {
                pmr = PatternMatchResult.TRUE;
            }
        } else {
            PatternMatcherThread pmt = new PatternMatcherThread(pattern, text);
            Future<PatternMatchResult> submit = executorService.submit(pmt);
            try {
                pmr = submit.get(timeoutMS, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                submit.cancel(true);
            }
        }
        return pmr;
    }

    public static void stopPool() {
        executorService.shutdown();
    }
}

