/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.CFI;
import com.blixx.shared.Condition;
import com.blixx.shared.Conditions;
import com.blixx.shared.PatternB;
import com.blixx.shared.exceptions.ConfigException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class Policy
extends AbstractPolicy {
    public static final String EXTERNAL = "EXTERNAL";
    public static final String EXEC = "EXEC";
    public static final String JAVA = "JAVA";
    public static final String FILE = "FILE";
    public static final String NAGIN = "NAGIN";
    public static final String INTERVAL = "INTERVAL";
    public static final String TYPE = "TYPE";
    public static final String RESET = "RESET";
    public static final String CALLTYPE = "CALLTYPE";
    public static final String MONPROG = "MONPROG";
    public static final String MAXTHRESHOLD = "MAXTHRESHOLD";
    public static final String MINTHRESHOLD = "MINTHRESHOLD";
    public static final String MAXONLYCHANGES = "MAXONLYCHANGES";
    public static final String MINONLYCHANGES = "MINONLYCHANGES";
    public static final String STDDEV = "STDDEV";
    public static final String STDDEVMIN = "STDDEVMIN";
    public static final int MAXTHRESHOLD_INT = 1;
    public static final int MINTHRESHOLD_INT = 2;
    public static final int MAXONLYCHANGES_INT = 3;
    public static final int MINONLYCHANGES_INT = 4;
    public static final int STDDEV_INT = 5;
    public static final int STDDEVMIN_INT = 6;
    public static final String PERF_MAP = "PERF_MAP";
    public static final String PERF_ACTIVE = "PERF_ACTIVE";
    public static final String DEFAULT_KEY = "<$HOST>:<$NAME>:<$OBJECT>:<$VALUE>";
    private String type = null;
    private Integer m_type_int = null;
    private boolean reset = true;
    private Conditions conditions = null;
    private String perfmap = "".intern();
    private boolean perfactive = false;
    private Map<PatternB, CFI> perfmapR = null;

    protected Policy() {
    }

    public static Policy createNewPolicy() {
        Policy pol = new Policy();
        pol.policyName = "Monitor_" + System.currentTimeMillis();
        pol.callType = EXEC.intern();
        pol.setType(MAXTHRESHOLD.intern());
        pol.conditions = new Conditions();
        pol.conditions.addCondition(Condition.getNew(0));
        pol.msgkey = DEFAULT_KEY.intern();
        return pol;
    }

    public static Policy createPolicy(String separator, Properties prop, Properties conditionGroup, List<Properties> conditions) throws ConfigException {
        Policy pol = new Policy();
        Policy.fillValues(pol, prop, separator);
        if (pol.callType.equalsIgnoreCase(EXEC) || pol.callType.equalsIgnoreCase(JAVA) || pol.callType.equalsIgnoreCase(FILE)) {
            pol.monprog = prop.getProperty(MONPROG).trim();
        } else if (pol.callType.equalsIgnoreCase(EXTERNAL)) {
            pol.monprog = "".intern();
        } else {
            throw new ConfigException("Unknown CALLTYPE. Must be EXEC | JAVA | EXTERNAL");
        }
        pol.setType(prop.getProperty(TYPE));
        if (!(pol.type != null && (pol.type.equals(MAXTHRESHOLD) || pol.type.equals(MINTHRESHOLD) || pol.type.equals(MAXONLYCHANGES) || pol.type.equals(MINONLYCHANGES) || pol.type.equals(STDDEV) || pol.type.equals(STDDEVMIN)))) {
            throw new ConfigException("Unsupported policy type.");
        }
        try {
            String reset = prop.getProperty(RESET).toUpperCase();
            if (reset.equals("NO")) {
                pol.reset = false;
            }
        }
        catch (Throwable e1) {
            throw new ConfigException("RESET value is not set or invalid");
        }
        pol.perfmap = prop.getProperty(PERF_MAP, "").intern();
        String pa = prop.getProperty(PERF_ACTIVE, "false");
        try {
            pol.perfactive = Boolean.parseBoolean(pa);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        pol.conditions = Conditions.getInstance(conditionGroup, pol.reset, conditions);
        return pol;
    }

    public static Policy getCopy(Policy p) {
        Properties main = p.getMainProperties();
        Properties nMain = new Properties(main);
        String name = nMain.getProperty("NAME");
        nMain.setProperty("NAME", name + "_copy" + System.currentTimeMillis());
        Properties cnds = p.getConditions().getProperties();
        Properties nCnds = new Properties(cnds);
        nCnds.setProperty("CONDITION_ID", UUID.randomUUID().toString());
        List al = p.getConditions().getConditionList();
        ArrayList<Properties> nAl = new ArrayList<Properties>(al.size());
        for (int i = 0; i < al.size(); ++i) {
            Condition c = (Condition)al.get(i);
            Properties cn = c.getProperties();
            Properties nCn = new Properties(cn);
            nCn.putAll((Map<?, ?>)cn);
            nCn.setProperty("CONDITION_ID", UUID.randomUUID().toString());
            nCn.setProperty("HELPTEXT_ID", UUID.randomUUID().toString());
            nAl.add(nCn);
        }
        Policy n = Policy.createPolicy("\u25ba", nMain, cnds, nAl);
        return n;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    @Override
    public Properties getMainProperties() {
        Properties p = super.getMainProperties();
        p.setProperty(INTERVAL, this.intervalStr);
        p.setProperty(TYPE, this.getType());
        if (this.reset) {
            p.setProperty(RESET, "YES");
        } else {
            p.setProperty(RESET, "NO");
        }
        p.setProperty("MSGKEY", this.msgkey == null ? "" : this.msgkey);
        p.setProperty("CLOSEMASK", this.closekey == null ? "" : this.closekey);
        p.setProperty(CALLTYPE, this.callType);
        p.setProperty(MONPROG, this.monprog);
        p.setProperty("SPI", this.spiNAME);
        p.setProperty("VERSION", this.syntax);
        p.setProperty(PERF_MAP, this.perfmap);
        p.setProperty(PERF_ACTIVE, "" + this.perfactive);
        if (this.m_msd_mpm > 0) {
            p.setProperty("MSD_MAX_PER_MINUTE", "" + this.m_msd_mpm);
            p.setProperty("MSD_BLOCK_MINUTES", "" + this.m_msd_bm);
            p.setProperty("MSD_QUARANTINE_MINUTES", "" + this.m_msd_qm);
        }
        return p;
    }

    public boolean isPerfActive() {
        return this.perfactive;
    }

    public Map<PatternB, CFI> getClassMap() {
        if (this.perfmapR == null) {
            this.perfmapR = new HashMap<PatternB, CFI>();
            if (this.perfmap.length() > 0) {
                String[] lines = this.perfmap.split("\\r*\\n");
                for (int i = 0; i < lines.length; ++i) {
                    try {
                        String line = lines[i];
                        int pos = line.indexOf(61);
                        if (pos == -1) continue;
                        String cfi = line.substring(0, pos);
                        CFI o = new CFI(cfi);
                        String pattern = line.substring(pos + 1);
                        PatternB pp = PatternB.getPattern(pattern);
                        this.perfmapR.put(pp, o);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return this.perfmapR;
    }

    public int getTypeInt() {
        if (this.m_type_int == null) {
            this.m_type_int = this.type != null ? (this.type.equalsIgnoreCase(MAXTHRESHOLD) ? Integer.valueOf(1) : (this.type.equalsIgnoreCase(MINTHRESHOLD) ? Integer.valueOf(2) : (this.type.equalsIgnoreCase(MAXONLYCHANGES) ? Integer.valueOf(3) : (this.type.equalsIgnoreCase(MINONLYCHANGES) ? Integer.valueOf(4) : (this.type.equalsIgnoreCase(STDDEV) ? Integer.valueOf(5) : (this.type.equalsIgnoreCase(STDDEVMIN) ? Integer.valueOf(6) : Integer.valueOf(1))))))) : Integer.valueOf(1);
        }
        return this.m_type_int;
    }

    public ArrayList<Condition> getConditionsForObject(String object, Map<String, String> addVariablesHere) {
        ArrayList<Condition> listByObject = new ArrayList<Condition>();
        for (int i = 0; i < this.getConditions().getConditionCount(); ++i) {
            Condition cT = (Condition)this.getConditions().getCondition(i);
            if (!"<*>".equals(cT.object) && !cT.isObjectMatch(object, addVariablesHere)) continue;
            listByObject.add(cT);
        }
        return listByObject;
    }

    public Condition getSeverity(double value, String object, Map<String, String> addVariablesHere, List<Condition> ifResetSelected) {
        if (Double.isNaN(value)) {
            return null;
        }
        Condition creset = null;
        Condition c = null;
        ArrayList<Object> listByObject = new ArrayList(this.getConditions().getConditionList());
        listByObject = object != null && object.length() > 0 ? this.getConditionsForObject(object, addVariablesHere) : this.getConditionsForObject("<*>", addVariablesHere);
        int size = listByObject.size();
        for (int i = 0; i < size; ++i) {
            c = (Condition)listByObject.get(i);
            if (this.getTypeInt() == 1 || this.getTypeInt() == 3 || this.getTypeInt() == 5) {
                if (value >= c.threshold) {
                    return c;
                }
                if (c.ignoreReset || !this.reset) {
                    creset = null;
                    continue;
                }
                if (value <= c.reset) {
                    if (i < size - 1) {
                        creset = (Condition)listByObject.get(i + 1);
                        continue;
                    }
                    creset = null;
                    continue;
                }
                if (i < size - 1) {
                    ifResetSelected.add((Condition)listByObject.get(i + 1));
                }
                return c;
            }
            if (this.getTypeInt() == 2 || this.getTypeInt() == 4 || this.getTypeInt() == 6) {
                if (value <= c.threshold) {
                    return c;
                }
                if (c.ignoreReset || !this.reset) continue;
                if (value >= c.reset) {
                    if (i < size - 1) {
                        creset = (Condition)listByObject.get(i + 1);
                        continue;
                    }
                    creset = null;
                    continue;
                }
                if (i < size - 1) {
                    ifResetSelected.add((Condition)listByObject.get(i + 1));
                }
                return c;
            }
            return c;
        }
        return creset;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.m_type_int = null;
    }

    public boolean isReset() {
        return this.reset;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    @Override
    public String getPolicyType() {
        return "mon";
    }
}

