/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.IODataStream;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.Map;

public class UserRight
implements IODataStream {
    public static final int RIGHT_INDICATION = 1000;
    public static final int RIGHT_POLICIES = 1001;
    public static final int RIGHT_NODES = 1002;
    public static final int RIGHT_PERFVIEW = 1003;
    public static final int RIGHT_USERMGMT = 1004;
    public static final int RIGHT_REMOTEACTIONS = 1005;
    public static final int RIGHT_BINARIES = 1006;
    public static final int RIGHT_ACTIONS = 1007;
    public static final int RIGHT_ASSIGNMENTS = 1008;
    public static final int RIGHT_SERVERFILTERS = 1009;
    public static final int RIGHT_SERVICETREE = 1010;
    public static final int RIGHT_SERVICEDASHBOARD = 2001;
    public static final int RIGHT_LOCAL_SERVICEDASHBOARD = 2002;
    public static final int RIGHT_SERVERJOBS = 2003;
    public static final int RIGHT_SERVERCONFIG = 2004;
    public static final int RIGHT_OUTAGE_POLICIES = 2010;
    public static final int RIGHT_AGENTOUTAGES = 2011;
    public static final int RIGHT_MODIFYPOLICIES = 2012;
    public static final int RIGHT_NOTIFICATION_INTERFACES = 2014;
    public static final int RIGHT_EXTENDED_AGENT_ATTRIBUTES = 2015;
    public static final int RIGHT_MAINTENANCE_INDICATIONS = 2016;
    public static final int UNKNOWN = 0;
    public static final int DISABLED = 1;
    public static final int GUEST = 2;
    public static final int OWNER = 3;
    public static final String DISABLED_STR = "DISABLED";
    public static final String GUEST_STR = "GUEST";
    public static final String OWNER_STR = "OWNER";
    public static final String ROLE_ID = "ROLE_ID";
    public static final String ITEM_ID = "ITEM_ID";
    private String roleID = null;
    private int itemID = 0;
    private int level = 0;

    UserRight() {
    }

    public UserRight(String roleID, int itemID, int level) {
        this.roleID = roleID;
        this.itemID = itemID;
        this.level = level;
    }

    public UserRight(Map m) {
        this.roleID = (String)m.get(ROLE_ID);
        this.itemID = Integer.valueOf(String.valueOf(m.get(ITEM_ID)));
        Object o = m.get(DISABLED_STR);
        int dis = 0;
        int gue = 0;
        int own = 0;
        if (!(o instanceof Boolean)) {
            dis = Integer.valueOf(String.valueOf(m.get(DISABLED_STR)));
            gue = Integer.valueOf(String.valueOf(m.get(GUEST_STR)));
            own = Integer.valueOf(String.valueOf(m.get(OWNER_STR)));
        } else {
            Boolean b = (Boolean)m.get(DISABLED_STR);
            if (b.booleanValue()) {
                dis = 1;
            }
            if ((b = (Boolean)m.get(GUEST_STR)).booleanValue()) {
                gue = 1;
            }
            if ((b = (Boolean)m.get(OWNER_STR)).booleanValue()) {
                own = 1;
            }
        }
        if (dis == 1) {
            this.level = 1;
        } else if (gue == 1) {
            this.level = 2;
        } else if (own == 1) {
            this.level = 3;
        }
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        this.roleID = dis.readUTF();
        this.itemID = dis.readInt();
        this.level = dis.readInt();
        return this;
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        dos.writeUTF(this.roleID);
        dos.writeInt(this.itemID);
        dos.writeInt(this.level);
    }

    public String getRoleID() {
        return this.roleID;
    }

    public int getItemID() {
        return this.itemID;
    }
}

