/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ServerPolicyTemplate;
import com.blixx.shared.ext.TimeInterval;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.StrUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AgentOutagePolicy
extends ServerPolicyTemplate {
    public static String ID = "ID";
    public static String AGENTID = "AGENTID";
    public static String PATTERNS = "PATTERNS";
    public static String STARTTIME = "STARTTIME";
    public static String EXPDURATION = "EXPDURATION";
    public static String ENDTIME = "ENDTIME";
    public static String ENABLED = "ENABLED";
    public static String DISABLEDBY = "DISABLEDBY";
    public static String ACTION = "ACTION";
    public static String POSTACTION = "POSTACTION";
    public static String INTERVAL = "INTERVAL";
    private String m_agentID = null;

    public AgentOutagePolicy() {
    }

    public AgentOutagePolicy(Map<String, Object> row) {
        this.m_UUID = (String)row.get(ID);
        this.m_agentID = (String)row.get(AGENTID);
        String patterns = (String)row.get(PATTERNS);
        List<ForwardFilter> list = AgentOutagePolicy.parseFilters(patterns);
        this.addFilters(list);
        long start = this.getLong(row.get(STARTTIME));
        Object ivl = row.get(INTERVAL);
        long interval = Long.MAX_VALUE;
        if (ivl != null) {
            interval = this.getLong(ivl);
        }
        try {
            this.m_timeInterval = new TimeInterval(start, interval);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_expectedDuration = this.getLong(row.get(EXPDURATION));
        this.m_isDisableTime = this.getLong(row.get(ENDTIME));
        Object enObj = row.get(ENABLED);
        if (enObj instanceof Boolean) {
            this.m_enabled.set((Boolean)enObj);
        } else if (enObj instanceof Integer) {
            int enInt = (Integer)enObj;
            this.m_enabled.set(enInt == 1);
        } else if (enObj instanceof Long) {
            this.m_enabled.set((Long)enObj == 1L);
        } else if (enObj instanceof Number) {
            this.m_enabled.set(((Number)enObj).intValue() == 1);
        } else {
            String en = String.valueOf(enObj);
            this.m_enabled.set("1".equals(en));
        }
        this.m_enabledBy = "Agent:" + this.m_agentID;
        this.m_disabledBy = (String)row.get(DISABLEDBY);
        this.m_action = this.getInt(row.get(ACTION));
        this.m_postAction = this.getInt(row.get(POSTACTION));
    }

    public String getAgentID() {
        return this.m_agentID;
    }

    public void setAgentID(String m_agentID) {
        this.m_agentID = m_agentID;
    }

    public static List<ForwardFilter> parseFilters(String patterns) {
        StrUtils su = new StrUtils();
        LinkedList<ForwardFilter> res = new LinkedList<ForwardFilter>();
        String[] farr = patterns.split("\r*\n");
        for (int i = 0; i < farr.length; ++i) {
            String f = farr[i];
            int pos = f.indexOf(61);
            if (pos == -1) continue;
            Properties p = new Properties();
            p.setProperty("FILTER_NUMBER", "" + i);
            p.setProperty("ATTRIBUTE", f.substring(0, pos));
            p.setProperty("PATTERN", su.removeQuotesStrict(f.substring(pos + 1)));
            p.setProperty("NAME", "");
            ForwardFilter ff = ForwardFilter.getInstance(p);
            res.add(ff);
        }
        return res;
    }

    public AgentOutagePolicy(String id, String agentid, long startTime, long expectedDuration, long interval, boolean enable, List<ForwardFilter> filters) throws Exception {
        this.m_UUID = id;
        this.m_agentID = agentid;
        this.m_filters = filters;
        this.m_timeInterval = new TimeInterval(startTime, interval);
        this.setExpectedDuration(expectedDuration);
        this.setEnabledByAgent();
    }

    protected void setEnabledByAgent() {
        this.setEnabled("Agent:" + this.m_agentID);
    }

    public void setDisabledByAgent() {
        int eventCode = 5;
        switch (this.m_postAction) {
            case 5: {
                eventCode = 7;
                break;
            }
            case 1: {
                eventCode = 6;
                break;
            }
        }
        this.setDisabled("Agent:" + this.m_agentID, eventCode);
    }

    @Override
    public Object read(SDataInputStream is) throws IOException {
        super.read(is);
        this.m_agentID = is.readUTF();
        return this;
    }

    @Override
    public void send(SDataOutputStream os) throws IOException {
        super.send(os);
        os.writeUTF(this.m_agentID);
    }

    protected long getLong(Object o) {
        long val = o instanceof Long ? (Long)o : (o instanceof Number ? ((Number)o).longValue() : Long.parseLong(String.valueOf(o)));
        return val;
    }

    protected int getInt(Object o) {
        int val = o instanceof Integer ? (Integer)o : (o instanceof Number ? ((Number)o).intValue() : Integer.parseInt(String.valueOf(o)));
        return val;
    }

    public String getFiltersAsString() {
        StringBuilder sb = new StringBuilder();
        for (ForwardFilter ff : this.m_filters) {
            sb.append(ForwardFilter.getAttributeName(ff.getType())).append('=').append(ff.getPatternB()).append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ID=").append(this.m_UUID).append(' ').append("AgentID=").append(this.m_agentID).append(' ').append("Enabled=").append(this.m_enabled.get()).append(' ').append("Action=").append(AgentOutagePolicy.getActionLabel(this.m_action)).append(' ').append("PostAction=").append(AgentOutagePolicy.getActionLabel(this.m_action)).append(' ').append("ExpectedDuration=").append(this.m_expectedDuration).append(' ').append("Filters=").append(this.getFiltersAsString());
        return super.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AgentOutagePolicy)) {
            return false;
        }
        AgentOutagePolicy ap = (AgentOutagePolicy)obj;
        return this.m_agentID == null ? ap.m_agentID == null : this.m_agentID.equals(ap.m_agentID) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.m_agentID == null ? 0 : this.m_agentID.hashCode());
    }

    public boolean equals4UserAdHoc(ServerPolicyTemplate sp) {
        if (!(sp instanceof AgentOutagePolicy)) {
            return false;
        }
        AgentOutagePolicy ap = (AgentOutagePolicy)sp;
        return (this.m_agentID == null ? ap.m_agentID == null : this.m_agentID.equals(ap.m_agentID)) && Arrays.equals(this.m_filters.toArray(), sp.m_filters.toArray());
    }
}

