/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.Interval;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ModifyServerPolicy;
import com.blixx.shared.ext.NodeGroupForwardFilter;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.DiffComparable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class ExtendedServerPolicy
extends ModifyServerPolicy {
    protected boolean insertAsClosed = false;
    protected Map<String, String> setCustomAttributes = null;
    protected boolean await = false;
    protected boolean awaitDropOriginal = false;
    protected boolean awaitAcknowledge = false;
    protected boolean awaitInsertAsClosed = false;
    protected String awaitInterval = "";
    protected String awaitSetText = "";
    protected String setKey = "";
    protected String setCloseMask = "";
    protected String setAutoAction = "";
    protected String setAutoActionNode = "";
    protected int setAutoActionTimeoutSec = 120;
    protected boolean overwriteAvOrKpi = false;
    protected boolean avFlag = false;
    protected boolean kpiFlag = false;
    protected boolean overwriteDeDuplication = false;
    protected boolean deduplicate = true;
    protected boolean deduplicateKeyOnly = false;
    protected List<ForwardFilter> nodeGroupFilters = new ArrayList<ForwardFilter>(0);
    protected transient long runtimeAwaitIntervalMillis = 0L;
    protected transient Map<String, Long> agent2ExpireTime = null;

    public ExtendedServerPolicy(ModifyServerPolicy mp) {
        super(mp);
        this.awaitInterval = null;
        this.awaitSetText = "";
        this.setCustomAttributes = null;
        this.await = false;
        this.awaitDropOriginal = false;
        this.awaitAcknowledge = false;
        this.awaitInsertAsClosed = false;
        this.insertAsClosed = false;
        this.runtimeAwaitIntervalMillis = 0L;
    }

    public ExtendedServerPolicy(String uuid, String name) {
        super(uuid, name);
    }

    @Override
    public Object read(SDataInputStream is) throws IOException {
        super.read(is);
        this.insertAsClosed = is.readBoolean();
        this.await = is.readBoolean();
        this.awaitDropOriginal = is.readBoolean();
        this.awaitAcknowledge = is.readBoolean();
        this.awaitInterval = is.readUTF();
        this.awaitSetText = is.readUTF();
        this.awaitInsertAsClosed = is.readBoolean();
        this.setKey = is.readUTF();
        this.setCloseMask = is.readUTF();
        this.setAutoAction = is.readUTF();
        this.setAutoActionNode = is.readUTF();
        this.deduplicate = is.readBoolean();
        this.deduplicateKeyOnly = is.readBoolean();
        this.setAutoActionTimeoutSec = is.readInt();
        this.overwriteAvOrKpi = is.readBoolean();
        this.overwriteDeDuplication = is.readBoolean();
        this.avFlag = is.readBoolean();
        this.kpiFlag = is.readBoolean();
        while (is.readBoolean()) {
            int countProps = is.readInt();
            Properties prop = new Properties();
            for (int i = 0; i < countProps; ++i) {
                String key = is.readUTF();
                String value = is.readUTF();
                prop.setProperty(key, value);
            }
            try {
                ForwardFilter ff = ForwardFilter.getInstance(prop);
                this.nodeGroupFilters.add(ff);
            }
            catch (Exception e) {
                RTLogger.print(2, "Invalid NGFilter: " + String.valueOf(prop), e);
            }
        }
        while (is.readBoolean()) {
            if (this.setCustomAttributes == null) {
                this.setCustomAttributes = new HashMap<String, String>(2);
            }
            String caName = is.readUTF();
            String value = is.readUTF();
            this.setCustomAttributes.put(caName, value);
        }
        while (is.readBoolean()) {
            is.readUTF();
        }
        return this;
    }

    @Override
    public void send(SDataOutputStream os) throws IOException {
        super.send(os);
        os.writeBoolean(this.insertAsClosed);
        os.writeBoolean(this.await);
        os.writeBoolean(this.awaitDropOriginal);
        os.writeBoolean(this.awaitAcknowledge);
        os.writeUTF(this.awaitInterval);
        os.writeUTF(this.awaitSetText);
        os.writeBoolean(this.awaitInsertAsClosed);
        os.writeUTF(this.setKey);
        os.writeUTF(this.setCloseMask);
        os.writeUTF(this.setAutoAction);
        os.writeUTF(this.setAutoActionNode);
        os.writeBoolean(this.deduplicate);
        os.writeBoolean(this.deduplicateKeyOnly);
        os.writeInt(this.setAutoActionTimeoutSec);
        os.writeBoolean(this.overwriteAvOrKpi);
        os.writeBoolean(this.overwriteDeDuplication);
        os.writeBoolean(this.avFlag);
        os.writeBoolean(this.kpiFlag);
        Iterator<ForwardFilter> it = this.getNodeGroupFilters().iterator();
        os.writeBoolean(it.hasNext());
        while (it.hasNext()) {
            ForwardFilter forwardFilter = it.next();
            Properties p = forwardFilter.getProperties();
            os.writeInt(p.size());
            for (Map.Entry<Object, Object> en : p.entrySet()) {
                String key = (String)en.getKey();
                String value = (String)en.getValue();
                if (value == null) {
                    value = "";
                }
                os.writeUTF(key);
                os.writeUTF(value);
            }
            os.writeBoolean(it.hasNext());
        }
        if (this.setCustomAttributes != null && this.setCustomAttributes.size() > 0) {
            for (Map.Entry<String, String> en : this.setCustomAttributes.entrySet()) {
                os.writeBoolean(true);
                os.writeUTF(en.getKey());
                os.writeUTF(en.getValue());
            }
            os.writeBoolean(false);
        } else {
            os.writeBoolean(false);
        }
        os.writeBoolean(false);
    }

    public boolean isInsertAsClosed() {
        return this.insertAsClosed;
    }

    public void setInsertAsClosed(boolean insertAsClosed) {
        this.insertAsClosed = insertAsClosed;
    }

    public Map<String, String> getCAs() {
        return this.setCustomAttributes;
    }

    public void addCAs(String caName, String value) {
        if (this.setCustomAttributes == null) {
            this.setCustomAttributes = new HashMap<String, String>(2);
        }
        this.setCustomAttributes.put(caName, value);
    }

    public String getCA(String caName) {
        return this.setCustomAttributes == null ? null : this.setCustomAttributes.get(caName);
    }

    public boolean isAwait() {
        return this.await;
    }

    public void setAwait(boolean createNewIndi) {
        this.await = createNewIndi;
    }

    public boolean isAwaitAcknowlede() {
        return this.awaitAcknowledge;
    }

    public void setAwaitAcknowledge(boolean doAcknowlede) {
        this.awaitAcknowledge = doAcknowlede;
    }

    public String getAwaitInterval() {
        return this.awaitInterval;
    }

    public void setAwaitInterval(String awaitInterval) {
        this.awaitInterval = awaitInterval;
    }

    private void resetRuntimeAwaitIntervalMillis() {
        this.runtimeAwaitIntervalMillis = 0L;
    }

    public long getRuntimeAwaitIntervalMillis() {
        if (this.await && this.runtimeAwaitIntervalMillis == 0L) {
            this.runtimeAwaitIntervalMillis = Interval.parseInterval(this.awaitInterval, -1).getIntervalMilliseconds();
            if (this.runtimeAwaitIntervalMillis < 1000L) {
                this.setDisabled("Server detects invalid interval");
            }
        }
        return this.runtimeAwaitIntervalMillis;
    }

    public String getAwaitSetText() {
        return this.awaitSetText;
    }

    public void setAwaitSetText(String awaitSetText) {
        this.awaitSetText = awaitSetText;
    }

    public boolean isAwaitInsertAsClosed() {
        return this.awaitInsertAsClosed;
    }

    public void setAwaitInsertAsClosed(boolean awaitInsertAsClosed) {
        this.awaitInsertAsClosed = awaitInsertAsClosed;
    }

    public boolean isAwaitDropOriginal() {
        return this.awaitDropOriginal;
    }

    public void setAwaitDropOriginal(boolean dropOriginal) {
        this.awaitDropOriginal = dropOriginal;
    }

    @Override
    public void updateFrom(OutagePolicy sp) {
        super.updateFrom(sp);
        if (sp instanceof ExtendedServerPolicy) {
            ExtendedServerPolicy ep = (ExtendedServerPolicy)sp;
            this.insertAsClosed = ep.insertAsClosed;
            this.await = ep.await;
            this.awaitDropOriginal = ep.awaitDropOriginal;
            this.awaitAcknowledge = ep.awaitAcknowledge;
            if (!Objects.equals(this.awaitInterval, ep.awaitInterval)) {
                this.agent2ExpireTime = null;
            }
            this.awaitInterval = ep.awaitInterval;
            this.awaitSetText = ep.awaitSetText;
            this.awaitInsertAsClosed = ep.awaitInsertAsClosed;
            this.setKey = ep.setKey;
            this.setCloseMask = ep.setCloseMask;
            this.setAutoAction = ep.setAutoAction;
            this.setAutoActionNode = ep.setAutoActionNode;
            this.deduplicate = ep.deduplicate;
            this.deduplicateKeyOnly = ep.deduplicateKeyOnly;
            this.setAutoActionTimeoutSec = ep.setAutoActionTimeoutSec;
            this.overwriteAvOrKpi = ep.overwriteAvOrKpi;
            this.overwriteDeDuplication = ep.overwriteDeDuplication;
            this.avFlag = ep.avFlag;
            this.kpiFlag = ep.kpiFlag;
            this.nodeGroupFilters = ep.getNodeGroupFilters();
            this.setCustomAttributes = ep.getCAs();
            this.rebuildAgent2TimeRtMap();
        }
    }

    @Override
    public int hashCode() {
        return this.m_name == null ? 0 : this.m_name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        boolean eq = false;
        if (obj instanceof ExtendedServerPolicy && (eq = super.equals(obj))) {
            ExtendedServerPolicy other = (ExtendedServerPolicy)obj;
            boolean bl = (this.awaitInterval == null ? other.awaitInterval == null : this.awaitInterval.equals(other.awaitInterval)) && (this.awaitSetText == null ? other.awaitSetText == null : this.awaitSetText.equals(other.awaitSetText)) && this.await == other.await && this.awaitDropOriginal == other.awaitDropOriginal && this.awaitAcknowledge == other.awaitAcknowledge && this.insertAsClosed == other.insertAsClosed && this.runtimeAwaitIntervalMillis == other.runtimeAwaitIntervalMillis && (this.setKey == null ? other.setKey == null : this.setKey.equals(other.setKey)) && (this.setCloseMask == null ? other.setCloseMask == null : this.setCloseMask.equals(other.setCloseMask)) && (this.setAutoAction == null ? other.setAutoAction == null : this.setAutoAction.equals(other.setAutoAction)) && (this.setAutoActionNode == null ? other.setAutoActionNode == null : this.setAutoActionNode.equals(other.setAutoActionNode)) && this.deduplicate == other.deduplicate && this.deduplicateKeyOnly == other.deduplicateKeyOnly && this.setAutoActionTimeoutSec == other.setAutoActionTimeoutSec && this.overwriteAvOrKpi == other.overwriteAvOrKpi && this.overwriteDeDuplication == other.overwriteDeDuplication && this.avFlag == other.avFlag && this.kpiFlag == other.kpiFlag ? true : (eq = false);
            if (eq) {
                int size = this.setCustomAttributes == null ? 0 : this.setCustomAttributes.size();
                int otherSize = other.setCustomAttributes == null ? 0 : other.setCustomAttributes.size();
                boolean bl2 = eq = size == otherSize;
                if (eq && size > 0) {
                    for (Map.Entry<String, String> en : this.setCustomAttributes.entrySet()) {
                        String otherValue = other.setCustomAttributes.get(en.getKey());
                        eq = en.getValue() == null ? otherValue == null : en.getValue().equals(otherValue);
                        if (eq) continue;
                        break;
                    }
                }
                if (eq && this.nodeGroupFilters.size() == other.nodeGroupFilters.size()) {
                    for (int i = 0; i < this.nodeGroupFilters.size(); ++i) {
                        ForwardFilter f1 = this.nodeGroupFilters.get(i);
                        ForwardFilter f2 = other.nodeGroupFilters.get(i);
                        if (f1 == null && f2 == null) continue;
                        try {
                            if (f1 != null && f2 != null && f1.m_attribute == f2.m_attribute && f1.m_pattern.equals(f2.m_pattern)) continue;
                            return false;
                        }
                        catch (Throwable e) {
                            return false;
                        }
                    }
                }
            }
        }
        return eq;
    }

    public String getSetKey() {
        return this.setKey;
    }

    public void setSetKey(String setKey) {
        this.setKey = setKey;
    }

    public String getSetCloseMask() {
        return this.setCloseMask;
    }

    public void setSetCloseMask(String setCloseMask) {
        this.setCloseMask = setCloseMask;
    }

    public void addNodeGroupFilter(NodeGroupForwardFilter f) {
        this.nodeGroupFilters.add(f);
    }

    public List<ForwardFilter> getNodeGroupFilters() {
        return this.nodeGroupFilters;
    }

    public void setNodeGroupFilters(List<ForwardFilter> nodeGroupFilters) {
        this.nodeGroupFilters = nodeGroupFilters;
    }

    public String getSetAutoAction() {
        return this.setAutoAction;
    }

    public void setSetAutoAction(String setAutoAction) {
        this.setAutoAction = setAutoAction;
    }

    public String getSetAutoActionNode() {
        return this.setAutoActionNode;
    }

    public void setSetAutoActionNode(String setAutoActionNode) {
        this.setAutoActionNode = setAutoActionNode;
    }

    public boolean isDeduplicate() {
        return this.deduplicate;
    }

    public void setDeduplicate(boolean deduplicate) {
        this.deduplicate = deduplicate;
    }

    public boolean isDeduplicateKeyOnly() {
        return this.deduplicateKeyOnly;
    }

    public void setDeduplicateKeyOnly(boolean deduplicateKeyOnly) {
        this.deduplicateKeyOnly = deduplicateKeyOnly;
    }

    public int getSetAutoActionTimeoutSec() {
        return this.setAutoActionTimeoutSec;
    }

    public void setSetAutoActionTimeoutSec(int setAutoActionTimeoutSec) {
        this.setAutoActionTimeoutSec = setAutoActionTimeoutSec;
    }

    public boolean isAV() {
        return this.avFlag;
    }

    public void setAV(boolean aV) {
        this.avFlag = aV;
    }

    public boolean isKPI() {
        return this.kpiFlag;
    }

    public void setKPI(boolean kPI) {
        this.kpiFlag = kPI;
    }

    public boolean isOverwriteAV_KPI() {
        return this.overwriteAvOrKpi;
    }

    public void setOverwriteAV_KPI(boolean overwriteAVKPI) {
        this.overwriteAvOrKpi = overwriteAVKPI;
    }

    public boolean isOverwriteDeDuplication() {
        return this.overwriteDeDuplication;
    }

    public void setOverwriteDeDuplication(boolean overwriteDeDuplication) {
        this.overwriteDeDuplication = overwriteDeDuplication;
    }

    public void rebuildAgent2TimeRtMap() {
        this.resetRuntimeAwaitIntervalMillis();
        if (this.agent2ExpireTime == null) {
            this.getAgent2ExpireTime();
        } else {
            HashSet<String> mapNow = new HashSet<String>();
            for (ForwardFilter ff : this.nodeGroupFilters) {
                if (!(ff instanceof NodeGroupForwardFilter)) continue;
                NodeGroupForwardFilter ngff = (NodeGroupForwardFilter)ff;
                mapNow.addAll(ngff.getAllAgentIDs().keySet());
            }
            DiffComparable<String> idDiff = new DiffComparable<String>(mapNow, this.agent2ExpireTime.keySet());
            this.agent2ExpireTime.keySet().removeAll(idDiff.deletedObjects.keySet());
            for (String id : idDiff.newObjects.keySet()) {
                this.setNextExpire(id);
            }
            for (String id : idDiff.updated.keySet()) {
                this.setNextExpire(id);
            }
        }
    }

    public void setNextExpire(String id) {
        this.agent2ExpireTime.put(id, System.currentTimeMillis() + this.getRuntimeAwaitIntervalMillis());
    }

    public Map<String, Long> getAgent2ExpireTime() {
        if (this.agent2ExpireTime == null) {
            this.agent2ExpireTime = new ConcurrentHashMap<String, Long>();
            for (ForwardFilter ff : this.nodeGroupFilters) {
                if (!(ff instanceof NodeGroupForwardFilter)) continue;
                NodeGroupForwardFilter ngff = (NodeGroupForwardFilter)ff;
                for (String agentID : ngff.getAllAgentIDs().keySet()) {
                    this.setNextExpire(agentID);
                }
            }
        }
        return this.agent2ExpireTime;
    }

    public List<String> checkNodeGroupsAndApplyTime(SEventFwd sef) {
        ArrayList<String> matchedAgentIDs = new ArrayList<String>(2);
        Map<String, Long> agent2TimeRtMap = this.getAgent2ExpireTime();
        if (agent2TimeRtMap.containsKey(sef.getT1())) {
            this.setNextExpire(sef.getT1());
            matchedAgentIDs.add(sef.getT1());
        }
        for (ForwardFilter ff : this.nodeGroupFilters) {
            if (!(ff instanceof NodeGroupForwardFilter)) continue;
            NodeGroupForwardFilter ngff = (NodeGroupForwardFilter)ff;
            List<? extends AbstractAgentCard> externalHosts = ngff.getExternalHosts(sef.getNode());
            for (AbstractAgentCard abstractAgentCard : externalHosts) {
                if (!agent2TimeRtMap.containsKey(abstractAgentCard.getAgentID())) continue;
                this.setNextExpire(abstractAgentCard.getAgentID());
                matchedAgentIDs.add(abstractAgentCard.getAgentID());
            }
        }
        return matchedAgentIDs;
    }
}

