/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.shared.IID;
import com.blixx.shared.exceptions.ConfigException;
import com.blixx.shared.ext.ForwardCondition;
import com.blixx.shared.ext.ForwardConditions;
import com.blixx.shared.ext.ForwardFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public class ForwardPolicy
implements Comparable<ForwardPolicy>,
IID {
    public static String NAME = "NAME";
    public static String DESCRIPTION = "DESCRIPTION";
    public static String POLICY_VERSION = "POLICY_VERSION";
    public static String FILTER_LIST = "FILTER_LIST";
    public static String IS_ACTIVE = "IS_ACTIVE";
    public String syntax = null;
    public String policy_version = "1.0";
    public String separator = null;
    public String policyName = null;
    public String description = null;
    public List<Integer> m_filters = new ArrayList<Integer>();
    protected volatile ArrayList<Integer> m_filterTypes = new ArrayList();
    public ForwardConditions conditions = null;
    public AtomicBoolean isActive = new AtomicBoolean(true);

    public ForwardPolicy() {
    }

    public ForwardPolicy(String sep, Properties pr, Properties cGroup, List<Properties> cs) {
        this.policyName = pr.getProperty(NAME);
        String isActiveStr = pr.getProperty(IS_ACTIVE);
        if (isActiveStr != null && isActiveStr.equalsIgnoreCase("FALSE")) {
            this.isActive.set(false);
        }
        if (this.policyName == null) {
            throw new ConfigException("Msg policy has no name.");
        }
        this.description = pr.getProperty(DESCRIPTION);
        this.policy_version = pr.getProperty(POLICY_VERSION);
        this.separator = sep;
        String filters = pr.getProperty(FILTER_LIST);
        if (filters != null && filters.trim().length() > 0) {
            String[] ints = filters.split(",");
            for (int i = 0; i < ints.length; ++i) {
                Integer fNumber = Integer.valueOf(ints[i].trim());
                this.m_filters.add(fNumber);
            }
            Collections.sort(this.m_filters);
        }
        this.syntax = pr.getProperty("VERSION");
        this.conditions = ForwardConditions.getInstance(cGroup, cs);
    }

    public static ForwardPolicy createNewForwardPolicy(String name) {
        if (name == null || name.length() == 0) {
            name = "ServerFilter_";
        }
        ForwardPolicy fpol = new ForwardPolicy();
        fpol.policyName = name + System.currentTimeMillis();
        fpol.isActive.set(false);
        fpol.description = "";
        fpol.policy_version = "1.0";
        fpol.separator = "\u25ba";
        fpol.syntax = "1.0";
        fpol.m_filters.clear();
        fpol.conditions = ForwardConditions.getNew();
        return fpol;
    }

    public static ForwardPolicy getDuplicate(ForwardPolicy ff) {
        ForwardPolicy dup = new ForwardPolicy();
        dup.policyName = ff.policyName;
        dup.isActive = ff.isActive;
        dup.description = ff.description;
        dup.policy_version = ff.syntax;
        dup.separator = "\u25ba";
        dup.syntax = ff.syntax;
        dup.m_filters = new ArrayList<Integer>();
        dup.m_filters.addAll(ff.m_filters);
        dup.conditions = ff.getConditions();
        return dup;
    }

    public List<String> getAllUsers() {
        LinkedList<String> users = new LinkedList<String>();
        for (ForwardCondition fc : this.conditions.getConditionList()) {
            if (!fc.type.equals(ForwardCondition.TYPE_USERS)) continue;
            String userList = fc.to;
            String[] usArr = userList.split(",");
            for (int i = 0; i < usArr.length; ++i) {
                String u = usArr[i].trim();
                if (users.contains(u)) continue;
                users.add(u);
            }
        }
        return users;
    }

    public ForwardConditions getConditions() {
        return this.conditions;
    }

    public Properties getMainProperties() {
        Properties p = new Properties();
        p.setProperty(NAME, this.policyName);
        p.setProperty(IS_ACTIVE, String.valueOf(this.isActive));
        p.setProperty(POLICY_VERSION, this.policy_version);
        p.setProperty(DESCRIPTION, this.description);
        String aaa = this.m_filters.toString();
        aaa = aaa.replace("[", "");
        aaa = aaa.replace("]", "");
        aaa = aaa.replace(" ", "");
        p.setProperty(FILTER_LIST, aaa);
        return p;
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public void setActive(boolean activate) {
        this.isActive.set(activate);
    }

    public void addFilter(List<ForwardFilter> filterList) {
        for (int i = 0; i < filterList.size(); ++i) {
            if (this.m_filters.contains(filterList.get(i).getNumber())) continue;
            this.m_filters.add(filterList.get(i).getNumber());
        }
    }

    public void updateFilter(ForwardFilter ff) {
        if (this.m_filters.contains(ff.getNumber())) {
            this.m_filters.remove(ff.getNumber());
            this.m_filters.add(ff.getNumber());
        }
    }

    public void removeFilters(ArrayList<ForwardFilter> filterList) {
        for (int i = 0; i < filterList.size(); ++i) {
            if (!this.m_filters.contains(filterList.get(i).getNumber())) continue;
            this.m_filters.remove(filterList.get(i).getNumber());
        }
    }

    public ForwardCondition addNewCondition() {
        return this.conditions.addNewCondition(null);
    }

    public void removeCondition(ForwardCondition fc) {
        this.conditions.removeCondition(fc);
    }

    @Override
    public int compareTo(ForwardPolicy o) {
        return this.policyName.compareTo(o.policyName);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ForwardPolicy) {
            if (this.policyName == null) {
                return ((ForwardPolicy)obj).policyName == null;
            }
            return this.policyName.equals(((ForwardPolicy)obj).policyName);
        }
        return false;
    }

    public int hashCode() {
        return this.policyName.hashCode();
    }

    public boolean hasType(Integer type) {
        return this.m_filterTypes.contains(type);
    }

    public List<Integer> getFilters() {
        return new ArrayList<Integer>(this.m_filters);
    }

    public void clearFilterTypes() {
        if (this.m_filterTypes != null) {
            this.m_filterTypes.clear();
        }
    }

    @Override
    public String getID() {
        return this.policyName;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    public String getPolicy_version() {
        return this.policy_version;
    }

    public void setPolicy_version(String policyVersion) {
        this.policy_version = policyVersion;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList<Integer> getFilterTypes() {
        return this.m_filterTypes;
    }

    public void setFilterTypes(ArrayList<Integer> filterTypes) {
        this.m_filterTypes = filterTypes;
    }

    public void addFilterType(Integer filterType) {
        if (this.m_filterTypes == null) {
            this.m_filterTypes = new ArrayList(4);
        }
        this.m_filterTypes.add(filterType);
    }

    public AtomicBoolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(AtomicBoolean isActive) {
        this.isActive = isActive;
    }

    public void setFilters(List<Integer> filters) {
        this.m_filters = filters;
    }

    public void setConditions(ForwardConditions conditions) {
        this.conditions = conditions;
    }

    public boolean isUserPolicy() {
        boolean isUserPolicy = false;
        for (ForwardCondition fc : this.getConditions().getConditionList()) {
            if (!ForwardCondition.TYPE_USERS.equals(fc.type)) continue;
            return true;
        }
        return isUserPolicy;
    }

    public boolean isUserPolicyValid() {
        ArrayList<ForwardCondition> fclist = this.getConditions().getConditionList();
        return fclist.size() == 1 && ForwardCondition.TYPE_USERS.equals(((ForwardCondition)fclist.get((int)0)).type);
    }
}

