/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.shared.IODataStream;
import com.blixx.shared.ext.ServerPolicyTemplate;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ServerPolicyStatus
implements IODataStream {
    public static int ACCESS_INVISIBLE = 0;
    public static int ACCESS_READONLY = 1;
    public static int ACCESS_ENABLE_DISABLE = 2;
    public static int ACCESS_EDIT_DELETE = 3;
    public boolean m_active = false;
    public boolean m_enabled = false;
    public String m_enabledBy = "";
    public String m_disabledBy = "";
    public String m_uuid = null;
    public long m_isEnableTime = -1L;
    public long m_isEndTime = -1L;
    public int m_access = ACCESS_EDIT_DELETE;
    public Map<String, String> m_options = new LinkedHashMap<String, String>();

    public ServerPolicyStatus() {
    }

    public ServerPolicyStatus(ServerPolicyTemplate ap, int access) {
        this.m_uuid = ap.getID();
        this.m_active = ap.m_active.get();
        this.m_enabled = ap.m_enabled.get();
        this.m_enabledBy = ap.getEnabledBy();
        this.m_disabledBy = ap.getDisabledBy();
        this.m_isEnableTime = ap.getIsEnableTime();
        this.m_isEndTime = ap.getIsEndTime();
        this.m_access = access;
    }

    public Map<String, String> getOptions() {
        return this.m_options;
    }

    public void setOption(String name, String value) {
        this.m_options.put(name, value);
    }

    public String getOption(String name) {
        return this.m_options.get(name);
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        this.m_uuid = dis.readUTF();
        this.m_active = dis.readBoolean();
        this.m_enabled = dis.readBoolean();
        this.m_enabledBy = dis.readUTF();
        this.m_disabledBy = dis.readUTF();
        this.m_isEnableTime = dis.readLong();
        this.m_isEndTime = dis.readLong();
        this.m_access = dis.readInt();
        while (dis.readBoolean()) {
            String key = dis.readUTF();
            String value = dis.readUTF();
            this.m_options.put(key, value);
        }
        return this;
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        dos.writeUTF(this.m_uuid);
        dos.writeBoolean(this.m_active);
        dos.writeBoolean(this.m_enabled);
        dos.writeUTF(this.m_enabledBy);
        dos.writeUTF(this.m_disabledBy);
        dos.writeLong(this.m_isEnableTime);
        dos.writeLong(this.m_isEndTime);
        dos.writeInt(this.m_access);
        Iterator<Map.Entry<String, String>> it = this.m_options.entrySet().iterator();
        while (it.hasNext()) {
            dos.writeBoolean(true);
            Map.Entry<String, String> en = it.next();
            dos.writeUTF(en.getKey());
            dos.writeUTF(en.getValue());
        }
        dos.writeBoolean(false);
    }
}

