/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.log.LoggerMain;
import com.blixx.shared.ext.TimeMask;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.slf4j.Logger;

public class TimeMaskJsonAdapter
extends TypeAdapter<TimeMask> {
    private static final Logger logger = LoggerMain.getLogger(TimeMaskJsonAdapter.class);

    @Override
    public void write(JsonWriter jsonWriter, TimeMask timeMask) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name("mask");
        if (timeMask.mask != null) {
            jsonWriter.value(timeMask.mask);
        } else {
            jsonWriter.nullValue();
        }
        jsonWriter.endObject();
    }

    @Override
    public TimeMask read(JsonReader in) throws IOException {
        TimeMask tm = null;
        try {
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if ("mask".equals(name)) {
                    String value = in.nextString();
                    tm = new TimeMask(value);
                    continue;
                }
                in.skipValue();
            }
            in.endObject();
        }
        catch (Exception e) {
            logger.warn("TimeMask deserialization error", e);
        }
        return tm;
    }
}

