/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.io;

import com.blixx.log.RTLogger;
import com.blixx.shared.Cryptor;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SDataInputStream
implements DataInput,
AutoCloseable {
    public static final int MAX_BYTES_LENGTH = 250000000;
    public static final int MAX_STRING_LENGTH = 0x5000000;
    protected DataInputStream stream = null;
    protected int lastProtocolVersion = 1;
    private String secretKey = "";
    private boolean isTrace = false;
    private final byte[] intBuf = new byte[4];
    private final byte[] longBuf = new byte[8];

    protected SDataInputStream() {
    }

    public SDataInputStream(InputStream in) {
        this();
        this.setIS(in);
    }

    protected void setIS(InputStream in) {
        try {
            this.stream = new DataInputStream(in);
        }
        catch (Exception e) {
            RTLogger.print(1, "Error setting Stream ", e);
            System.exit(876);
        }
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public int getLastProtocolVersion() {
        return this.lastProtocolVersion;
    }

    public String readUTF(String defaultReturnValue) {
        String res = defaultReturnValue;
        try {
            res = this.readUTF();
        }
        catch (Exception e) {
            RTLogger.print(5, "", e);
        }
        return res;
    }

    @Override
    public String readUTF() throws IOException {
        int[] refProtocolVersion = new int[]{this.lastProtocolVersion};
        String result = Cryptor.readUTFV3(this, this.secretKey, refProtocolVersion);
        this.lastProtocolVersion = refProtocolVersion[0];
        if (this.isTrace) {
            RTLogger.print(5, String.valueOf(this) + " str(" + result + ")");
        }
        return result;
    }

    @Override
    public int readInt() throws IOException {
        this.stream.readFully(this.intBuf);
        int i = (this.intBuf[0] & 0xFF) << 24 | (this.intBuf[1] & 0xFF) << 16 | (this.intBuf[2] & 0xFF) << 8 | this.intBuf[3] & 0xFF;
        if (this.isTrace && i != -1) {
            RTLogger.print(5, String.valueOf(this) + " int(" + i + ")");
        }
        return i;
    }

    @Override
    public char readChar() throws IOException {
        return this.stream.readChar();
    }

    @Override
    public long readLong() throws IOException {
        this.stream.readFully(this.longBuf);
        long res = (long)(this.longBuf[0] & 0xFF) << 56 | (long)(this.longBuf[1] & 0xFF) << 48 | (long)(this.longBuf[2] & 0xFF) << 40 | (long)(this.longBuf[3] & 0xFF) << 32 | (long)(this.longBuf[4] & 0xFF) << 24 | (long)(this.longBuf[5] & 0xFF) << 16 | (long)(this.longBuf[6] & 0xFF) << 8 | (long)(this.longBuf[7] & 0xFF);
        if (this.isTrace && res != -1L) {
            RTLogger.print(5, String.valueOf(this) + " long(" + res + ")");
        }
        return res;
    }

    @Override
    public float readFloat() throws IOException {
        return this.stream.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.stream.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.stream.readLine();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.stream.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.stream.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.stream.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.stream.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.stream.readUnsignedShort();
    }

    public int read() throws IOException {
        int read = this.stream.read();
        if (this.isTrace && read != -1) {
            RTLogger.print(5, String.valueOf(this) + " intch(" + (char)read + ")");
        }
        return read;
    }

    public int read(byte[] v) throws IOException {
        return this.stream.read(v);
    }

    @Override
    public void readFully(byte[] v) throws IOException {
        this.stream.readFully(v);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.stream.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.stream.skipBytes(n);
    }

    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public boolean readFile(String fullPath) throws IOException {
        return Cryptor.readFile(this, fullPath, false, this.lastProtocolVersion, false, this.secretKey);
    }

    public boolean readFileEncoded(String fullPath) throws IOException {
        return Cryptor.readFile(this, fullPath, true, this.stream.readInt(), false, this.secretKey);
    }

    public boolean readFileEncoded(String fullPath, boolean append) throws IOException {
        return Cryptor.readFile(this, fullPath, true, this.stream.readInt(), append, this.secretKey);
    }

    public byte[] readFileToNULL(String fullPath) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ByteArrayOutputStream byteArrayOutputStream = baos;){
            byte[] inArr = new byte[]{};
            int blockSize = -1;
            while ((blockSize = this.readInt()) != -1) {
                RTLogger.print(1, "/DEV/NULL:> Reading bytes: %s file: $s", blockSize, fullPath);
                inArr = new byte[blockSize];
                this.stream.readFully(inArr);
                baos.write(inArr, 0, blockSize);
            }
        }
        catch (Exception e) {
            RTLogger.print(5, "", e);
        }
        return baos.toByteArray();
    }

    public void setSecretKey(String agentHash) {
        this.secretKey = agentHash;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean isTrace() {
        return this.isTrace;
    }

    public void setTrace(boolean trace) {
        this.isTrace = trace;
    }
}

