/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.jobs;

import com.blixx.shared.XMLFactory;
import com.blixx.shared.jobs.AbstractAttribute;
import com.blixx.shared.jobs.UnsupportedTypeException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ListAttribute
extends AbstractAttribute {
    public ListAttribute(String name, List<String> value, String label) {
        super(name, "list", value, label);
        if (this.m_value == null) {
            this.m_value = new ArrayList();
        }
    }

    @Override
    public void addValueToXML(Node parent) {
        ListAttribute.addList(parent, (List<String>)this.getValue());
    }

    @Override
    public List<String> getValue() {
        return (List)this.m_value;
    }

    @Override
    public void setValue(Object value) throws UnsupportedTypeException {
        if (value == null) {
            this.m_value = new ArrayList();
            return;
        }
        if (!(value instanceof List)) {
            throw new UnsupportedTypeException("Only List is supported for the ListAttribute");
        }
        this.m_value = (List)value;
    }

    public void addItem(String item) {
        this.getValue().add(item);
    }

    @Override
    public void parse(Element parent) {
        super.parse(parent);
        NodeList nl = parent.getElementsByTagName("value");
        if (nl.getLength() == 1) {
            Node value = nl.item(0);
            NodeList items = value.getChildNodes();
            for (int i = 0; i < items.getLength(); ++i) {
                Node ii = items.item(i);
                if (!(ii instanceof Element)) continue;
                this.addItem(XMLFactory.unescape(ii.getTextContent()));
            }
        }
    }

    public static void addList(Node parent, List<String> values) {
        Element eList = parent.getOwnerDocument().createElement("value");
        parent.appendChild(eList);
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            Element eValue = parent.getOwnerDocument().createElement("item");
            if (value != null) {
                eValue.setTextContent(value);
            }
            eList.appendChild(eValue);
        }
    }
}

