/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.jobs;

import com.blixx.shared.Cryptor;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.jobs.AbstractAttribute;
import com.blixx.shared.jobs.UnsupportedTypeException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PasswordAttribute
extends AbstractAttribute {
    public PasswordAttribute(String name, String value, String label) {
        super(name, "password", value, label);
        if (value != null && value.length() > 0) {
            this.m_value = Cryptor.encrypt2(value);
        }
    }

    @Override
    public void addValueToXML(Node parent) {
        PasswordAttribute.setAttr(parent, "value", (String)this.m_value);
    }

    @Override
    public String getValue() {
        String value2 = (String)this.m_value;
        if (value2 == null || value2.length() == 0) {
            return value2;
        }
        return Cryptor.decrypt(value2);
    }

    @Override
    public void setValue(Object value) throws UnsupportedTypeException {
        if (!(value instanceof String)) {
            throw new UnsupportedTypeException("Only String is supported for the PasswordAttribute");
        }
        String value2 = (String)value;
        if (value2 != null && value2.length() > 0) {
            value2 = Cryptor.encrypt2(value2);
        }
        this.m_value = value2;
    }

    @Override
    public void parse(Element parent) {
        super.parse(parent);
        NodeList nl = parent.getElementsByTagName("value");
        if (nl.getLength() == 1) {
            Node value = nl.item(0);
            this.m_value = XMLFactory.unescape(value.getTextContent());
        }
    }
}

