/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.pg;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObjectRef {
    private static Pattern m_parser = Pattern.compile("([\\w]+):(//)?(.*)");
    public int m_objectType = 0;
    public String m_path = null;
    public String m_id = null;
    public String m_type = null;
    public static int TYPE_POL = 1;
    public static int TYPE_ASN = 2;
    public static int TYPE_NGR = 3;
    public static int TYPE_AGT = 4;
    public static int TYPE_PKG = 5;
    public static int TYPE_GTO = 6;
    public static int TYPE_PGA = 7;
    public static int TYPE_FILE = 8;
    public static Map<String, Integer> m_typeMap = new HashMap<String, Integer>();

    public ObjectRef(String uri) throws URISyntaxException {
        Matcher m = m_parser.matcher(uri);
        if (m.matches()) {
            String m_type = m.group(1).toLowerCase();
            if (!m_typeMap.containsKey(m_type)) {
                throw new URISyntaxException("Unsupported URI type", m_type, -1);
            }
            String pat = m.group(3);
            if (pat == null || pat.length() == 0) {
                throw new URISyntaxException("Syntax error in the URI", uri, -1);
            }
            if ("//".equals(m.group(2))) {
                this.m_path = "/" + pat;
            } else {
                this.m_id = pat;
                if (this.m_id == null || this.m_id.length() == 0) {
                    throw new URISyntaxException("Syntax error in the URI", uri, -1);
                }
            }
        } else {
            throw new URISyntaxException("Syntax error in the URI", uri, -1);
        }
    }

    public int getType() {
        return this.m_objectType;
    }

    public String getTypeString() {
        return this.m_type;
    }

    public String getID() {
        return this.m_id;
    }

    public String getPath() {
        return this.m_path;
    }

    public static int getType(String typeString) {
        Integer res = m_typeMap.get(typeString);
        return res == null ? -1 : res;
    }

    static {
        m_typeMap.put("pol", TYPE_POL);
        m_typeMap.put("asn", TYPE_ASN);
        m_typeMap.put("ngr", TYPE_NGR);
        m_typeMap.put("agt", TYPE_AGT);
        m_typeMap.put("pkg", TYPE_PKG);
        m_typeMap.put("gto", TYPE_GTO);
        m_typeMap.put("pga", TYPE_PGA);
        m_typeMap.put("file", TYPE_FILE);
    }
}

