/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.pg;

import com.blixx.shared.IODataStream;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.pg.ObjectType;
import com.blixx.shared.pg.PGEntityPermissionFlag;
import com.blixx.shared.pg.PGItem;
import com.blixx.shared.pg.PowerGroupItemContainer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PowerGroup
implements IODataStream {
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String NAME = "NAME";
    public static final String ID = "ID";
    public String m_ID = null;
    public String m_name = null;
    public String m_description = null;
    Map<ObjectType, PowerGroupItemContainer> m_pool = new ConcurrentHashMap<ObjectType, PowerGroupItemContainer>();

    public PowerGroup(Map m) {
        if (m != null && m.size() != 0) {
            this.m_ID = (String)m.get(ID);
            this.m_name = (String)m.get(NAME);
            this.m_description = (String)m.get(DESCRIPTION);
        }
    }

    public PowerGroup(String name, String descr) {
        this.m_ID = UUID.randomUUID().toString();
        this.m_name = name;
        this.m_description = descr;
    }

    public void add(PGItem item) {
        PowerGroupItemContainer pgc = this.m_pool.get((Object)item.getObjectType());
        if (pgc == null) {
            pgc = new PowerGroupItemContainer();
            this.m_pool.put(item.getObjectType(), pgc);
        }
        pgc.add(item);
    }

    public boolean remove(PGItem item) {
        boolean removed = false;
        PowerGroupItemContainer pgc = this.m_pool.get((Object)item.getObjectType());
        if (pgc != null) {
            removed = pgc.remove(item);
        }
        return removed;
    }

    protected PowerGroupItemContainer getContainer(ObjectType type) {
        return this.m_pool.get((Object)type);
    }

    public boolean hasItems(ObjectType type) {
        PowerGroupItemContainer cont = this.getContainer(type);
        return cont == null ? false : cont.getTotalSize() > 0;
    }

    public Map<PGItem, Object> getItems(ObjectType type, PGEntityPermissionFlag flag) {
        PowerGroupItemContainer cont = this.getContainer(type);
        Map<PGItem, Object> res = new HashMap<PGItem, Object>(0);
        if (cont != null) {
            switch (flag) {
                case ENFORCE: {
                    res = cont.getPlusItems();
                    break;
                }
                case FILTER: {
                    res = cont.getFilterItems();
                    break;
                }
                case EXCLUSIVE: {
                    res = cont.getExclusiveItems();
                    break;
                }
                case RESTRICT: {
                    res = cont.getMinusItems();
                    break;
                }
            }
        }
        return res;
    }

    public Map<PGItem, Object> getExclusiveItems(ObjectType type) {
        return this.getItems(type, PGEntityPermissionFlag.EXCLUSIVE);
    }

    public List<PGItem> getAllItems() {
        LinkedList<PGItem> list = new LinkedList<PGItem>();
        for (PowerGroupItemContainer pc : this.m_pool.values()) {
            list.addAll(pc.getExclusiveItems().keySet());
            list.addAll(pc.getFilterItems().keySet());
            list.addAll(pc.getMinusItems().keySet());
            list.addAll(pc.getPlusItems().keySet());
        }
        return list;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PowerGroup)) {
            return false;
        }
        String objID = ((PowerGroup)obj).m_ID;
        return this.m_ID == null ? objID == null : this.m_ID.endsWith(objID);
    }

    public int hashCode() {
        return this.m_ID == null ? 0 : this.m_ID.hashCode();
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        this.m_ID = dis.readUTF();
        this.m_name = dis.readUTF();
        this.m_description = dis.readUTF();
        while (dis.readBoolean()) {
            PGItem pgi = new PGItem();
            pgi.read(dis);
            this.add(pgi);
        }
        return this;
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        dos.writeUTF(this.m_ID);
        dos.writeUTF(this.m_name);
        dos.writeUTF(this.m_description);
        List<PGItem> list = this.getAllItems();
        for (PGItem item : list) {
            dos.writeBoolean(true);
            item.send(dos);
        }
        dos.writeBoolean(false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_ID).append('|').append(this.m_name).append('\n');
        for (PGItem item : this.getAllItems()) {
            sb.append(item.toString()).append('\n');
        }
        return sb.toString();
    }
}

