/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.space;

import com.blixx.shared.ext.EventsAndStatus;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.IServiceStatus;
import com.blixx.shared.space.GCube;
import com.blixx.shared.space.Node;
import java.util.Properties;

public class Connection
implements Cloneable {
    public static final String Z_MINUS = "Z-";
    public static final String Z_PLUS = "Z+";
    public static final String X_MINUS = "X-";
    public static final String X_PLUS = "X+";
    public static final String Y_MINUS = "Y-";
    public static final String Y_PLUS = "Y+";
    private String m_sourceID = "";
    private String m_targetID = "";
    private String m_type = "Y+";
    private String m_subtype = "";
    private ForwardFilter m_filter = null;

    public Connection(String sourceID, String targetID, String type, String subtype) {
        this.m_sourceID = sourceID.intern();
        this.m_targetID = targetID.intern();
        if (type.equalsIgnoreCase(Y_PLUS) || type.equalsIgnoreCase(Y_MINUS) || type.equalsIgnoreCase(X_PLUS) || type.equalsIgnoreCase(X_MINUS) || type.equalsIgnoreCase(Z_PLUS) || type.equalsIgnoreCase(Z_MINUS)) {
            this.m_type = type;
        }
        this.m_subtype = subtype;
    }

    public String getID() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_sourceID).append("@");
        sb.append(this.m_type).append("@");
        sb.append(this.m_subtype).append("@");
        sb.append(this.m_targetID);
        return sb.toString();
    }

    public String getTagetID() {
        return this.m_targetID;
    }

    public String getSourceID() {
        return this.m_sourceID;
    }

    public String getType() {
        return this.m_type;
    }

    public String getSubType() {
        return this.m_subtype;
    }

    public boolean isPlus() {
        return this.m_type.endsWith("+");
    }

    public boolean equals(Object obj) {
        if (obj instanceof Connection) {
            Connection c = (Connection)obj;
            return this.getID().equals(c.getID()) && this.getType().equals(c.getType()) && this.getSubType().equals(c.getSubType());
        }
        return false;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public Properties getProperties() {
        if (this.m_filter == null) {
            return null;
        }
        return this.m_filter.getProperties();
    }

    public void addFilter(String name, String descr, String attr, String pattern) {
        Properties p = new Properties();
        p.setProperty("NAME", name);
        p.setProperty("DESCRIPTION", descr);
        p.setProperty("ATTRIBUTE", attr);
        p.setProperty("PATTERN", pattern);
        p.setProperty("FILTER_NUMBER", "1");
        this.m_filter = ForwardFilter.getInstance(p);
    }

    public void setFilter(ForwardFilter filter) {
        this.m_filter = filter;
    }

    public ForwardFilter getFilter() {
        return this.m_filter;
    }

    public boolean isFiltered() {
        return this.m_filter != null;
    }

    public EventsAndStatus getEventsFiltered(GCube cube) {
        EventsAndStatus list = new EventsAndStatus();
        Node target = cube.getNode(this.m_targetID);
        if (target != null) {
            IServiceStatus iss = (IServiceStatus)target.getObject();
            if (iss != null) {
                EventsAndStatus col = iss.getEvents();
                list.add(col, this.m_filter);
            } else {
                for (Connection sub_connection : target.getTargets()) {
                    list.add(sub_connection.getEventsFiltered(cube), sub_connection.getFilter());
                }
            }
        }
        return list;
    }

    public Connection clone() {
        Connection clone = new Connection(this.m_sourceID, this.m_targetID, this.m_type, this.m_subtype);
        clone.m_filter = this.m_filter;
        return clone;
    }
}

