/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.shared.SEventFwd;
import com.blixx.shared.utils.StatComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AStatisticClass {
    private String m_agentID = null;
    private int m_totalMsgs = 0;
    private Map<String, String> m_policiesWithType = null;
    private Map<String, Map<String, Integer>> m_policiesWithCond = null;
    private Map<String, List<Integer>> m_policiesWithSev = null;
    private List<Integer> m_globalSevs = null;
    private Map<String, Long> m_times = null;
    private static List<Integer> sevEmpty = new ArrayList<Integer>(6);

    public AStatisticClass(String agentID) {
        this.m_agentID = agentID;
        this.m_policiesWithType = new HashMap<String, String>();
        this.m_policiesWithCond = new HashMap<String, Map<String, Integer>>();
        this.m_policiesWithSev = new HashMap<String, List<Integer>>();
        this.m_globalSevs = new ArrayList<Integer>(sevEmpty);
        this.m_times = new HashMap<String, Long>();
    }

    public void addEvent(SEventFwd se) {
        int sevInt = se.getSeverityInt();
        if (sevInt < 0) {
            sevInt += 6;
        }
        if (sevInt < 0 || sevInt > 5) {
            return;
        }
        int count = this.m_globalSevs.get(sevInt);
        this.m_globalSevs.set(sevInt, count + 1);
        ++this.m_totalMsgs;
        String source = se.getSource();
        String[] params = source.split("\\Q:\\E", 3);
        if (params.length < 3) {
            return;
        }
        String type = params[0];
        String pName = params[1];
        String condID = params[2];
        if (!this.m_policiesWithType.containsKey(pName)) {
            this.m_policiesWithType.put(pName, type);
        }
        if (this.m_policiesWithCond.containsKey(pName)) {
            conditions = this.m_policiesWithCond.get(pName);
            if (conditions.containsKey(condID)) {
                Integer countI = (Integer)conditions.get(condID);
                conditions.put(condID, countI + 1);
            } else {
                conditions.put(condID, 1);
            }
        } else {
            conditions = new HashMap<String, Integer>();
            conditions.put(condID, 1);
            this.m_policiesWithCond.put(pName, conditions);
        }
        if (this.m_policiesWithSev.containsKey(pName)) {
            List<Integer> severities = this.m_policiesWithSev.get(pName);
            Integer currVal = severities.get(sevInt);
            severities.set(sevInt, currVal + 1);
        } else {
            ArrayList<Integer> sevs = new ArrayList<Integer>(sevEmpty);
            sevs.set(sevInt, 1);
            this.m_policiesWithSev.put(pName, sevs);
        }
    }

    public String getAgentID() {
        return this.m_agentID;
    }

    public int getMessageCount() {
        return this.m_totalMsgs;
    }

    public int getMessageCount(String pName) {
        int count = 0;
        List<Integer> sevs = this.m_policiesWithSev.get(pName);
        for (int i = 0; i < sevs.size(); ++i) {
            count += sevs.get(i).intValue();
        }
        return count;
    }

    public List<String> getTopPolicies(int number) {
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        LinkedList<String> topPolicies = new LinkedList();
        for (Map.Entry<String, List<Integer>> en : this.m_policiesWithSev.entrySet()) {
            String pName = en.getKey();
            List<Integer> severities = en.getValue();
            int count = 0;
            for (int jj = 0; jj < severities.size(); ++jj) {
                count += severities.get(jj).intValue();
            }
            tempMap.put(pName, count);
        }
        List<String> pSorted = StatComparator.sortMapByValue(tempMap, "DESCENDING");
        if (pSorted.size() < number) {
            number = pSorted.size();
        }
        topPolicies = pSorted.subList(0, number);
        return topPolicies;
    }

    public int getPolicyCount() {
        return this.m_policiesWithType.size();
    }

    public List<Integer> getSevCountGlobal() {
        return this.m_globalSevs;
    }

    public Map<String, List<Integer>> getPoliciesWithSev() {
        return this.m_policiesWithSev;
    }

    public Map<String, Integer> getConditions(String pName) {
        return this.m_policiesWithCond.get(pName);
    }

    public Map<String, String> getPoliciesWithType() {
        return this.m_policiesWithType;
    }

    public String getPolicyType(String pName) {
        return this.m_policiesWithType.get(pName);
    }

    public Map<String, Long> getTimes() {
        return this.m_times;
    }

    static {
        sevEmpty.add(0);
        sevEmpty.add(0);
        sevEmpty.add(0);
        sevEmpty.add(0);
        sevEmpty.add(0);
        sevEmpty.add(0);
    }
}

