/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.shared.utils.MD5;
import com.blixx.shared.utils.ShabalUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;

public class PolicyCRC {
    private static Set<String> IGNORE_POLICY_VERSION = new HashSet<String>();

    public static long doChecksum(String filePath) {
        return PolicyCRC.doChecksumCRC32(new File(filePath));
    }

    public static long doChecksumCRC32(File file) {
        return PolicyCRC.doChecksumCRC32(file, IGNORE_POLICY_VERSION);
    }

    public static long doChecksumCRC32(File file, Collection<String> ignoreLines) {
        long checksum = 0L;
        CRC32 cksum = new CRC32();
        try (FileReader fr = new FileReader(file);
             BufferedReader br = new BufferedReader(fr);){
            String line;
            while ((line = br.readLine()) != null) {
                boolean ignoreThisLine = false;
                for (String s : ignoreLines) {
                    if (!line.contains(s)) continue;
                    ignoreThisLine = true;
                    break;
                }
                if (ignoreThisLine) continue;
                line = line.trim().replaceAll("[\r\n]", "");
                cksum.update(line.getBytes());
            }
            checksum = cksum.getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return checksum;
    }

    public static String doChecksum(File file) {
        return PolicyCRC.doChecksum(file, IGNORE_POLICY_VERSION);
    }

    public static String doChecksum(File file, Collection<String> ignoreLines) {
        String checksum = "";
        MD5 cksum = new MD5();
        try (FileReader in = new FileReader(file);
             BufferedReader br = new BufferedReader(in);){
            String line;
            while ((line = br.readLine()) != null) {
                boolean ignoreThisLine = false;
                for (String s : ignoreLines) {
                    if (!line.contains(s)) continue;
                    ignoreThisLine = true;
                    break;
                }
                if (ignoreThisLine) continue;
                line = line.trim().replaceAll("[\r\n]", "");
                cksum.update(line.getBytes());
            }
            checksum = ShabalUtils.getHex(cksum);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return checksum;
    }

    static {
        IGNORE_POLICY_VERSION.add("POLICY_VERSION");
    }
}

