/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.utils.AStatisticClass;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.utils.HashMapMap;
import com.blixx.shared.utils.IResolveAgentID;
import com.blixx.shared.utils.IResolveConditionID;
import com.blixx.shared.utils.PStatisticClass;
import com.blixx.shared.utils.StatComparator;
import com.blixx.shared.utils.StatisticManager;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Statistics {
    private Map<String, AStatisticClass> m_aStatistics = null;
    private Map<String, PStatisticClass> m_pStatistics = null;
    private Map<String, SEvent> m_relevantMessages = null;
    private static String DESCENDING = "DESCENDING";
    private static List<Integer> sevEmpty = new ArrayList<Integer>(6);
    public static int LAST_MIN;
    public static int LAST_HOUR;
    public static int LAST_DAY;
    public static int LAST_WEEK;
    public static int LAST_MONTH;
    public int m_maxAgents = 10;
    public int m_maxPolicies = 10;
    private IResolveAgentID<AbstractAgentCard> m_agentIdResolver = null;
    private IResolveConditionID m_conditionIdResolver = null;
    private Set<String> m_visibleAgentIDs = null;
    Map<String, List<? extends AbstractAgentCard>> m_tempList = new HashMap<String, List<? extends AbstractAgentCard>>();
    public long timeRemember = 0L;

    public Statistics(IResolveAgentID<AbstractAgentCard> agentIDResolver, IResolveConditionID conditionIdResolver) {
        this.m_agentIdResolver = agentIDResolver;
        this.m_conditionIdResolver = conditionIdResolver;
        this.m_aStatistics = new HashMap<String, AStatisticClass>();
        this.m_pStatistics = new HashMap<String, PStatisticClass>();
        this.m_relevantMessages = new HashMap<String, SEvent>();
    }

    public Statistics(IResolveAgentID<AbstractAgentCard> agentIDResolver, IResolveConditionID conditionIdResolver, Iterator<? extends SEvent> iterator, List<String> visibleAgentIDs) {
        this(agentIDResolver, conditionIdResolver);
        if (visibleAgentIDs != null) {
            this.m_visibleAgentIDs = new HashSet<String>(visibleAgentIDs);
        }
        if (iterator == null) {
            return;
        }
        this.addStatistic(iterator);
    }

    public void setMaxAgents(int maxagents) {
        this.m_maxAgents = maxagents;
    }

    public void setMaxPolicies(int maxpol) {
        this.m_maxPolicies = maxpol;
    }

    public IResolveAgentID<AbstractAgentCard> getAgentIdResolver() {
        return this.m_agentIdResolver;
    }

    @Deprecated
    public void setAgentIdResolver(IResolveAgentID<AbstractAgentCard> mAgentIdResolver) {
        this.m_agentIdResolver = mAgentIdResolver;
    }

    public IResolveConditionID getConditionIdResolver() {
        return this.m_conditionIdResolver;
    }

    @Deprecated
    public void setConditionIdResolver(IResolveConditionID mConditionIdResolver) {
        this.m_conditionIdResolver = mConditionIdResolver;
    }

    public void addStatistic(Iterator<? extends SEvent> iterator) {
        long time = 0L;
        HashMapMap<String, AbstractAgentCard> externalCards = new HashMapMap<String, AbstractAgentCard>();
        for (AbstractAgentCard aac : this.m_agentIdResolver.getAgentCards().values()) {
            if (aac.getAgentPort() != 0) continue;
            for (String host : AbstractAgentCard.getAllHostnames(aac)) {
                externalCards.putV(host, aac);
            }
            for (String ip : AbstractAgentCard.getAllIPs(aac)) {
                externalCards.putV(ip, aac);
            }
        }
        while (iterator.hasNext()) {
            SEvent se = iterator.next();
            if (se == null) continue;
            try {
                String source = se.getSource();
                this.m_relevantMessages.put(se.getID(), se);
                if (source != null && (source.startsWith("Message") || source.startsWith("Monitor"))) {
                    String[] params = source.split("\\Q:\\E");
                    if (params.length < 3) continue;
                    this.processPolStats(se, params[1]);
                }
                long start = System.currentTimeMillis();
                this.proccessAgtStats(se, externalCards);
                time += System.currentTimeMillis() - start;
            }
            catch (Throwable e) {
                RTLogger.print(1, "", e);
            }
        }
        if (RTLogger.getCurrentLevel() >= 5) {
            RTLogger.print(5, "StatsAgt(ms): " + time + ". count of indi: " + this.m_relevantMessages.size());
        }
        this.m_tempList.clear();
    }

    private void processPolStats(SEvent se, String pName) {
        if (this.m_pStatistics.containsKey(pName)) {
            PStatisticClass pStats = this.m_pStatistics.get(pName);
            pStats.addEvent(se);
        } else {
            PStatisticClass pStats = new PStatisticClass(pName);
            pStats.addEvent(se);
            this.m_pStatistics.put(pName, pStats);
        }
    }

    private void proccessAgtStats(SEvent se, HashMapMap<String, AbstractAgentCard> externalHosts) {
        if (se instanceof SEventFwd) {
            Map<AbstractAgentCard, Object> map;
            SEventFwd sef = (SEventFwd)se;
            String agentID = sef.getT1();
            if (agentID != null && agentID.length() > 0) {
                this.rememberEvent(sef, agentID);
            }
            if ((map = externalHosts.getHashMap(sef.getNode())) != null && map.size() > 0) {
                for (AbstractAgentCard ac : map.keySet()) {
                    if (this.m_visibleAgentIDs != null && !this.m_visibleAgentIDs.contains(ac.getAgentID())) continue;
                    this.rememberEvent(sef, ac.getAgentID());
                }
            }
        }
    }

    private void rememberEvent(SEventFwd sef, String agentID) {
        if (this.m_aStatistics.containsKey(agentID)) {
            AStatisticClass aStats = this.m_aStatistics.get(agentID);
            aStats.addEvent(sef);
        } else {
            AStatisticClass aStats = new AStatisticClass(agentID);
            aStats.addEvent(sef);
            this.m_aStatistics.put(agentID, aStats);
        }
    }

    public List<String> getTopPolicies(int number) {
        LinkedList<String> topPolicies = new LinkedList<String>();
        HashMap<String, Integer> tmp = new HashMap<String, Integer>();
        for (Map.Entry<String, PStatisticClass> en : this.m_pStatistics.entrySet()) {
            PStatisticClass pStats = en.getValue();
            int msgCount = pStats.getMessageCount();
            tmp.put(pStats.getPolicyName(), msgCount);
        }
        List<String> sorted = StatComparator.sortMapByValue(tmp, DESCENDING);
        if (number > sorted.size()) {
            number = sorted.size();
        }
        for (int i = 0; i < number; ++i) {
            String pName = sorted.get(i);
            topPolicies.add(pName);
        }
        return topPolicies;
    }

    public List<String> getTopPolicies(int number, String agentID) {
        AStatisticClass agentStats = this.m_aStatistics.get(agentID);
        return agentStats.getTopPolicies(number);
    }

    public List<String[]> getTopAgents(int topCount) {
        LinkedList<String[]> topAgents = new LinkedList<String[]>();
        HashMap<String, Integer> tmp = new HashMap<String, Integer>();
        for (Map.Entry<String, AStatisticClass> en : this.m_aStatistics.entrySet()) {
            AStatisticClass aStats = en.getValue();
            int msgCount = aStats.getMessageCount();
            tmp.put(aStats.getAgentID(), msgCount);
        }
        List<String> sorted = StatComparator.sortMapByValue(tmp, DESCENDING);
        if (topCount > sorted.size()) {
            topCount = sorted.size();
        }
        for (int i = 0; i < topCount; ++i) {
            String agentID = sorted.get(i);
            String agentName = "";
            if (this.m_agentIdResolver != null) {
                agentName = this.m_agentIdResolver.resolve(agentID);
            }
            topAgents.add(new String[]{agentID, agentName});
        }
        return topAgents;
    }

    public Map<Long, SEvent> getAgentMessages(String agentID) {
        HashMap<Long, SEvent> events = new HashMap<Long, SEvent>();
        if (agentID == null || agentID.equals("")) {
            return events;
        }
        AStatisticClass aStats = this.m_aStatistics.get(agentID);
        Map<String, Long> times = aStats.getTimes();
        for (Map.Entry<String, Long> en : times.entrySet()) {
            String seID = en.getKey();
            long time = en.getValue();
            SEvent se = this.m_relevantMessages.get(seID);
            events.put(time, se);
        }
        return events;
    }

    public Map<Long, SEvent> getAgentMessages(String agentID, int period) {
        Long currTime;
        Map<Long, SEvent> events = new HashMap<Long, SEvent>();
        Long startTime = null;
        Long endTime = null;
        if (agentID == null || agentID.equals("")) {
            return events;
        }
        Calendar calendar = Calendar.getInstance();
        endTime = currTime = Long.valueOf(calendar.getTimeInMillis());
        switch (period) {
            case 0: {
                calendar.add(12, -1);
                startTime = calendar.getTimeInMillis();
                break;
            }
            case 1: {
                calendar.add(11, -1);
                startTime = calendar.getTimeInMillis();
                break;
            }
            case 2: {
                calendar.add(5, -1);
                startTime = calendar.getTimeInMillis();
                break;
            }
            case 3: {
                calendar.add(5, -7);
                startTime = calendar.getTimeInMillis();
                break;
            }
            case 4: {
                calendar.add(2, -1);
                startTime = calendar.getTimeInMillis();
                break;
            }
            default: {
                return events;
            }
        }
        if (startTime != null && endTime != null) {
            events = this.getAgentMessages(agentID, startTime, endTime);
        }
        return events;
    }

    public Map<Long, SEvent> getAgentMessages(String agentID, Long startTime, Long endTime) {
        HashMap<Long, SEvent> events = new HashMap<Long, SEvent>();
        if (agentID == null || agentID.equals("")) {
            return events;
        }
        AStatisticClass aStats = this.m_aStatistics.get(agentID);
        Map<String, Long> times = aStats.getTimes();
        for (Map.Entry<String, Long> en : times.entrySet()) {
            String seID = en.getKey();
            long seTime = en.getValue();
            if (seTime < startTime || seTime > endTime) continue;
            SEvent se = this.m_relevantMessages.get(seID);
            events.put(seTime, se);
        }
        return events;
    }

    public Map<Long, SEvent> getAgentMessagesBefore(String agentID, long timeMilliSec) {
        HashMap<Long, SEvent> events = new HashMap<Long, SEvent>();
        if (agentID == null || agentID.equals("")) {
            return events;
        }
        AStatisticClass aStats = this.m_aStatistics.get(agentID);
        Map<String, Long> times = aStats.getTimes();
        for (Map.Entry<String, Long> en : times.entrySet()) {
            String seID = en.getKey();
            long seTime = en.getValue();
            if (seTime >= timeMilliSec) continue;
            SEvent se = this.m_relevantMessages.get(seID);
            events.put(seTime, se);
        }
        return events;
    }

    public Map<Long, SEvent> getAgentMessagesAfter(String agentID, long timeMilliSec) {
        HashMap<Long, SEvent> events = new HashMap<Long, SEvent>();
        if (agentID == null || agentID.equals("")) {
            return events;
        }
        AStatisticClass aStats = this.m_aStatistics.get(agentID);
        Map<String, Long> times = aStats.getTimes();
        for (Map.Entry<String, Long> en : times.entrySet()) {
            String seID = en.getKey();
            long seTime = en.getValue();
            if (seTime <= timeMilliSec) continue;
            SEvent se = this.m_relevantMessages.get(seID);
            events.put(seTime, se);
        }
        return events;
    }

    public JsonArray topAgentsToJsonArray(int topA) {
        JsonArray ja = new JsonArray();
        StatisticManager sm = new StatisticManager(this.getAgentIdResolver(), this.getConditionIdResolver());
        sm.addAgentStatistic(this.m_aStatistics);
        List<String[]> topAgents = this.getTopAgents(topA);
        for (String[] arr : topAgents) {
            JsonObject agent = new JsonObject();
            String agentID = arr[0];
            AbstractAgentCard ac = this.getAgentIdResolver().getAgentCardByID(agentID);
            AStatisticClass aStats = sm.getAgentStats(agentID);
            agent.addProperty("id", aStats.getAgentID());
            agent.addProperty("label", arr[1]);
            String virtualAC = Boolean.toString(ac != null ? ac.getAgentPort() == 0 : false);
            agent.addProperty("virtual", virtualAC);
            agent.addProperty("total", aStats.getMessageCount());
            List<Integer> currSevArr = aStats.getSevCountGlobal();
            agent.addProperty("unknown", currSevArr.get(0));
            agent.addProperty("normal", currSevArr.get(1));
            agent.addProperty("warning", currSevArr.get(2));
            agent.addProperty("minor", currSevArr.get(3));
            agent.addProperty("major", currSevArr.get(4));
            agent.addProperty("critical", currSevArr.get(5));
            ja.add(agent);
        }
        return ja;
    }

    public String topAgentsToText(int topA) {
        StringBuilder sb = new StringBuilder();
        StatisticManager sm = new StatisticManager(this.getAgentIdResolver(), this.getConditionIdResolver());
        sm.addAgentStatistic(this.m_aStatistics);
        List<String[]> topAgents = this.getTopAgents(topA);
        for (String[] arr : topAgents) {
            String agentID = arr[0];
            AStatisticClass aStats = sm.getAgentStats(agentID);
            StringBuilder sb2 = new StringBuilder();
            sb2.append(arr[1]);
            sb2.append('=');
            sb2.append(aStats.getMessageCount());
            while (sb2.length() < 100) {
                sb2.append(' ');
            }
            sb.append((CharSequence)sb2);
            sb.append(" o=Agent");
            sb.append("   id=").append(aStats.getAgentID());
            sb.append('\n');
        }
        return sb.toString();
    }

    public String topPoliciesToText(int topA) {
        StringBuilder sb = new StringBuilder();
        List<String> generalTopPolicies = this.getTopPolicies(topA);
        for (String policyName : generalTopPolicies) {
            PStatisticClass pStats = this.m_pStatistics.get(policyName);
            StringBuilder sb2 = new StringBuilder();
            sb2.append(policyName);
            sb2.append('=');
            sb2.append(pStats.getMessageCount());
            while (sb2.length() < 100) {
                sb2.append(' ');
            }
            sb.append((CharSequence)sb2);
            sb.append(" o=Policy\n");
        }
        return sb.toString();
    }

    public String toHTML() {
        HashMap<String, String> statisticData = new HashMap<String, String>();
        try {
            StatisticManager sm = new StatisticManager(this.getAgentIdResolver(), this.getConditionIdResolver());
            sm.addAgentStatistic(this.m_aStatistics);
            sm.addPolicyStatistic(this.m_pStatistics);
            List<String[]> topAgents = this.getTopAgents(this.m_maxAgents);
            String topAgentsHTML = sm.getTopAgentsHTML(this.m_maxAgents, topAgents);
            statisticData.put("TOP_AGENTS", topAgentsHTML);
            Object agentDetailsHTML = "";
            Object agentArray = "\nvar agentDetailsHTML = new Array(";
            for (int i = 0; i < topAgents.size(); ++i) {
                String[] param = topAgents.get(i);
                String agentID = param[0];
                String agentName = param[1];
                List<String> topPolicies = this.getTopPolicies(this.m_maxPolicies, agentID);
                agentDetailsHTML = (String)agentDetailsHTML + sm.getAgentDetailsHTML(i, agentID, agentName, topPolicies);
                agentArray = (String)agentArray + "A" + i + ",";
            }
            if (((String)agentArray).endsWith(",")) {
                agentArray = ((String)agentArray).substring(0, ((String)agentArray).length() - 1);
            }
            agentArray = (String)agentArray + ");";
            agentDetailsHTML = (String)agentDetailsHTML + (String)agentArray;
            statisticData.put("AGENT_DETAILS", (String)agentDetailsHTML);
            List<String> generalTopPolicies = this.getTopPolicies(this.m_maxPolicies);
            String topPolicyTableHTML = sm.getTopPoliciesHTML(generalTopPolicies);
            statisticData.put("TOP_POLICIES", topPolicyTableHTML);
            StringBuilder policyDetailsHTML = new StringBuilder();
            Object policyArray = "\nvar policyDetailsHTML = new Array(";
            for (int i = 0; i < generalTopPolicies.size(); ++i) {
                String pName = generalTopPolicies.get(i);
                policyDetailsHTML.append(sm.getPolicyDetailsHTML(i, pName));
                policyArray = (String)policyArray + "P" + i + ",";
            }
            if (((String)policyArray).endsWith(",")) {
                policyArray = ((String)policyArray).substring(0, ((String)policyArray).length() - 1);
            }
            policyArray = (String)policyArray + ");";
            policyDetailsHTML.append((String)policyArray);
            statisticData.put("POLICIES_DETAILS", policyDetailsHTML.toString());
        }
        catch (Throwable e) {
            RTLogger.print(4, "Statistic generation error", e);
        }
        String htmlTemplate = this.loadTemplate("statistic.html", "no data");
        String html = this.replaceAll(htmlTemplate, statisticData);
        return html;
    }

    private String loadTemplate(String templateName, String defaultKey) {
        Object html = "";
        File template = new File("srv" + File.separator + "html" + File.separator + templateName);
        if (template.exists()) {
            try {
                html = FileUtils.readFile(template);
            }
            catch (Throwable e) {
                RTLogger.print(3, "Can't read template: " + templateName, e);
            }
        } else {
            html = "<html><body>" + defaultKey + "</body></html>";
        }
        return html;
    }

    private String replaceAll(String htmlTemplate, Map<String, String> params) {
        for (Map.Entry<String, String> en : params.entrySet()) {
            String name = en.getKey();
            String value = en.getValue();
            if (value == null) {
                value = "";
            }
            htmlTemplate = htmlTemplate.replace("[" + name + "]", value);
        }
        return htmlTemplate;
    }

    static {
        sevEmpty.add(0);
        sevEmpty.add(0);
        sevEmpty.add(0);
        sevEmpty.add(0);
        sevEmpty.add(0);
        sevEmpty.add(0);
        LAST_MIN = 0;
        LAST_HOUR = 1;
        LAST_DAY = 2;
        LAST_WEEK = 3;
        LAST_MONTH = 4;
    }
}

