/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.log.LoggerMain;
import com.blixx.shared.utils.AsfUtils;
import com.boom.SharedLocks;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;

public class ZIP {
    public static final String AGENT_CONF_DIR = "conf/";
    private final Logger logger = LoggerMain.getLogger(ZIP.class);
    public static final String DIRECTORY_IS_EMPTY = "Directory is empty";
    private final List<Pattern> exceptMasks = new ArrayList<Pattern>();
    private String specificAgentID = null;
    protected boolean isSpecificFound = false;

    public void addExceptionMask(String mask) {
        mask = mask.replace(".", "\\.");
        mask = mask.replace("*", ".*");
        mask = mask.replace("?", ".");
        Pattern p = Pattern.compile(mask);
        this.exceptMasks.add(p);
    }

    public void cleanExceptions() {
        this.exceptMasks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipAgent(String sourcePath, String targetZipPath, File agentJar, File agentConf, File agtTrustStore) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetZipPath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            sourcePath = sourcePath.replace('\\', File.separatorChar);
            sourcePath = sourcePath.replace('/', File.separatorChar);
            if (sourcePath.endsWith(File.separator)) {
                sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
            }
            this.zipFile(zos, agentJar, agentJar.getParentFile().getPath() + File.separatorChar);
            ZipEntry anEntry = new ZipEntry(AGENT_CONF_DIR);
            zos.putNextEntry(anEntry);
            this.zipFileInSpecificPath(zos, AGENT_CONF_DIR, agentConf);
            SharedLocks.agentTsFileLock.readLock().lock();
            try {
                if (agtTrustStore != null && agtTrustStore.exists() && agtTrustStore.isFile()) {
                    this.zipFileInSpecificPath(zos, AGENT_CONF_DIR, agtTrustStore);
                }
            }
            finally {
                SharedLocks.agentTsFileLock.readLock().unlock();
            }
            String zipRootPath = sourcePath + File.separatorChar;
            try {
                this.zipDir(sourcePath, zos, zipRootPath);
            }
            catch (FileNotFoundException e) {
                this.logger.debug("File not found: {}", (Object)zipRootPath, (Object)e);
            }
        }
    }

    public void zipDir(String sourcePath, String targetZipPath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetZipPath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            String srcPath = sourcePath;
            srcPath = srcPath.replace('\\', File.separatorChar);
            srcPath = srcPath.replace('/', File.separatorChar);
            if (srcPath.endsWith(File.separator)) {
                srcPath = srcPath.substring(0, srcPath.length() - 1);
            }
            String zipRootPath = srcPath + File.separator;
            this.zipDir(srcPath, zos, zipRootPath);
        }
    }

    public void zipDir(String sourcePath, List<String> onlySubDirs, String targetZipPath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetZipPath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            String srcPath = sourcePath;
            srcPath = srcPath.replace('\\', File.separatorChar);
            srcPath = srcPath.replace('/', File.separatorChar);
            if (srcPath.endsWith(File.separator)) {
                srcPath = srcPath.substring(0, srcPath.length() - 1);
            }
            String zipRootPath = srcPath + File.separator;
            for (String onlySubDir : onlySubDirs) {
                File f = new File(srcPath, onlySubDir);
                if (!f.exists() || !f.isDirectory()) continue;
                String filePath = f.getPath();
                String zipPath = f.getPath().replace(zipRootPath, "");
                ZipEntry anEntry = new ZipEntry(zipPath + "/");
                zos.putNextEntry(anEntry);
                try {
                    this.zipDir(filePath, zos, zipRootPath);
                }
                catch (FileNotFoundException e) {
                    this.logger.trace("FileNotFound src.dir {}, zipPath: {}", filePath, zipRootPath, e);
                }
            }
        }
    }

    public void zipDirZero(String sourcePath, String targetZipPath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetZipPath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            sourcePath = sourcePath.replace('\\', File.separatorChar);
            sourcePath = sourcePath.replace('/', File.separatorChar);
            if (sourcePath.endsWith(File.separator)) {
                sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
            }
            String zipRootPath = sourcePath + File.separator;
            this.zipDirZero(sourcePath, zos, zipRootPath);
        }
    }

    public void zipDirZero(String dir2zip, ZipOutputStream zos, String zipRootPath) throws IOException {
        File zipDir = new File(dir2zip);
        String[] dirList = zipDir.list();
        if (dirList == null || dirList.length == 0) {
            throw new FileNotFoundException("Directory is empty {" + dir2zip + "}");
        }
        for (String s : dirList) {
            File f = new File(zipDir, s);
            if (f.isDirectory()) {
                String filePath = f.getPath();
                String zipPath = f.getPath().replace(zipRootPath, "");
                ZipEntry anEntry = new ZipEntry(zipPath + "/");
                zos.putNextEntry(anEntry);
                this.zipDirZero(filePath, zos, zipRootPath);
                continue;
            }
            if (!this.exceptMasks.stream().noneMatch(pattern -> pattern.matcher(f.toPath().toAbsolutePath().toString()).matches())) continue;
            this.zipFileZero(zos, f, zipRootPath);
        }
    }

    public void zipDir(String dir2zip, ZipOutputStream zos, String zipRootPath) throws IOException {
        File zipDir = new File(dir2zip);
        String[] dirList = zipDir.list();
        if (dirList == null || dirList.length == 0) {
            throw new FileNotFoundException("Directory is empty {" + dir2zip + "}");
        }
        for (String s : dirList) {
            File f = new File(zipDir, s);
            if (f.isDirectory()) {
                String filePath;
                block7: {
                    filePath = f.getPath();
                    String zipPath = f.getPath().replace(zipRootPath, "");
                    ZipEntry anEntry = new ZipEntry(zipPath + "/");
                    try {
                        zos.putNextEntry(anEntry);
                    }
                    catch (ZipException e) {
                        if (e.getMessage() != null && e.getMessage().contains("duplicate entry")) break block7;
                        throw e;
                    }
                }
                try {
                    this.zipDir(filePath, zos, zipRootPath);
                }
                catch (FileNotFoundException e) {
                    this.logger.debug("", e);
                }
                continue;
            }
            if (!this.exceptMasks.stream().noneMatch(pattern -> pattern.matcher(f.toPath().toAbsolutePath().toString()).matches())) continue;
            this.zipFile(zos, f, zipRootPath);
        }
    }

    public void zipFiles(List<? extends Path> sourcePaths, String targetZipPath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetZipPath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (Path path : sourcePaths) {
                this.zipFile(zos, path.toFile(), path.getParent().toFile().getPath());
            }
        }
    }

    public void zipFile(ZipOutputStream zos, File f, String rootPath) throws IOException {
        InputStream fis;
        String zipPath = f.getPath().replace(rootPath, "");
        zipPath = zipPath.replace('\\', '/');
        ZipEntry anEntry = new ZipEntry(zipPath);
        zos.putNextEntry(anEntry);
        if (this.isForceAgentSpecificFilesProcessing() && f.getName().toLowerCase().endsWith(".asf")) {
            String data = AsfUtils.getAgentSpecificJson(f, this.specificAgentID);
            if (data == null) {
                fis = new FileInputStream(f);
            } else {
                fis = new ByteArrayInputStream(data.getBytes());
                this.isSpecificFound = true;
            }
        } else {
            fis = new FileInputStream(f);
        }
        try (FileInputStream fileInputStream = fis;){
            int bytesIn;
            byte[] readBuffer = new byte[64000];
            while ((bytesIn = ((InputStream)fis).read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
        }
    }

    public void zipStringData(ZipOutputStream zos, String data, String rootPath, String fileName) throws IOException {
        byte[] readBuffer = new byte[64000];
        int bytesIn = 0;
        try (ByteArrayInputStream fis = new ByteArrayInputStream(data.getBytes());){
            ZipEntry anEntry = new ZipEntry(rootPath + fileName);
            zos.putNextEntry(anEntry);
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
        }
    }

    public void zipFileZero(ZipOutputStream zos, File f, String rootPath) throws IOException {
        String zipPath = f.getPath().replace(rootPath, "");
        ZipEntry anEntry = new ZipEntry(zipPath);
        zos.putNextEntry(anEntry);
    }

    protected void zipFileInSpecificPath(ZipOutputStream zos, String specificZipPath, File f) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);){
            specificZipPath = ((String)specificZipPath).replace('\\', '/');
            if (!((String)specificZipPath).endsWith("/")) {
                specificZipPath = (String)specificZipPath + "/";
            }
            ZipEntry anEntry = new ZipEntry((String)specificZipPath + f.getName());
            zos.putNextEntry(anEntry);
            byte[] readBuffer = new byte[64000];
            int bytesIn = 0;
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
        }
    }

    public List<String> unzip(String zipFilePath, String destDirectory) throws IOException {
        ArrayList<String> extractedFiles = new ArrayList<String>();
        Path destDir = Paths.get(destDirectory, new String[0]);
        if (!Files.exists(destDir, new LinkOption[0])) {
            Files.createDirectories(destDir, new FileAttribute[0]);
        }
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String fname = entry.getName();
                if (!entry.isDirectory() && fname.startsWith("/")) {
                    fname = fname.substring(1);
                }
                Path filePath = destDir.resolve(fname);
                if (!entry.isDirectory()) {
                    this.extractFile(zipIn, filePath);
                    extractedFiles.add(filePath.toAbsolutePath().toString());
                } else {
                    Files.createDirectories(filePath, new FileAttribute[0]);
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        return extractedFiles;
    }

    private void extractFile(ZipInputStream zipIn, Path filePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath.toFile()));){
            byte[] bytesIn = new byte[65536];
            int read = 0;
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }

    public void deleteFilesExcept(List<String> doNotDeleteCanonicalPaths, String rootDir) throws IOException {
        Path targetD = Paths.get(rootDir, new String[0]);
        if (Files.exists(targetD, new LinkOption[0]) && Files.isDirectory(targetD, new LinkOption[0])) {
            List<Object> list = new ArrayList(0);
            try (Stream<Path> paths = Files.list(targetD);){
                list = paths.filter(path -> !doNotDeleteCanonicalPaths.contains(path.toAbsolutePath().toString())).toList();
            }
            for (Path path2 : list) {
                try {
                    String cname = path2.toAbsolutePath().toString();
                    if (Files.isDirectory(path2, new LinkOption[0])) {
                        this.deleteFilesExcept(doNotDeleteCanonicalPaths, cname);
                        Files.delete(path2);
                        continue;
                    }
                    if (!this.exceptMasks.stream().noneMatch(pattern -> pattern.matcher(cname).matches())) continue;
                    Files.delete(path2);
                }
                catch (Exception e) {
                    this.logger.debug("Can't delete file: {}", (Object)path2, (Object)e);
                }
            }
        }
    }

    public boolean isForceAgentSpecificFilesProcessing() {
        return this.specificAgentID != null;
    }

    public void setForceAgentSpecificFilesProcessing(String agentID) {
        this.specificAgentID = agentID;
        this.isSpecificFound = false;
    }

    public boolean isAgentSpecificFileFound() {
        return this.isSpecificFound;
    }
}

