/*
 * Decompiled with CFR 0.152.
 */
package com.boom.crt;

import com.blixx.log.RTLogger;
import com.boom.crt.KeyStoreBase;
import com.boom.crt.hlp.FileModificationChecker;
import com.boom.crt.hlp.KeyStoreUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Optional;

public class TrustStoreClient
extends KeyStoreBase {
    private Certificate latestCACertificate = null;
    private int ignoreCheckIntervalMs;
    private FileModificationChecker keyStoreModificationChecker;

    public TrustStoreClient(String keyStoreType, Path keyStorePath, String pwdEncrypted, int ignoreCheckIntervalMs) {
        super(keyStoreType, keyStorePath, pwdEncrypted);
        this.ignoreCheckIntervalMs = ignoreCheckIntervalMs;
    }

    public TrustStoreClient(String keyStoreType, Path keyStorePath, String pwdEncrypted) {
        this(keyStoreType, keyStorePath, pwdEncrypted, 10000);
    }

    @Override
    public void createKeyStore() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        super.createKeyStore();
        this.latestCACertificate = null;
        this.keyStoreModificationChecker = new FileModificationChecker(this.keyStorePath, this.ignoreCheckIntervalMs);
    }

    @Override
    public void loadKeyStore() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        super.loadKeyStore();
        this.latestCACertificate = null;
        this.keyStoreModificationChecker = new FileModificationChecker(this.keyStorePath, this.ignoreCheckIntervalMs);
    }

    @Override
    public void saveKeyStore() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        super.saveKeyStore();
        this.latestCACertificate = null;
    }

    @Override
    public KeyStore getKeyStore() {
        if (this.keyStoreModificationChecker != null && this.keyStoreModificationChecker.isChanged()) {
            try {
                this.loadKeyStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.keyStore;
    }

    public Certificate getLatestCACertificate() throws KeyStoreException {
        Optional<String> latestCAAlias;
        if (this.latestCACertificate == null && (latestCAAlias = KeyStoreUtils.getLatestCAAlias(this)).isPresent()) {
            this.latestCACertificate = this.getKeyStore().getCertificate(latestCAAlias.get());
        }
        return this.latestCACertificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLegacyKeyStore(Path legacyTS) {
        System.setProperty("keystore.pkcs12.legacy", "true");
        try {
            KeyStore caTSLegacy = KeyStore.getInstance(this.keyStoreType);
            caTSLegacy.load(null, null);
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                caTSLegacy.setCertificateEntry(alias, this.keyStore.getCertificate(alias));
            }
            try (OutputStream outputStream = Files.newOutputStream(legacyTS, new OpenOption[0]);){
                caTSLegacy.store(outputStream, this.getPwdArray());
            }
        }
        catch (Exception e) {
            RTLogger.print(1, "error writing legacy trusstore " + legacyTS.toAbsolutePath().toString(), e);
        }
        finally {
            System.setProperty("keystore.pkcs12.legacy", "false");
        }
    }
}

