/*
 * Decompiled with CFR 0.152.
 */
package com.boom.crt.hlp;

import com.boom.crt.hlp.BasicCertificateInfo;
import com.boom.crt.hlp.SubjectAlternativeNameEntry;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.stream.Collectors;
import sun.security.pkcs10.PKCS10;

public class CertificateSerializationHelper {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    public static final String DASHED_LINE = "\n------------------------------\n";

    private CertificateSerializationHelper() {
    }

    public static byte[] serializeCertificate(Certificate cert) throws IOException, CertificateEncodingException {
        byte[] result;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            Base64.Encoder encoder = Base64.getEncoder();
            bos.write(BEGIN_CERT.getBytes());
            bos.write(10);
            bos.write(encoder.encode(cert.getEncoded()));
            bos.write(END_CERT.getBytes());
            bos.write(10);
            bos.flush();
            result = bos.toByteArray();
        }
        return result;
    }

    public static byte[] serializeCertificates(Certificate[] certs) throws IOException, CertificateEncodingException {
        byte[] result;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            Base64.Encoder encoder = Base64.getEncoder();
            for (Certificate cert : certs) {
                bos.write(BEGIN_CERT.getBytes());
                bos.write(10);
                bos.write(encoder.encode(cert.getEncoded()));
                bos.write(END_CERT.getBytes());
                bos.write(10);
                bos.flush();
            }
            result = bos.toByteArray();
        }
        return result;
    }

    public static byte[] stripCertificateDelimiters(byte[] req) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(req);
             BufferedReader reader = new BufferedReader(new InputStreamReader(byteArrayInputStream));){
            String line;
            boolean started = false;
            while ((line = reader.readLine()) != null && !CertificateSerializationHelper.isCertificateRequestEnd(line)) {
                if (CertificateSerializationHelper.isCertificateRequestStart(line)) {
                    started = true;
                    continue;
                }
                if (!started) continue;
                builder.append(line);
            }
        }
        return builder.toString().getBytes();
    }

    public static Certificate[] decodeCertificates(byte[] certBytes) throws CertificateException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ArrayList<Certificate> certificates = new ArrayList<Certificate>(3);
        try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(certBytes));){
            while (bis.available() > 0) {
                Certificate cert = cf.generateCertificate(bis);
                certificates.add(cert);
            }
        }
        return certificates.toArray(new Certificate[0]);
    }

    private static boolean isCertificateRequestEnd(String line) {
        return line.startsWith("-----END") && line.contains("REQUEST-----");
    }

    private static boolean isCertificateRequestStart(String line) {
        return line.startsWith("-----BEGIN") && line.contains("REQUEST-----");
    }

    public static byte[] serializeCertificateRequest(PKCS10 certificateRequest) throws IOException, SignatureException {
        byte[] result;
        try (ByteArrayOutputStream bs = new ByteArrayOutputStream();
             PrintStream ps = new PrintStream(bs);){
            certificateRequest.print(ps);
            result = bs.toByteArray();
        }
        return result;
    }

    public static String certificateInfoToString(BasicCertificateInfo info) {
        StringBuilder builder = new StringBuilder();
        builder.append("Alias: ").append(info.getAlias()).append('\n');
        builder.append("Issuer: ").append(info.getIssuerName()).append('\n');
        builder.append("Subject: ").append(info.getSubjectName()).append('\n');
        builder.append("Valid: ").append(info.getValidFrom()).append(" - ").append(info.getValidTo()).append('\n');
        builder.append("SHA-1 Fingerprint: ").append(info.getSHA1Fingerprint()).append('\n');
        builder.append("SHA-256 Fingerprint: ").append(info.getSHA256Fingerprint()).append('\n');
        if (info.getAlternativeNames() != null && !info.getAlternativeNames().isEmpty()) {
            builder.append("Alternative names:\n");
            builder.append(info.getAlternativeNames().stream().map(SubjectAlternativeNameEntry::toString).collect(Collectors.joining("\n")));
        }
        return builder.toString();
    }
}

