/*
 * Decompiled with CFR 0.152.
 */
package com.boom.crt.hlp;

import com.boom.crt.GeneralNameParsingException;
import com.boom.crt.hlp.SubjectAlternativeNameExtension;
import java.io.IOException;
import sun.security.x509.DNSName;
import sun.security.x509.GeneralName;
import sun.security.x509.IPAddressName;
import sun.security.x509.OIDName;
import sun.security.x509.RFC822Name;
import sun.security.x509.URIName;

public class SubjectAlternativeNameEntry {
    private SubjectAlternativeNameExtension type;
    private String value;

    public SubjectAlternativeNameEntry(SubjectAlternativeNameExtension type, String value) {
        this.type = type;
        this.value = value;
    }

    public SubjectAlternativeNameExtension getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public GeneralName toGeneralName() throws GeneralNameParsingException, IOException {
        return switch (this.type) {
            case SubjectAlternativeNameExtension.EMAIL -> new GeneralName(new RFC822Name(this.value));
            case SubjectAlternativeNameExtension.URI -> new GeneralName(new URIName(this.value));
            case SubjectAlternativeNameExtension.DNS -> new GeneralName(new DNSName(this.value));
            case SubjectAlternativeNameExtension.IP -> new GeneralName(new IPAddressName(this.value));
            case SubjectAlternativeNameExtension.OID -> new GeneralName(new OIDName(this.value));
            default -> throw new GeneralNameParsingException("Could not process name san name " + this.value + " Type " + String.valueOf((Object)this.type) + " not supported");
        };
    }

    public String toString() {
        return String.valueOf((Object)this.type) + ": " + this.value;
    }
}

