/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom;

import com.blixx.log.RTLogger;
import com.blixx.server.db.Bytes;
import com.blixx.server.db.DBException;
import com.blixx.server.db.DBProperties;
import com.blixx.shared.SEventFwd;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public class Connector {
    DBProperties props = null;
    Connection connection = null;
    public static String ENCODING = "UTF-8";
    protected long lastQueryIsReady = 0L;
    protected AtomicBoolean enabled = new AtomicBoolean(true);

    public Connector(File file) {
        this.onInit(file);
    }

    public Connector(Properties prop) throws Exception {
        this.onInit(prop);
    }

    public synchronized DBProperties getDBProperties() {
        return this.props;
    }

    public synchronized String getHost() {
        return this.props.getHost();
    }

    public synchronized String getPort() {
        return this.props.getPort();
    }

    public synchronized String getUser() {
        return this.props.getLogin();
    }

    public synchronized String getP() {
        return this.props.getPassword();
    }

    public synchronized long getPoll() {
        if (this.props.getPoll() == null) {
            return 60000L;
        }
        long l = Long.parseLong(this.props.getPoll());
        if (l == 0L) {
            return 60000L;
        }
        return l * 1000L;
    }

    public void setEnabled(boolean enable) {
        this.enabled.compareAndSet(!enable, enable);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    protected synchronized boolean onInit(File file) {
        boolean isOK = false;
        this.props = new DBProperties(file);
        if (this.props.isValid()) {
            try {
                Class.forName(this.props.getDriverName()).newInstance();
                isOK = true;
                this.onOpen();
            }
            catch (Exception e) {
                RTLogger.print(1, "", e);
            }
        } else {
            RTLogger.print(1, "DB property file is invalid.");
        }
        return isOK;
    }

    protected synchronized boolean onInit(Properties properties) throws Exception {
        boolean isOK = false;
        this.props = new DBProperties(properties);
        if (!this.props.isValid()) {
            throw new Exception("DB property file is invalid.");
        }
        Class.forName(this.props.getDriverName()).newInstance();
        isOK = true;
        this.onOpen();
        return isOK;
    }

    public synchronized boolean onOpen() throws SQLException {
        boolean isOK = false;
        if (!this.enabled.get()) {
            return false;
        }
        if (this.connection == null || this.connection.isClosed()) {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            DriverManager.setLoginTimeout(3);
            Properties props = new Properties();
            props.setProperty("user", this.props.getLogin());
            props.setProperty("password", this.props.getPassword());
            props.setProperty("useUnicode", "true");
            props.setProperty("characterEncoding", "utf8");
            props.setProperty("rewriteBatchedStatements", "true");
            props.setProperty("useSSL", "false");
            this.connection = DriverManager.getConnection(this.props.getJdbc(), props);
            this.connection.setCatalog(this.props.getDbName());
            this.connection.setAutoCommit(true);
            try {
                DatabaseMetaData dbmd = this.connection.getMetaData();
                RTLogger.print(1, "JDBC Driver Name: " + dbmd.getDriverName());
                RTLogger.print(1, "JDBC Driver Version: " + dbmd.getDriverVersion());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        isOK = true;
        return isOK;
    }

    public synchronized void onClose() {
        try {
            this.connection.close();
        }
        catch (SQLException ex) {
            RTLogger.print(1, "Connection Error.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isReady() throws SQLException {
        boolean isready = false;
        if (!this.enabled.get()) {
            return false;
        }
        if (this.connection != null) {
            Statement stMain = null;
            ResultSet rs = null;
            try {
                if (!this.connection.isClosed()) {
                    long delta = System.currentTimeMillis() - this.lastQueryIsReady;
                    if (delta > 30000L) {
                        stMain = this.connection.createStatement(1003, 1007);
                        rs = stMain.executeQuery("SELECT \"TEST\"");
                        rs.next();
                        isready = true;
                        this.lastQueryIsReady = System.currentTimeMillis();
                    } else {
                        isready = true;
                    }
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (stMain != null) {
                    try {
                        stMain.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return isready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HashMap<String, Object> querySimple(String sql) throws SQLException {
        HashMap<String, Object> result = null;
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        Statement stMain = null;
        ResultSet rs = null;
        try {
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, sql);
            }
            stMain = this.connection.createStatement(1003, 1007);
            rs = stMain.executeQuery(sql);
            result = new HashMap<String, Object>();
            while (rs.next()) {
                String name = rs.getString(1);
                Object value = rs.getObject(2);
                result.put(name, value);
            }
            this.lastQueryIsReady = System.currentTimeMillis();
        }
        catch (SQLException e) {
            RTLogger.print(1, "", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (stMain != null) {
                try {
                    stMain.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return result;
    }

    public List<SEventFwd> readEvents(String sql, int seconds) throws SQLException {
        LinkedList<SEventFwd> result = null;
        if (!this.isReady() && !this.onOpen()) {
            return null;
        }
        Statement stMain = null;
        ResultSet rs = null;
        try {
            stMain = this.getStatementForReadArchived();
            stMain.setQueryTimeout(seconds);
            rs = stMain.executeQuery(sql);
            ResultSetMetaData rsMD = rs.getMetaData();
            result = new LinkedList<SEventFwd>();
            while (rs.next()) {
                SEventFwd sef = this.initSEventFwd(rs, rsMD);
                result.add(sef);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (stMain != null) {
                try {
                    stMain.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.lastQueryIsReady = System.currentTimeMillis();
        return result;
    }

    public Statement getStatementForReadArchived() throws SQLException {
        Statement stMain = null;
        stMain = this.connection.createStatement(1003, 1007);
        stMain.setFetchDirection(1001);
        stMain.setFetchSize(Integer.MIN_VALUE);
        return stMain;
    }

    public SEventFwd initSEventFwd(ResultSet rs, ResultSetMetaData rsMD) throws SQLException {
        Map<String, Object> row = this.processRS(rs, rsMD);
        SEventFwd sef = Connector.getSEvent(row);
        return sef;
    }

    public synchronized Map<String, SEventFwd> readEvents(String sql, Map<String, SEventFwd> putInHere) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            return null;
        }
        Statement stMain = null;
        ResultSet rs = null;
        try {
            stMain = this.connection.createStatement(1003, 1007);
            stMain.setFetchDirection(1001);
            try {
                stMain.setFetchSize(Integer.MIN_VALUE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            rs = stMain.executeQuery(sql);
            ResultSetMetaData rsMD = rs.getMetaData();
            while (rs.next()) {
                SEventFwd sef = this.initSEventFwd(rs, rsMD);
                if (putInHere.containsKey(sef.getID())) continue;
                putInHere.put(sef.getID(), sef);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (stMain != null) {
                try {
                    stMain.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.lastQueryIsReady = System.currentTimeMillis();
        return putInHere;
    }

    public synchronized LinkedList<Map<String, Object>> query(String sql) throws SQLException {
        LinkedList<Map<String, Object>> result = null;
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        Statement stMain = null;
        ResultSet rs = null;
        try {
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, sql);
            }
            stMain = this.connection.createStatement(1003, 1007);
            rs = stMain.executeQuery(sql);
            ResultSetMetaData rsMD = rs.getMetaData();
            result = new LinkedList<Map<String, Object>>();
            this.processResultSet(result, rs, rsMD);
            rs.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (stMain != null) {
                try {
                    stMain.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.lastQueryIsReady = System.currentTimeMillis();
        return result;
    }

    public synchronized LinkedList<Map<String, Object>> queryDirect(String sql, int timeoutSeconds) throws SQLException {
        LinkedList<Map<String, Object>> result = null;
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        Statement stMain = null;
        ResultSet rs = null;
        try {
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, sql);
            }
            stMain = this.connection.createStatement(1003, 1007);
            stMain.setQueryTimeout(timeoutSeconds);
            rs = stMain.executeQuery(sql);
            ResultSetMetaData rsMD = rs.getMetaData();
            result = new LinkedList<Map<String, Object>>();
            this.processResultSetDirect(result, rs, rsMD);
            rs.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (stMain != null) {
                try {
                    stMain.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.lastQueryIsReady = System.currentTimeMillis();
        return result;
    }

    public synchronized int execute(String sql) throws SQLException {
        int rows = -1;
        if (!this.isReady() && !this.onOpen()) {
            return rows;
        }
        Statement stMain = null;
        try {
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, sql);
            }
            stMain = this.connection.createStatement(1005, 1008);
            rows = stMain.executeUpdate(sql.replace("\\", "\\\\"));
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (stMain != null) {
                try {
                    stMain.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return rows;
    }

    public synchronized int execute(String sql, int timeout_seconds) throws SQLException {
        int rows = -1;
        if (!this.isReady() && !this.onOpen()) {
            return rows;
        }
        Statement stMain = null;
        try {
            stMain = this.connection.createStatement(1005, 1008);
            stMain.setQueryTimeout(timeout_seconds);
            rows = stMain.executeUpdate(sql.replace("\\", "\\\\"));
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (stMain != null) {
                try {
                    stMain.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return rows;
    }

    public synchronized int execute(String prepSql, Object[] values) throws SQLException {
        int rows = -1;
        if (!this.isReady() && !this.onOpen()) {
            return rows;
        }
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(prepSql);
            this.fillValues(values, ps);
            rows = ps.executeUpdate();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return rows;
    }

    public void fillValues(Object[] values, PreparedStatement ps) throws SQLException {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                ps.setNull(i + 1, 12);
                continue;
            }
            if (values[i] instanceof String) {
                if (values[i] == null) {
                    ps.setNull(i + 1, 12);
                    continue;
                }
                ps.setString(i + 1, (String)values[i]);
                continue;
            }
            if (values[i] instanceof Integer) {
                if (values[i] == null) {
                    ps.setNull(i + 1, 4);
                    continue;
                }
                ps.setInt(i + 1, (Integer)values[i]);
                continue;
            }
            if (values[i] instanceof Long) {
                if (values[i] == null) {
                    ps.setNull(i + 1, -5);
                    continue;
                }
                ps.setLong(i + 1, (Long)values[i]);
                continue;
            }
            if (values[i] instanceof Double) {
                if (values[i] == null) {
                    ps.setNull(i + 1, 8);
                    continue;
                }
                ps.setDouble(i + 1, (Double)values[i]);
                continue;
            }
            if (values[i] instanceof Timestamp) {
                if (values[i] == null) {
                    ps.setNull(i + 1, 93);
                    continue;
                }
                ps.setTimestamp(i + 1, (Timestamp)values[i]);
                continue;
            }
            if (!(values[i] instanceof Date)) continue;
            if (values[i] == null) {
                ps.setNull(i + 1, 91);
                continue;
            }
            ps.setTimestamp(i + 1, new Timestamp(((Date)values[i]).getTime()));
        }
    }

    public synchronized LinkedList<Map<String, Object>> query(String prepSql, Object[] values) throws SQLException {
        LinkedList<Map<String, Object>> result = null;
        int rows = -1;
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, prepSql);
            }
            ps = this.connection.prepareStatement(prepSql);
            this.fillValues(values, ps);
            rs = ps.executeQuery();
            ResultSetMetaData rsMD = rs.getMetaData();
            result = new LinkedList<Map<String, Object>>();
            this.processResultSet(result, rs, rsMD);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return result;
    }

    protected void processResultSet(LinkedList<Map<String, Object>> result, ResultSet rs, ResultSetMetaData rsMD) throws SQLException {
        while (rs.next()) {
            this.processRS(result, rs, rsMD);
        }
    }

    protected void processResultSetDirect(LinkedList<Map<String, Object>> result, ResultSet rs, ResultSetMetaData rsMD) throws SQLException {
        while (rs.next()) {
            this.processRS(result, rs, rsMD);
        }
    }

    protected void processRS(LinkedList<Map<String, Object>> result, ResultSet rs, ResultSetMetaData rsMD) throws SQLException {
        Map<String, Object> row = this.processRS(rs, rsMD);
        result.add(row);
    }

    protected Map<String, Object> processRS(ResultSet rs, ResultSetMetaData rsMD) throws SQLException {
        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
        for (int i = 1; i <= rsMD.getColumnCount(); ++i) {
            Object valueObj = null;
            String name = rsMD.getColumnName(i);
            name = name.replace('\'', ' ');
            name = name.replace('\"', ' ');
            name = name.trim();
            if (rsMD.getColumnType(i) == 2004 || rsMD.getColumnType(i) == -4) {
                try {
                    Blob b = rs.getBlob(i);
                    if (b != null) {
                        int bytesRead;
                        InputStream is = b.getBinaryStream();
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        byte[] data = new byte[is.available()];
                        while ((bytesRead = is.read(data, 0, data.length)) != -1) {
                            buffer.write(data, 0, bytesRead);
                        }
                        buffer.flush();
                        Bytes value = new Bytes(buffer.toByteArray());
                        valueObj = value;
                    }
                }
                catch (IOException e1) {
                    RTLogger.print(3, "DB blob read failed.", e1);
                }
            } else if (rsMD.getColumnType(i) != 2005) {
                valueObj = rsMD.getColumnType(i) == 91 || rsMD.getColumnType(i) == 93 ? rs.getTimestamp(i) : rs.getObject(i);
            }
            if (valueObj instanceof String && "".equals(valueObj)) {
                valueObj = "";
            }
            row.put(name, valueObj);
        }
        return row;
    }

    public synchronized void insertEvents(String prepSQL, Map<String, SEventFwd> events) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        this.connection.setAutoCommit(false);
        Statement ps = null;
        try {
            int com = 0;
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, prepSQL);
            }
            ps = this.connection.prepareStatement(prepSQL);
            Iterator<Map.Entry<String, SEventFwd>> it = events.entrySet().iterator();
            while (it.hasNext()) {
                SEventFwd se = it.next().getValue();
                this.prepInsertEvents((PreparedStatement)ps, se);
                ps.addBatch();
                if (++com <= 500) continue;
                com = 0;
                ps.executeBatch();
                this.connection.commit();
                ps.clearBatch();
            }
            if (com > 0) {
                ps.executeBatch();
                this.connection.commit();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            RTLogger.print(4, "Save indi rolled back", e);
            this.connection.rollback();
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
            this.connection.setAutoCommit(true);
        }
    }

    public void prepInsertEvents(PreparedStatement ps, SEventFwd se) throws SQLException {
        ps.setString(1, se.getID());
        ps.setString(2, se.getService());
        ps.setString(3, se.getNode());
        ps.setString(4, se.getApplication());
        ps.setString(5, se.getObject());
        ps.setString(6, se.getGroup());
        ps.setLong(7, se.getTime());
        ps.setString(8, se.getKeyConfigured());
        ps.setString(9, se.getCloseMask());
        ps.setInt(10, se.getSeverityInt());
        ps.setInt(11, se.getDuplicates());
        ps.setString(12, "" + se.getState());
        ps.setString(13, se.getInstructionID());
        ps.setString(14, se.getAutoAction());
        ps.setString(15, se.getOpAction());
        ps.setLong(16, se.getSTime());
        ps.setString(17, se.getSource());
        if (Double.isNaN(se.getValue())) {
            ps.setNull(18, 8);
        } else {
            ps.setDouble(18, se.getValue());
        }
        ps.setString(19, se.getMonitor());
        ps.setString(20, se.getAgentNode());
        ps.setInt(21, 0);
        ps.setInt(22, se.getTypeA());
        ps.setInt(23, se.getTypeK());
        ps.setLong(24, se.getTime());
        ps.setString(25, se.getText());
    }

    public synchronized void insertEventsExt(String prepSQL, Map<String, SEventFwd> events) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        this.connection.setAutoCommit(false);
        Statement ps = null;
        try {
            int com = 0;
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, prepSQL);
            }
            ps = this.connection.prepareStatement(prepSQL);
            Iterator<Map.Entry<String, SEventFwd>> it = events.entrySet().iterator();
            while (it.hasNext()) {
                SEventFwd se = it.next().getValue();
                this.prepInsertEventsExt((PreparedStatement)ps, se);
                ps.addBatch();
                if (++com <= 500) continue;
                com = 0;
                ps.executeBatch();
                this.connection.commit();
                ps.clearBatch();
            }
            if (com > 0) {
                ps.executeBatch();
                this.connection.commit();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            RTLogger.print(4, "Save Ext indi info rolled back", e);
            this.connection.rollback();
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
            this.connection.setAutoCommit(true);
        }
    }

    public void prepInsertEventsExt(PreparedStatement ps, SEventFwd se) throws SQLException {
        ps.setString(1, se.getID());
        ps.setString(2, se.getSrv());
        ps.setString(3, se.getSrvtype());
        ps.setString(4, se.getExtID());
        ps.setString(5, se.getT1());
        ps.setString(6, se.getT2());
        ps.setString(7, se.getT3());
        ps.setString(8, se.getT4());
        ps.setString(9, se.getT5());
        ps.setString(10, se.getT6());
        ps.setString(11, se.getT7());
        ps.setString(12, se.getT8());
        ps.setString(13, se.getT9());
        ps.setString(14, se.getT10());
        ps.setString(15, "" + se.getTFA());
        ps.setString(16, "" + se.getVFA());
        ps.setString(17, se.getCA1());
        ps.setString(18, se.getCA2());
        ps.setString(19, se.getCA3());
        ps.setString(20, se.getCA4());
        ps.setString(21, se.getCA5());
        ps.setString(22, se.getCA6());
        ps.setString(23, se.getCA7());
        ps.setString(24, se.getCA8());
        ps.setString(25, se.getCA9());
        ps.setString(26, se.getCA10());
        ps.setString(27, se.getCA11());
        ps.setString(28, se.getCA12());
        ps.setString(29, se.getCA13());
        ps.setString(30, se.getCA14());
        ps.setString(31, se.getCA15());
    }

    public synchronized void deleteArchived(String prepSQL, List<String> ids) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(prepSQL);
            for (String id : ids) {
                ps.setString(1, id);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public synchronized void updateDuplicates(String prepSQL, List<SEventFwd> events) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        if (RTLogger.getCurrentLevel() >= 6) {
            RTLogger.print(6, prepSQL);
        }
        this.connection.setAutoCommit(false);
        PreparedStatement ps = null;
        try {
            int com = 0;
            ps = this.connection.prepareStatement(prepSQL);
            for (SEventFwd se : events) {
                ps.setLong(1, se.getTime());
                ps.setInt(2, se.getDuplicates());
                ps.setLong(3, se.getSTime());
                ps.setString(4, se.getID());
                ps.addBatch();
                if (++com <= 500) continue;
                com = 0;
                RTLogger.print(4, "DB Update 500");
                ps.executeBatch();
                this.connection.commit();
                ps.clearBatch();
            }
            if (com > 0) {
                ps.executeBatch();
                this.connection.commit();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
            this.connection.setAutoCommit(true);
        }
    }

    public synchronized void insertBatchPrepared(String sql, List<Object[]> values) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        this.connection.setAutoCommit(false);
        Statement ps = null;
        try {
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, sql);
            }
            ps = this.connection.prepareStatement(sql);
            int com = 0;
            for (int i = 0; i < values.size(); ++i) {
                Object[] vs = values.get(i);
                this.fillValues(vs, (PreparedStatement)ps);
                ps.addBatch();
                if (++com <= 500) continue;
                ps.executeBatch();
                this.connection.commit();
                ps.clearBatch();
                com = 0;
            }
            if (com > 0) {
                ps.executeBatch();
                this.connection.commit();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            this.connection.rollback();
            RTLogger.print(2, "Transaction rolled back.");
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
            this.connection.setAutoCommit(true);
        }
    }

    public synchronized void insertBatchPreparedNoTransaction(String sql, List<Object[]> values) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        this.connection.setAutoCommit(false);
        Statement ps = null;
        try {
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, sql);
            }
            ps = this.connection.prepareStatement(sql);
            int com = 0;
            for (int i = 0; i < values.size(); ++i) {
                Object[] vs = values.get(i);
                this.fillValues(vs, (PreparedStatement)ps);
                ps.addBatch();
                if (++com <= 500) continue;
                long start = System.currentTimeMillis();
                int[] res = ps.executeBatch();
                this.connection.commit();
                ps.clearBatch();
                RTLogger.print(4, "BATCH for " + com + " records: " + (System.currentTimeMillis() - start));
                com = 0;
            }
            if (com > 0) {
                ps.executeBatch();
                this.connection.commit();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            RTLogger.print(2, "Batch failed.");
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
            this.connection.setAutoCommit(true);
        }
    }

    public synchronized void insertBatch(String[] sql) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        Statement stmt = null;
        try {
            this.connection.setAutoCommit(false);
            stmt = this.connection.createStatement();
            int com = 0;
            for (int i = 0; i < sql.length; ++i) {
                stmt.addBatch(sql[i].replace("\\", "\\\\"));
                if (++com <= 500) continue;
                stmt.executeBatch();
                this.connection.commit();
                stmt.clearBatch();
                com = 0;
            }
            if (com > 0) {
                stmt.executeBatch();
                this.connection.commit();
                stmt.clearBatch();
            }
        }
        catch (SQLException e) {
            this.connection.rollback();
            RTLogger.print(2, "Transaction rolled back.");
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
            this.connection.setAutoCommit(true);
        }
    }

    public synchronized void insertBatchNoTransaction(String[] sql) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            for (int i = 0; i < sql.length; ++i) {
                stmt.addBatch(sql[i].replace("\\", "\\\\"));
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            RTLogger.print(2, "Transaction rolled back.");
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    static SEventFwd getSEvent(Map<String, Object> map2) {
        String state;
        String ca;
        String vfa;
        String tfa;
        SEventFwd sef = new SEventFwd();
        sef.setSrv((String)map2.get("SRV"));
        sef.setSrvType((String)map2.get("SRVTYPE"));
        sef.setExtID((String)map2.get("EXTID"));
        String res = (String)map2.get("T1");
        if (res != null && res.length() > 0) {
            sef.setT1(res);
        }
        if ((res = (String)map2.get("T2")) != null && res.length() > 0) {
            sef.setT2(res);
        }
        if ((res = (String)map2.get("T3")) != null && res.length() > 0) {
            sef.setT3(res);
        }
        if ((res = (String)map2.get("T4")) != null && res.length() > 0) {
            sef.setT4(res);
        }
        if ((res = (String)map2.get("T5")) != null && res.length() > 0) {
            sef.setT5(res);
        }
        if ((res = (String)map2.get("T6")) != null && res.length() > 0) {
            sef.setT6(res);
        }
        if ((res = (String)map2.get("T7")) != null && res.length() > 0) {
            sef.setT7(res);
        }
        if ((res = (String)map2.get("T8")) != null && res.length() > 0) {
            sef.setT8(res);
        }
        if ((res = (String)map2.get("T9")) != null && res.length() > 0) {
            sef.setT9(res);
        }
        if ((res = (String)map2.get("T10")) != null && res.length() > 0) {
            sef.setT10(res);
        }
        if ((tfa = (String)map2.get("TFA")) != null) {
            try {
                long time = Long.parseLong(tfa);
                sef.setTFA(time);
            }
            catch (Throwable time) {
                // empty catch block
            }
        }
        if ((vfa = (String)map2.get("VFA")) != null) {
            try {
                double value = Double.parseDouble(vfa);
                sef.setVFA(value);
            }
            catch (Throwable value) {
                // empty catch block
            }
        }
        if ((ca = (String)map2.get("CA1")) != null) {
            sef.setCA1(ca);
        }
        if ((ca = (String)map2.get("CA2")) != null && ca.length() > 0) {
            sef.setCA2(ca);
        }
        if ((ca = (String)map2.get("CA3")) != null && ca.length() > 0) {
            sef.setCA3(ca);
        }
        if ((ca = (String)map2.get("CA4")) != null && ca.length() > 0) {
            sef.setCA4(ca);
        }
        if ((ca = (String)map2.get("CA5")) != null && ca.length() > 0) {
            sef.setCA5(ca);
        }
        if ((ca = (String)map2.get("CA6")) != null && ca.length() > 0) {
            sef.setCA6(ca);
        }
        if ((ca = (String)map2.get("CA7")) != null && ca.length() > 0) {
            sef.setCA7(ca);
        }
        if ((ca = (String)map2.get("CA8")) != null && ca.length() > 0) {
            sef.setCA8(ca);
        }
        if ((ca = (String)map2.get("CA9")) != null && ca.length() > 0) {
            sef.setCA9(ca);
        }
        if ((ca = (String)map2.get("CA10")) != null && ca.length() > 0) {
            sef.setCA10(ca);
        }
        if ((ca = (String)map2.get("CA11")) != null && ca.length() > 0) {
            sef.setCA11(ca);
        }
        if ((ca = (String)map2.get("CA12")) != null && ca.length() > 0) {
            sef.setCA12(ca);
        }
        if ((ca = (String)map2.get("CA13")) != null && ca.length() > 0) {
            sef.setCA13(ca);
        }
        if ((ca = (String)map2.get("CA14")) != null && ca.length() > 0) {
            sef.setCA14(ca);
        }
        if ((ca = (String)map2.get("CA15")) != null && ca.length() > 0) {
            sef.setCA15(ca);
        }
        sef.setID((String)map2.get("ID"));
        if (sef.getID() == null) {
            RTLogger.print(6, String.valueOf(map2));
        }
        sef.setCloseMask((String)map2.get("ACKKEY"));
        sef.setApplication((String)map2.get("APPLICATION"));
        sef.setAutoAction((String)map2.get("AUTOACTION"));
        Object o = map2.get("TIME");
        if (o instanceof Number) {
            sef.setTime(((Number)o).longValue());
        }
        if ((o = map2.get("DUPL")) instanceof Number) {
            sef.setDuplicate(((Number)o).intValue());
        }
        sef.setInstructionID((String)map2.get("INSTRUCTIONID"));
        sef.setGroup((String)map2.get("MSGGRP"));
        sef.setKey((String)map2.get("MSGKEY"));
        sef.setText((String)map2.get("MSGTEXT"));
        sef.setNode((String)map2.get("NODE"));
        sef.setObject((String)map2.get("OBJECT"));
        sef.setOpAction((String)map2.get("OPACTION"));
        sef.setService((String)map2.get("SERVICE"));
        sef.setSource((String)map2.get("SOURCE"));
        o = map2.get("SEVERITY");
        if (o instanceof Number) {
            sef.setSeverity(((Number)o).intValue());
        }
        if ((state = (String)map2.get("STATE")) == null || state.length() == 0) {
            sef.setState('-');
        } else {
            sef.setState(state.charAt(0));
        }
        o = map2.get("STIME");
        if (o instanceof Number) {
            sef.setSTime(((Number)o).longValue());
        }
        if ((o = map2.get("VALUE")) instanceof Number) {
            sef.setValue(((Number)o).doubleValue());
        }
        sef.setMonitor((String)map2.get("MONITOR"));
        sef.setAgentNode((String)map2.get("AGENTNODE"));
        o = map2.get("TYPE_A");
        if (o != null && o instanceof Number) {
            sef.setTypeA(((Number)o).intValue());
        } else {
            sef.setTypeA(0);
        }
        o = map2.get("TYPE_K");
        if (o != null && o instanceof Number) {
            sef.setTypeK(((Number)o).intValue());
        } else {
            sef.setTypeK(0);
        }
        o = map2.get("FTIME");
        if (o != null && o instanceof Number) {
            sef.setFirstTime(((Number)o).longValue());
        } else {
            sef.setFirstTime(sef.getTime());
        }
        if (sef.getAgentNode() == null || sef.getAgentNode().length() == 0) {
            sef.setAgentNode(sef.getNode());
        }
        try {
            Object count = map2.get("ANNOT");
            if (count != null) {
                int annotationCount = 0;
                if (o instanceof Number) {
                    annotationCount = ((Number)count).intValue();
                }
                if (annotationCount > 0) {
                    sef.setAnnotationFlag(true);
                }
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(6, "err258 ", e);
        }
        return sef;
    }

    public synchronized Connection getConnection() {
        return this.connection;
    }
}

