/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom;

import com.blixx.boom.Connector;
import com.blixx.boom.OraConnector;
import java.io.FileInputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class DB {
    boolean isOracle;
    Connector connector;

    public DB(String propertyFile) throws Exception {
        block7: {
            this.isOracle = false;
            this.connector = null;
            Properties dbProps = new Properties();
            try (FileInputStream inStream = new FileInputStream(propertyFile);){
                dbProps.load(inStream);
                String driver = dbProps.getProperty("Driver");
                if (driver != null && (driver.contains("mysql") || driver.contains("mariadb"))) {
                    this.connector = new Connector(dbProps);
                    break block7;
                }
                if (driver != null && driver.contains("oracle")) {
                    this.connector = new OraConnector(dbProps);
                    this.isOracle = true;
                    break block7;
                }
                throw new Exception("Unsupported database or corrupted property file: " + propertyFile);
            }
        }
    }

    public boolean isOnline() throws SQLException {
        return this.connector.onOpen() && this.connector.isReady();
    }

    public int execute(String sql) throws SQLException {
        return this.connector.execute(sql);
    }

    public LinkedList<Map<String, Object>> query(String sql) throws SQLException {
        return this.connector.query(sql);
    }

    public String getDefaultCatalog() {
        try {
            return this.connector.getConnection().getCatalog();
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

